/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.InstantRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.Vo2MaxRecordInternal;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.Set;

@Identifier(recordIdentifier=18)
public class Vo2MaxRecord
extends InstantRecord {
    private final int mMeasurementMethod;
    private final double mVo2MillilitersPerMinuteKilogram;

    private Vo2MaxRecord(@NonNull Metadata metadata, @NonNull Instant time, @NonNull ZoneOffset zoneOffset, int measurementMethod, double vo2MillilitersPerMinuteKilogram, boolean skipValidation) {
        super(metadata, time, zoneOffset, skipValidation);
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(time);
        Objects.requireNonNull(zoneOffset);
        ValidationUtils.validateIntDefValue(measurementMethod, Vo2MaxMeasurementMethod.VALID_TYPES, Vo2MaxMeasurementMethod.class.getSimpleName());
        if (!skipValidation) {
            ValidationUtils.requireInRange(vo2MillilitersPerMinuteKilogram, 0.0, 100.0, "vo2MillilitersPerMinuteKilogram");
        }
        this.mMeasurementMethod = measurementMethod;
        this.mVo2MillilitersPerMinuteKilogram = vo2MillilitersPerMinuteKilogram;
    }

    public int getMeasurementMethod() {
        return this.mMeasurementMethod;
    }

    public double getVo2MillilitersPerMinuteKilogram() {
        return this.mVo2MillilitersPerMinuteKilogram;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof Vo2MaxRecord)) {
            return false;
        }
        Vo2MaxRecord that = (Vo2MaxRecord)o;
        return this.getMeasurementMethod() == that.getMeasurementMethod() && Double.compare(that.getVo2MillilitersPerMinuteKilogram(), this.getVo2MillilitersPerMinuteKilogram()) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMeasurementMethod(), this.getVo2MillilitersPerMinuteKilogram());
    }

    public Vo2MaxRecordInternal toRecordInternal() {
        Vo2MaxRecordInternal recordInternal = (Vo2MaxRecordInternal)new Vo2MaxRecordInternal().setMetaData(this.getMetadata());
        recordInternal.setTime(this.getTime().toEpochMilli());
        recordInternal.setZoneOffset(this.getZoneOffset().getTotalSeconds());
        recordInternal.setMeasurementMethod(this.mMeasurementMethod);
        recordInternal.setVo2MillilitersPerMinuteKilogram(this.mVo2MillilitersPerMinuteKilogram);
        return recordInternal;
    }

    public static class Vo2MaxMeasurementMethod {
        public static final int MEASUREMENT_METHOD_OTHER = 0;
        public static final int MEASUREMENT_METHOD_METABOLIC_CART = 1;
        public static final int MEASUREMENT_METHOD_HEART_RATE_RATIO = 2;
        public static final int MEASUREMENT_METHOD_COOPER_TEST = 3;
        public static final int MEASUREMENT_METHOD_MULTISTAGE_FITNESS_TEST = 4;
        public static final int MEASUREMENT_METHOD_ROCKPORT_FITNESS_TEST = 5;
        public static final Set<Integer> VALID_TYPES = Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5));

        Vo2MaxMeasurementMethod() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Vo2MaxMeasurementMethodTypes {
        }
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mTime;
        private ZoneOffset mZoneOffset;
        private final int mMeasurementMethod;
        private final double mVo2MillilitersPerMinuteKilogram;

        public Builder(@NonNull Metadata metadata, @NonNull Instant time, int measurementMethod, double vo2MillilitersPerMinuteKilogram) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(time);
            this.mMetadata = metadata;
            this.mTime = time;
            this.mMeasurementMethod = measurementMethod;
            this.mVo2MillilitersPerMinuteKilogram = vo2MillilitersPerMinuteKilogram;
            this.mZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(time);
        }

        @NonNull
        public Builder setZoneOffset(@NonNull ZoneOffset zoneOffset) {
            Objects.requireNonNull(zoneOffset);
            this.mZoneOffset = zoneOffset;
            return this;
        }

        @NonNull
        public Builder clearZoneOffset() {
            this.mZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public Vo2MaxRecord buildWithoutValidation() {
            return new Vo2MaxRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mMeasurementMethod, this.mVo2MillilitersPerMinuteKilogram, true);
        }

        @NonNull
        public Vo2MaxRecord build() {
            return new Vo2MaxRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mMeasurementMethod, this.mVo2MillilitersPerMinuteKilogram, false);
        }
    }
}

