/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.annotation.NonNull;
import android.health.connect.datatypes.ExerciseCompletionGoal;
import android.health.connect.datatypes.units.Energy;
import android.health.connect.datatypes.units.Length;
import android.os.Parcel;
import java.time.Duration;

public abstract class ExerciseCompletionGoalInternal {
    @NonNull
    public abstract ExerciseCompletionGoal toExternalObject();

    public abstract int getTypeId();

    abstract void writeFieldsToParcel(@NonNull Parcel var1);

    public static ExerciseCompletionGoalInternal fromExternalObject(ExerciseCompletionGoal externalObject) {
        if (externalObject instanceof ExerciseCompletionGoal.DistanceGoal) {
            ExerciseCompletionGoal.DistanceGoal goal = (ExerciseCompletionGoal.DistanceGoal)externalObject;
            return new DistanceGoalInternal(goal.getDistance());
        }
        if (externalObject instanceof ExerciseCompletionGoal.DistanceWithVariableRestGoal) {
            ExerciseCompletionGoal.DistanceWithVariableRestGoal goal = (ExerciseCompletionGoal.DistanceWithVariableRestGoal)externalObject;
            return new DistanceWithVariableRestGoalInternal(goal.getDistance(), goal.getDuration());
        }
        if (externalObject instanceof ExerciseCompletionGoal.StepsGoal) {
            ExerciseCompletionGoal.StepsGoal goal = (ExerciseCompletionGoal.StepsGoal)externalObject;
            return new StepsGoalInternal(goal.getSteps());
        }
        if (externalObject instanceof ExerciseCompletionGoal.DurationGoal) {
            ExerciseCompletionGoal.DurationGoal goal = (ExerciseCompletionGoal.DurationGoal)externalObject;
            return new DurationGoalInternal(goal.getDuration());
        }
        if (externalObject instanceof ExerciseCompletionGoal.RepetitionsGoal) {
            ExerciseCompletionGoal.RepetitionsGoal goal = (ExerciseCompletionGoal.RepetitionsGoal)externalObject;
            return new RepetitionsGoalInternal(goal.getRepetitions());
        }
        if (externalObject instanceof ExerciseCompletionGoal.TotalCaloriesBurnedGoal) {
            ExerciseCompletionGoal.TotalCaloriesBurnedGoal goal = (ExerciseCompletionGoal.TotalCaloriesBurnedGoal)externalObject;
            return new TotalCaloriesBurnedGoalInternal(goal.getTotalCalories());
        }
        if (externalObject instanceof ExerciseCompletionGoal.ActiveCaloriesBurnedGoal) {
            ExerciseCompletionGoal.ActiveCaloriesBurnedGoal goal = (ExerciseCompletionGoal.ActiveCaloriesBurnedGoal)externalObject;
            return new ActiveCaloriesBurnedGoalInternal(goal.getActiveCalories());
        }
        if (externalObject instanceof ExerciseCompletionGoal.UnspecifiedGoal) {
            return UnspecifiedGoalInternal.INSTANCE;
        }
        return UnknownGoalInternal.INSTANCE;
    }

    public void writeToParcel(@NonNull Parcel parcel) {
        parcel.writeInt(this.getTypeId());
        this.writeFieldsToParcel(parcel);
    }

    @NonNull
    public static ExerciseCompletionGoalInternal readFromParcel(@NonNull Parcel parcel) {
        int goalTypeId = parcel.readInt();
        switch (goalTypeId) {
            case 2: {
                return DistanceGoalInternal.readFieldsFromParcel(parcel);
            }
            case 3: {
                return StepsGoalInternal.readFieldsFromParcel(parcel);
            }
            case 4: {
                return DurationGoalInternal.readFieldsFromParcel(parcel);
            }
            case 5: {
                return RepetitionsGoalInternal.readFieldsFromParcel(parcel);
            }
            case 6: {
                return TotalCaloriesBurnedGoalInternal.readFieldsFromParcel(parcel);
            }
            case 7: {
                return ActiveCaloriesBurnedGoalInternal.readFieldsFromParcel(parcel);
            }
            case 8: {
                return DistanceWithVariableRestGoalInternal.readFieldsFromParcel(parcel);
            }
            case 1: {
                return UnspecifiedGoalInternal.INSTANCE;
            }
        }
        return UnknownGoalInternal.INSTANCE;
    }

    public static class DistanceGoalInternal
    extends ExerciseCompletionGoalInternal {
        public static final int DISTANCE_GOAL_TYPE_ID = 2;
        private final Length mDistance;

        @Override
        void writeFieldsToParcel(@NonNull Parcel parcel) {
            parcel.writeDouble(this.mDistance.getInMeters());
        }

        @NonNull
        public static DistanceGoalInternal readFieldsFromParcel(@NonNull Parcel parcel) {
            return new DistanceGoalInternal(Length.fromMeters(parcel.readDouble()));
        }

        public DistanceGoalInternal(@NonNull Length distance) {
            this.mDistance = distance;
        }

        @NonNull
        public Length getDistance() {
            return this.mDistance;
        }

        @Override
        @NonNull
        public ExerciseCompletionGoal toExternalObject() {
            return new ExerciseCompletionGoal.DistanceGoal(this.mDistance);
        }

        @Override
        public int getTypeId() {
            return 2;
        }
    }

    public static class DistanceWithVariableRestGoalInternal
    extends ExerciseCompletionGoalInternal {
        public static final int DISTANCE_WITH_VARIABLE_REST_GOAL_TYPE_ID = 8;
        private final Length mDistance;
        private final Duration mDuration;

        @Override
        void writeFieldsToParcel(@NonNull Parcel parcel) {
            parcel.writeDouble(this.mDistance.getInMeters());
            parcel.writeLong(this.mDuration.toMillis());
        }

        @NonNull
        public static DistanceWithVariableRestGoalInternal readFieldsFromParcel(@NonNull Parcel parcel) {
            return new DistanceWithVariableRestGoalInternal(Length.fromMeters(parcel.readDouble()), Duration.ofMillis(parcel.readLong()));
        }

        public DistanceWithVariableRestGoalInternal(@NonNull Length distance, @NonNull Duration duration) {
            this.mDistance = distance;
            this.mDuration = duration;
        }

        @NonNull
        public Length getDistance() {
            return this.mDistance;
        }

        @NonNull
        public Duration getDuration() {
            return this.mDuration;
        }

        @Override
        @NonNull
        public ExerciseCompletionGoal toExternalObject() {
            return new ExerciseCompletionGoal.DistanceWithVariableRestGoal(this.mDistance, this.mDuration);
        }

        @Override
        public int getTypeId() {
            return 8;
        }
    }

    public static class StepsGoalInternal
    extends ExerciseCompletionGoalInternal {
        public static final int STEPS_GOAL_TYPE_ID = 3;
        private final int mSteps;

        @Override
        void writeFieldsToParcel(@NonNull Parcel parcel) {
            parcel.writeInt(this.mSteps);
        }

        @NonNull
        public static StepsGoalInternal readFieldsFromParcel(@NonNull Parcel parcel) {
            return new StepsGoalInternal(parcel.readInt());
        }

        public StepsGoalInternal(int steps) {
            this.mSteps = steps;
        }

        public int getSteps() {
            return this.mSteps;
        }

        @Override
        @NonNull
        public ExerciseCompletionGoal toExternalObject() {
            return new ExerciseCompletionGoal.StepsGoal(this.mSteps);
        }

        @Override
        public int getTypeId() {
            return 3;
        }
    }

    public static class DurationGoalInternal
    extends ExerciseCompletionGoalInternal {
        public static final int DURATION_GOAL_TYPE_ID = 4;
        private final Duration mDuration;

        @Override
        void writeFieldsToParcel(@NonNull Parcel parcel) {
            parcel.writeLong(this.mDuration.toMillis());
        }

        @NonNull
        public static DurationGoalInternal readFieldsFromParcel(@NonNull Parcel parcel) {
            return new DurationGoalInternal(Duration.ofMillis(parcel.readLong()));
        }

        public DurationGoalInternal(@NonNull Duration duration) {
            this.mDuration = duration;
        }

        @NonNull
        public Duration getDuration() {
            return this.mDuration;
        }

        @Override
        @NonNull
        public ExerciseCompletionGoal toExternalObject() {
            return new ExerciseCompletionGoal.DurationGoal(this.mDuration);
        }

        @Override
        public int getTypeId() {
            return 4;
        }
    }

    public static class RepetitionsGoalInternal
    extends ExerciseCompletionGoalInternal {
        public static final int REPETITIONS_GOAL_TYPE_ID = 5;
        private final int mReps;

        @Override
        void writeFieldsToParcel(@NonNull Parcel parcel) {
            parcel.writeInt(this.mReps);
        }

        @NonNull
        public static RepetitionsGoalInternal readFieldsFromParcel(@NonNull Parcel parcel) {
            return new RepetitionsGoalInternal(parcel.readInt());
        }

        public RepetitionsGoalInternal(int reps) {
            this.mReps = reps;
        }

        public int getReps() {
            return this.mReps;
        }

        @Override
        @NonNull
        public ExerciseCompletionGoal toExternalObject() {
            return new ExerciseCompletionGoal.RepetitionsGoal(this.mReps);
        }

        @Override
        public int getTypeId() {
            return 5;
        }
    }

    public static class TotalCaloriesBurnedGoalInternal
    extends ExerciseCompletionGoalInternal {
        public static final int TOTAL_CALORIES_BURNED_GOAL_TYPE_ID = 6;
        private final Energy mTotalCalories;

        @Override
        void writeFieldsToParcel(@NonNull Parcel parcel) {
            parcel.writeDouble(this.mTotalCalories.getInCalories());
        }

        @NonNull
        public static TotalCaloriesBurnedGoalInternal readFieldsFromParcel(@NonNull Parcel parcel) {
            return new TotalCaloriesBurnedGoalInternal(Energy.fromCalories(parcel.readDouble()));
        }

        public TotalCaloriesBurnedGoalInternal(@NonNull Energy totalCalories) {
            this.mTotalCalories = totalCalories;
        }

        @NonNull
        public Energy getTotalCalories() {
            return this.mTotalCalories;
        }

        @Override
        public ExerciseCompletionGoal toExternalObject() {
            return new ExerciseCompletionGoal.TotalCaloriesBurnedGoal(this.mTotalCalories);
        }

        @Override
        public int getTypeId() {
            return 6;
        }
    }

    public static class ActiveCaloriesBurnedGoalInternal
    extends ExerciseCompletionGoalInternal {
        public static final int ACTIVE_CALORIES_BURNED_GOAL_TYPE_ID = 7;
        private final Energy mActiveCalories;

        @Override
        void writeFieldsToParcel(@NonNull Parcel parcel) {
            parcel.writeDouble(this.mActiveCalories.getInCalories());
        }

        @NonNull
        public static ActiveCaloriesBurnedGoalInternal readFieldsFromParcel(@NonNull Parcel parcel) {
            return new ActiveCaloriesBurnedGoalInternal(Energy.fromCalories(parcel.readDouble()));
        }

        public ActiveCaloriesBurnedGoalInternal(@NonNull Energy activeCalories) {
            this.mActiveCalories = activeCalories;
        }

        @NonNull
        public Energy getActiveCalories() {
            return this.mActiveCalories;
        }

        @Override
        @NonNull
        public ExerciseCompletionGoal toExternalObject() {
            return new ExerciseCompletionGoal.ActiveCaloriesBurnedGoal(this.mActiveCalories);
        }

        @Override
        public int getTypeId() {
            return 7;
        }
    }

    public static class UnspecifiedGoalInternal
    extends ExerciseCompletionGoalInternal {
        public static final int UNSPECIFIED_GOAL_TYPE_ID = 1;
        public static final UnspecifiedGoalInternal INSTANCE = new UnspecifiedGoalInternal();

        @Override
        void writeFieldsToParcel(@NonNull Parcel parcel) {
        }

        UnspecifiedGoalInternal() {
        }

        @Override
        @NonNull
        public ExerciseCompletionGoal toExternalObject() {
            return ExerciseCompletionGoal.UnspecifiedGoal.INSTANCE;
        }

        @Override
        public int getTypeId() {
            return 1;
        }
    }

    public static class UnknownGoalInternal
    extends ExerciseCompletionGoalInternal {
        public static final int UNKNOWN_GOAL_TYPE_ID = 0;
        public static final UnknownGoalInternal INSTANCE = new UnknownGoalInternal();

        @Override
        void writeFieldsToParcel(@NonNull Parcel parcel) {
        }

        UnknownGoalInternal() {
        }

        @Override
        @NonNull
        public ExerciseCompletionGoal toExternalObject() {
            return ExerciseCompletionGoal.UnknownGoal.INSTANCE;
        }

        @Override
        public int getTypeId() {
            return 0;
        }
    }
}

