/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.HeartRateRecord;
import android.health.connect.datatypes.Identifier;
import android.health.connect.internal.datatypes.SeriesRecordInternal;
import android.os.Parcel;
import com.android.healthfitness.flags.Flags;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

@Identifier(recordIdentifier=11)
public class HeartRateRecordInternal
extends SeriesRecordInternal<HeartRateRecord, HeartRateRecord.HeartRateSample> {
    private Set<HeartRateSample> mHeartRateHeartRateSamples = new TreeSet<HeartRateSample>(Comparator.comparingLong(HeartRateSample::getEpochMillis));

    public HeartRateRecordInternal(Set<HeartRateSample> heartRateHeartRateSamples) {
        if (Flags.sampleTimeOrdering()) {
            this.mHeartRateHeartRateSamples.addAll(heartRateHeartRateSamples);
        } else {
            this.mHeartRateHeartRateSamples = heartRateHeartRateSamples;
        }
    }

    public HeartRateRecordInternal(Parcel parcel) {
        super(parcel);
        int size = parcel.readInt();
        if (!Flags.sampleTimeOrdering()) {
            this.mHeartRateHeartRateSamples = new HashSet<HeartRateSample>();
        }
        for (int i = 0; i < size; ++i) {
            this.mHeartRateHeartRateSamples.add(new HeartRateSample(parcel.readInt(), parcel.readLong()));
        }
    }

    @Override
    public Set<HeartRateSample> getSamples() {
        return this.mHeartRateHeartRateSamples;
    }

    @Override
    @NonNull
    public HeartRateRecord toExternalRecord() {
        return new HeartRateRecord.Builder(this.buildMetaData(), this.getStartTime(), this.getEndTime(), this.getExternalSamples()).setStartZoneOffset(this.getStartZoneOffset()).setEndZoneOffset(this.getEndZoneOffset()).buildWithoutValidation();
    }

    @Override
    void populateIntervalRecordTo(@NonNull Parcel parcel) {
        parcel.writeInt(this.mHeartRateHeartRateSamples.size());
        for (HeartRateSample heartRateSample : this.mHeartRateHeartRateSamples) {
            parcel.writeInt(heartRateSample.getBeatsPerMinute());
            parcel.writeLong(heartRateSample.getEpochMillis());
        }
    }

    private List<HeartRateRecord.HeartRateSample> getExternalSamples() {
        ArrayList<HeartRateRecord.HeartRateSample> heartRateRecords = new ArrayList<HeartRateRecord.HeartRateSample>(this.mHeartRateHeartRateSamples.size());
        for (HeartRateSample heartRateSample : this.mHeartRateHeartRateSamples) {
            heartRateRecords.add(new HeartRateRecord.HeartRateSample(heartRateSample.getBeatsPerMinute(), Instant.ofEpochMilli(heartRateSample.getEpochMillis()), true));
        }
        return heartRateRecords;
    }

    public static class HeartRateSample
    implements SeriesRecordInternal.Sample {
        private final int mBeatsPerMinute;
        private final long mEpochMillis;

        public HeartRateSample(int beatsPerMinute, long epochMillis) {
            this.mBeatsPerMinute = beatsPerMinute;
            this.mEpochMillis = epochMillis;
        }

        public int getBeatsPerMinute() {
            return this.mBeatsPerMinute;
        }

        public long getEpochMillis() {
            return this.mEpochMillis;
        }

        public boolean equals(@Nullable Object object) {
            if (object instanceof HeartRateSample) {
                HeartRateSample other = (HeartRateSample)object;
                if (Flags.sampleTimeOrdering()) {
                    return this.mEpochMillis == other.mEpochMillis && this.mBeatsPerMinute == other.mBeatsPerMinute;
                }
                return super.equals(other) && this.getEpochMillis() == other.getEpochMillis();
            }
            return false;
        }

        public int hashCode() {
            if (Flags.sampleTimeOrdering()) {
                return Objects.hash(this.mEpochMillis, this.mBeatsPerMinute);
            }
            return Objects.hash(this.getEpochMillis());
        }
    }
}

