/*
 * Decompiled with CFR 0.152.
 */
package android.internal.modules.utils.build;

import android.internal.modules.utils.build.SdkLevel;
import android.os._Original_Build;
import android.util.ArraySet;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.util.Set;

public class UnboundedSdkLevel {
    private static final SparseArray<Set<String>> PREVIOUS_CODENAMES = new SparseArray(4);
    private static final UnboundedSdkLevel sInstance;
    private final int mSdkInt;
    private final String mCodename;
    private final boolean mIsReleaseBuild;
    private final Set<String> mKnownCodenames;

    public static boolean isAtLeast(@NonNull String version) {
        return sInstance.isAtLeastInternal(version);
    }

    public static boolean isAtMost(@NonNull String version) {
        return sInstance.isAtMostInternal(version);
    }

    private static Set<String> setOf(String ... contents) {
        if (SdkLevel.isAtLeastR()) {
            return Set.of(contents);
        }
        ArraySet<String> set = new ArraySet<String>(contents.length);
        for (String codename : contents) {
            set.add(codename);
        }
        return set;
    }

    @VisibleForTesting
    UnboundedSdkLevel(int sdkInt, String codename, Set<String> knownCodenames) {
        this.mSdkInt = sdkInt;
        this.mCodename = codename;
        this.mIsReleaseBuild = "REL".equals(codename);
        this.mKnownCodenames = knownCodenames;
    }

    @VisibleForTesting
    boolean isAtLeastInternal(@NonNull String version) {
        version = this.removeFingerprint(version);
        if (this.mIsReleaseBuild) {
            if (this.isCodename(version)) {
                if (this.mKnownCodenames.contains(version)) {
                    throw new IllegalArgumentException("Artifact with a known codename " + version + " must be recompiled with a finalized integer version.");
                }
                return false;
            }
            return this.mSdkInt >= Integer.parseInt(version);
        }
        if (this.isCodename(version)) {
            return this.mKnownCodenames.contains(version);
        }
        return this.mSdkInt >= Integer.parseInt(version);
    }

    @VisibleForTesting
    boolean isAtMostInternal(@NonNull String version) {
        version = this.removeFingerprint(version);
        if (this.mIsReleaseBuild) {
            if (this.isCodename(version)) {
                if (this.mKnownCodenames.contains(version)) {
                    throw new IllegalArgumentException("Artifact with a known codename " + version + " must be recompiled with a finalized integer version.");
                }
                return true;
            }
            return this.mSdkInt <= Integer.parseInt(version);
        }
        if (this.isCodename(version)) {
            return !this.mKnownCodenames.contains(version) || this.mCodename.equals(version);
        }
        return this.mSdkInt < Integer.parseInt(version);
    }

    @VisibleForTesting
    String removeFingerprint(@NonNull String version) {
        int index;
        if (this.isCodename(version) && (index = version.indexOf(46)) != -1) {
            return version.substring(0, index);
        }
        return version;
    }

    private boolean isCodename(String version) {
        if (version.length() == 0) {
            throw new IllegalArgumentException();
        }
        return Character.isUpperCase(version.charAt(0));
    }

    static {
        PREVIOUS_CODENAMES.put(29, UnboundedSdkLevel.setOf("Q"));
        PREVIOUS_CODENAMES.put(30, UnboundedSdkLevel.setOf("Q", "R"));
        PREVIOUS_CODENAMES.put(31, UnboundedSdkLevel.setOf("Q", "R", "S"));
        PREVIOUS_CODENAMES.put(32, UnboundedSdkLevel.setOf("Q", "R", "S", "Sv2"));
        sInstance = new UnboundedSdkLevel(_Original_Build.VERSION.SDK_INT, _Original_Build.VERSION.CODENAME, SdkLevel.isAtLeastT() ? _Original_Build.VERSION.KNOWN_CODENAMES : PREVIOUS_CODENAMES.get(_Original_Build.VERSION.SDK_INT));
    }
}

