/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.NonNull;
import android.location.GnssStatus;
import android.location.GpsSatellite;
import android.util.SparseArray;
import java.util.Iterator;
import java.util.NoSuchElementException;

@Deprecated
public class GpsStatus {
    private static final int MAX_SATELLITES = 255;
    private static final int GLONASS_SVID_OFFSET = 64;
    private static final int BEIDOU_SVID_OFFSET = 200;
    private static final int SBAS_SVID_OFFSET = -87;
    private int mTimeToFirstFix;
    private final SparseArray<GpsSatellite> mSatellites = new SparseArray();
    private Iterable<GpsSatellite> mSatelliteList = () -> new SatelliteIterator();
    public static final int GPS_EVENT_STARTED = 1;
    public static final int GPS_EVENT_STOPPED = 2;
    public static final int GPS_EVENT_FIRST_FIX = 3;
    public static final int GPS_EVENT_SATELLITE_STATUS = 4;

    @NonNull
    public static GpsStatus create(@NonNull GnssStatus gnssStatus, int timeToFirstFix) {
        GpsStatus status = new GpsStatus();
        status.setStatus(gnssStatus, timeToFirstFix);
        return status;
    }

    @NonNull
    static GpsStatus createEmpty() {
        return new GpsStatus();
    }

    private GpsStatus() {
    }

    void setStatus(GnssStatus status, int timeToFirstFix) {
        int i;
        for (i = 0; i < this.mSatellites.size(); ++i) {
            this.mSatellites.valueAt((int)i).mValid = false;
        }
        this.mTimeToFirstFix = timeToFirstFix;
        for (i = 0; i < status.getSatelliteCount(); ++i) {
            int constellationType = status.getConstellationType(i);
            int prn = status.getSvid(i);
            if (constellationType == 3) {
                prn += 64;
            } else if (constellationType == 5) {
                prn += 200;
            } else if (constellationType == 2) {
                prn -= 87;
            } else if (constellationType != 1 && constellationType != 4) continue;
            if (prn <= 0 || prn > 255) continue;
            GpsSatellite satellite = this.mSatellites.get(prn);
            if (satellite == null) {
                satellite = new GpsSatellite(prn);
                this.mSatellites.put(prn, satellite);
            }
            satellite.mValid = true;
            satellite.mSnr = status.getCn0DbHz(i);
            satellite.mElevation = status.getElevationDegrees(i);
            satellite.mAzimuth = status.getAzimuthDegrees(i);
            satellite.mHasEphemeris = status.hasEphemerisData(i);
            satellite.mHasAlmanac = status.hasAlmanacData(i);
            satellite.mUsedInFix = status.usedInFix(i);
        }
    }

    public int getTimeToFirstFix() {
        return this.mTimeToFirstFix;
    }

    public Iterable<GpsSatellite> getSatellites() {
        return this.mSatelliteList;
    }

    public int getMaxSatellites() {
        return this.mSatellites.size();
    }

    private class SatelliteIterator
    implements Iterator<GpsSatellite> {
        private final int mSatellitesCount;
        private int mIndex = 0;

        SatelliteIterator() {
            this.mSatellitesCount = GpsStatus.this.mSatellites.size();
        }

        @Override
        public boolean hasNext() {
            while (this.mIndex < this.mSatellitesCount) {
                GpsSatellite satellite = GpsStatus.this.mSatellites.valueAt(this.mIndex);
                if (satellite.mValid) {
                    return true;
                }
                ++this.mIndex;
            }
            return false;
        }

        @Override
        public GpsSatellite next() {
            while (this.mIndex < this.mSatellitesCount) {
                GpsSatellite satellite = GpsStatus.this.mSatellites.valueAt(this.mIndex);
                ++this.mIndex;
                if (!satellite.mValid) continue;
                return satellite;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    @Deprecated
    public static interface NmeaListener {
        public void onNmeaReceived(long var1, String var3);
    }

    @Deprecated
    public static interface Listener {
        public void onGpsStatusChanged(int var1);
    }
}

