/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.media.AudioDescriptor;
import android.media.AudioDevicePort;
import android.media.AudioFormat;
import android.media.AudioProfile;
import android.media.AudioSystem;
import android.os._Original_Build;
import android.util.SparseIntArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.android.media.audio.Flags;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;

public class AudioDeviceInfo {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_BUILTIN_EARPIECE = 1;
    public static final int TYPE_BUILTIN_SPEAKER = 2;
    public static final int TYPE_WIRED_HEADSET = 3;
    public static final int TYPE_WIRED_HEADPHONES = 4;
    public static final int TYPE_LINE_ANALOG = 5;
    public static final int TYPE_LINE_DIGITAL = 6;
    public static final int TYPE_BLUETOOTH_SCO = 7;
    public static final int TYPE_BLUETOOTH_A2DP = 8;
    public static final int TYPE_HDMI = 9;
    public static final int TYPE_HDMI_ARC = 10;
    public static final int TYPE_USB_DEVICE = 11;
    public static final int TYPE_USB_ACCESSORY = 12;
    public static final int TYPE_DOCK = 13;
    public static final int TYPE_FM = 14;
    public static final int TYPE_BUILTIN_MIC = 15;
    public static final int TYPE_FM_TUNER = 16;
    public static final int TYPE_TV_TUNER = 17;
    public static final int TYPE_TELEPHONY = 18;
    public static final int TYPE_AUX_LINE = 19;
    public static final int TYPE_IP = 20;
    public static final int TYPE_BUS = 21;
    public static final int TYPE_USB_HEADSET = 22;
    public static final int TYPE_HEARING_AID = 23;
    public static final int TYPE_BUILTIN_SPEAKER_SAFE = 24;
    public static final int TYPE_REMOTE_SUBMIX = 25;
    public static final int TYPE_BLE_HEADSET = 26;
    public static final int TYPE_BLE_SPEAKER = 27;
    @RequiresPermission(value="android.permission.CAPTURE_AUDIO_OUTPUT")
    public static final int TYPE_ECHO_REFERENCE = 28;
    public static final int TYPE_HDMI_EARC = 29;
    public static final int TYPE_BLE_BROADCAST = 30;
    public static final int TYPE_DOCK_ANALOG = 31;
    @FlaggedApi(value="android.media.audio.enable_multichannel_group_device")
    public static final int TYPE_MULTICHANNEL_GROUP = 32;
    private final AudioDevicePort mPort;
    private static final SparseIntArray INT_TO_EXT_DEVICE_MAPPING = new SparseIntArray();
    private static final SparseIntArray EXT_TO_INT_DEVICE_MAPPING;
    private static final SparseIntArray EXT_TO_INT_INPUT_DEVICE_MAPPING;

    static boolean isValidAudioDeviceTypeOut(int type) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: {
                return true;
            }
        }
        return Flags.enableMultichannelGroupDevice() && type == 32;
    }

    static boolean isValidAudioDeviceTypeIn(int type) {
        switch (type) {
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: {
                return true;
            }
        }
        return false;
    }

    public static void enforceValidAudioDeviceTypeOut(int type) {
        if (!AudioDeviceInfo.isValidAudioDeviceTypeOut(type)) {
            throw new IllegalArgumentException("Illegal output device type " + type);
        }
    }

    public static void enforceValidAudioDeviceTypeIn(int type) {
        if (!AudioDeviceInfo.isValidAudioDeviceTypeIn(type)) {
            throw new IllegalArgumentException("Illegal input device type " + type);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioDeviceInfo that = (AudioDeviceInfo)o;
        return Objects.equals(this.getPort(), that.getPort());
    }

    public int hashCode() {
        return Objects.hash(this.getPort());
    }

    @VisibleForTesting
    public AudioDeviceInfo(AudioDevicePort port) {
        this.mPort = port;
    }

    public AudioDevicePort getPort() {
        return this.mPort;
    }

    public int getInternalType() {
        return this.mPort.type();
    }

    public int getId() {
        return this.mPort.handle().id();
    }

    public CharSequence getProductName() {
        String portName = this.mPort.name();
        return portName != null && portName.length() != 0 ? portName : _Original_Build.MODEL;
    }

    @NonNull
    public String getAddress() {
        return this.mPort.address();
    }

    public boolean isSource() {
        return this.mPort.role() == 1;
    }

    public boolean isSink() {
        return this.mPort.role() == 2;
    }

    @NonNull
    public int[] getSampleRates() {
        return this.mPort.samplingRates();
    }

    @NonNull
    public int[] getChannelMasks() {
        return this.mPort.channelMasks();
    }

    @NonNull
    public int[] getChannelIndexMasks() {
        return this.mPort.channelIndexMasks();
    }

    @NonNull
    public int[] getChannelCounts() {
        TreeSet<Integer> countSet = new TreeSet<Integer>();
        for (int mask : this.getChannelMasks()) {
            countSet.add(this.isSink() ? AudioFormat.channelCountFromOutChannelMask(mask) : AudioFormat.channelCountFromInChannelMask(mask));
        }
        for (int index_mask : this.getChannelIndexMasks()) {
            countSet.add(Integer.bitCount(index_mask));
        }
        int[] counts = new int[countSet.size()];
        int index = 0;
        Iterator iterator = countSet.iterator();
        while (iterator.hasNext()) {
            int count = (Integer)iterator.next();
            counts[index++] = count;
        }
        return counts;
    }

    @FlaggedApi(value="android.media.audio.speaker_layout_api")
    public int getSpeakerLayoutChannelMask() {
        return this.mPort.speakerLayoutChannelMask();
    }

    @NonNull
    public int[] getEncodings() {
        return AudioFormat.filterPublicFormats(this.mPort.formats());
    }

    @NonNull
    public List<AudioProfile> getAudioProfiles() {
        return this.mPort.profiles();
    }

    @NonNull
    public List<AudioDescriptor> getAudioDescriptors() {
        return this.mPort.audioDescriptors();
    }

    @NonNull
    public int[] getEncapsulationModes() {
        return this.mPort.encapsulationModes();
    }

    @NonNull
    public int[] getEncapsulationMetadataTypes() {
        return this.mPort.encapsulationMetadataTypes();
    }

    public int getType() {
        return INT_TO_EXT_DEVICE_MAPPING.get(this.mPort.type(), 0);
    }

    public static int convertDeviceTypeToInternalDevice(int deviceType) {
        return EXT_TO_INT_DEVICE_MAPPING.get(deviceType, 0);
    }

    public static int convertInternalDeviceToDeviceType(int intDevice) {
        return INT_TO_EXT_DEVICE_MAPPING.get(intDevice, 0);
    }

    public static int convertDeviceTypeToInternalInputDevice(int deviceType) {
        return AudioDeviceInfo.convertDeviceTypeToInternalInputDevice(deviceType, "");
    }

    public static int convertDeviceTypeToInternalInputDevice(int deviceType, String address) {
        int internalType = EXT_TO_INT_INPUT_DEVICE_MAPPING.get(deviceType, 0);
        if (internalType == -2147483644 && "back".equals(address)) {
            internalType = -2147483520;
        }
        return internalType;
    }

    public String toString() {
        return new String("AudioDeviceInfo: type: " + (this.isSink() ? AudioSystem.getOutputDeviceName(this.getInternalType()) : AudioSystem.getInputDeviceName(this.getInternalType())) + " addr: " + this.getAddress() + " id: " + this.getId());
    }

    static {
        INT_TO_EXT_DEVICE_MAPPING.put(1, 1);
        INT_TO_EXT_DEVICE_MAPPING.put(2, 2);
        INT_TO_EXT_DEVICE_MAPPING.put(4, 3);
        INT_TO_EXT_DEVICE_MAPPING.put(8, 4);
        INT_TO_EXT_DEVICE_MAPPING.put(16, 7);
        INT_TO_EXT_DEVICE_MAPPING.put(32, 7);
        INT_TO_EXT_DEVICE_MAPPING.put(64, 7);
        INT_TO_EXT_DEVICE_MAPPING.put(128, 8);
        INT_TO_EXT_DEVICE_MAPPING.put(256, 8);
        INT_TO_EXT_DEVICE_MAPPING.put(512, 8);
        INT_TO_EXT_DEVICE_MAPPING.put(1024, 9);
        INT_TO_EXT_DEVICE_MAPPING.put(2048, 31);
        INT_TO_EXT_DEVICE_MAPPING.put(4096, 13);
        INT_TO_EXT_DEVICE_MAPPING.put(8192, 12);
        INT_TO_EXT_DEVICE_MAPPING.put(16384, 11);
        INT_TO_EXT_DEVICE_MAPPING.put(0x4000000, 22);
        INT_TO_EXT_DEVICE_MAPPING.put(65536, 18);
        INT_TO_EXT_DEVICE_MAPPING.put(131072, 5);
        INT_TO_EXT_DEVICE_MAPPING.put(262144, 10);
        INT_TO_EXT_DEVICE_MAPPING.put(262145, 29);
        INT_TO_EXT_DEVICE_MAPPING.put(524288, 6);
        INT_TO_EXT_DEVICE_MAPPING.put(0x100000, 14);
        INT_TO_EXT_DEVICE_MAPPING.put(0x200000, 19);
        INT_TO_EXT_DEVICE_MAPPING.put(0x800000, 20);
        INT_TO_EXT_DEVICE_MAPPING.put(0x1000000, 21);
        INT_TO_EXT_DEVICE_MAPPING.put(0x8000000, 23);
        INT_TO_EXT_DEVICE_MAPPING.put(0x400000, 24);
        INT_TO_EXT_DEVICE_MAPPING.put(32768, 25);
        INT_TO_EXT_DEVICE_MAPPING.put(0x20000000, 26);
        INT_TO_EXT_DEVICE_MAPPING.put(0x20000001, 27);
        INT_TO_EXT_DEVICE_MAPPING.put(0x20000002, 30);
        if (Flags.enableMultichannelGroupDevice()) {
            INT_TO_EXT_DEVICE_MAPPING.put(0x800001, 32);
        }
        INT_TO_EXT_DEVICE_MAPPING.put(-2147483644, 15);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147483640, 7);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147483632, 3);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147483616, 9);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147483584, 18);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147483520, 15);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147483136, 31);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147482624, 13);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147481600, 12);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147479552, 11);
        INT_TO_EXT_DEVICE_MAPPING.put(-2113929216, 22);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147475456, 16);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147467264, 17);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147450880, 5);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147418112, 6);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147352576, 8);
        INT_TO_EXT_DEVICE_MAPPING.put(-2146959360, 20);
        INT_TO_EXT_DEVICE_MAPPING.put(-2146435072, 21);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147483392, 25);
        INT_TO_EXT_DEVICE_MAPPING.put(-1610612736, 26);
        INT_TO_EXT_DEVICE_MAPPING.put(-2013265920, 10);
        INT_TO_EXT_DEVICE_MAPPING.put(-2013265919, 29);
        INT_TO_EXT_DEVICE_MAPPING.put(-1879048192, 28);
        EXT_TO_INT_DEVICE_MAPPING = new SparseIntArray();
        EXT_TO_INT_DEVICE_MAPPING.put(1, 1);
        EXT_TO_INT_DEVICE_MAPPING.put(2, 2);
        EXT_TO_INT_DEVICE_MAPPING.put(3, 4);
        EXT_TO_INT_DEVICE_MAPPING.put(4, 8);
        EXT_TO_INT_DEVICE_MAPPING.put(5, 131072);
        EXT_TO_INT_DEVICE_MAPPING.put(6, 524288);
        EXT_TO_INT_DEVICE_MAPPING.put(7, 16);
        EXT_TO_INT_DEVICE_MAPPING.put(8, 128);
        EXT_TO_INT_DEVICE_MAPPING.put(9, 1024);
        EXT_TO_INT_DEVICE_MAPPING.put(10, 262144);
        EXT_TO_INT_DEVICE_MAPPING.put(29, 262145);
        EXT_TO_INT_DEVICE_MAPPING.put(11, 16384);
        EXT_TO_INT_DEVICE_MAPPING.put(22, 0x4000000);
        EXT_TO_INT_DEVICE_MAPPING.put(12, 8192);
        EXT_TO_INT_DEVICE_MAPPING.put(13, 4096);
        EXT_TO_INT_DEVICE_MAPPING.put(31, 2048);
        EXT_TO_INT_DEVICE_MAPPING.put(14, 0x100000);
        EXT_TO_INT_DEVICE_MAPPING.put(18, 65536);
        EXT_TO_INT_DEVICE_MAPPING.put(19, 0x200000);
        EXT_TO_INT_DEVICE_MAPPING.put(20, 0x800000);
        EXT_TO_INT_DEVICE_MAPPING.put(21, 0x1000000);
        EXT_TO_INT_DEVICE_MAPPING.put(23, 0x8000000);
        EXT_TO_INT_DEVICE_MAPPING.put(24, 0x400000);
        EXT_TO_INT_DEVICE_MAPPING.put(25, 32768);
        EXT_TO_INT_DEVICE_MAPPING.put(26, 0x20000000);
        EXT_TO_INT_DEVICE_MAPPING.put(27, 0x20000001);
        EXT_TO_INT_DEVICE_MAPPING.put(30, 0x20000002);
        if (Flags.enableMultichannelGroupDevice()) {
            EXT_TO_INT_DEVICE_MAPPING.put(32, 0x800001);
        }
        EXT_TO_INT_INPUT_DEVICE_MAPPING = new SparseIntArray();
        EXT_TO_INT_INPUT_DEVICE_MAPPING.put(15, -2147483644);
        EXT_TO_INT_INPUT_DEVICE_MAPPING.put(7, -2147483640);
        EXT_TO_INT_INPUT_DEVICE_MAPPING.put(3, -2147483632);
        EXT_TO_INT_INPUT_DEVICE_MAPPING.put(9, -2147483616);
        EXT_TO_INT_INPUT_DEVICE_MAPPING.put(18, -2147483584);
        EXT_TO_INT_INPUT_DEVICE_MAPPING.put(13, -2147482624);
        EXT_TO_INT_INPUT_DEVICE_MAPPING.put(31, -2147483136);
        EXT_TO_INT_INPUT_DEVICE_MAPPING.put(12, -2147481600);
        EXT_TO_INT_INPUT_DEVICE_MAPPING.put(11, -2147479552);
        EXT_TO_INT_INPUT_DEVICE_MAPPING.put(22, -2113929216);
        EXT_TO_INT_INPUT_DEVICE_MAPPING.put(16, -2147475456);
        EXT_TO_INT_INPUT_DEVICE_MAPPING.put(17, -2147467264);
        EXT_TO_INT_INPUT_DEVICE_MAPPING.put(5, -2147450880);
        EXT_TO_INT_INPUT_DEVICE_MAPPING.put(6, -2147418112);
        EXT_TO_INT_INPUT_DEVICE_MAPPING.put(8, -2147352576);
        EXT_TO_INT_INPUT_DEVICE_MAPPING.put(20, -2146959360);
        EXT_TO_INT_INPUT_DEVICE_MAPPING.put(21, -2146435072);
        EXT_TO_INT_INPUT_DEVICE_MAPPING.put(25, -2147483392);
        EXT_TO_INT_INPUT_DEVICE_MAPPING.put(26, -1610612736);
        EXT_TO_INT_INPUT_DEVICE_MAPPING.put(10, -2013265920);
        EXT_TO_INT_INPUT_DEVICE_MAPPING.put(29, -2013265919);
        EXT_TO_INT_INPUT_DEVICE_MAPPING.put(28, -1879048192);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @FlaggedApi(value="android.media.audio.speaker_layout_api")
    public static @interface SpeakerLayoutChannelMask {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AudioDeviceTypeOut {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AudioDeviceTypeIn {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AudioDeviceType {
    }
}

