/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.IPlayer;
import android.media.PlayerBase;
import android.media.PlayerProxy;
import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class AudioPlaybackConfiguration
implements Parcelable {
    private static final String TAG = new String("AudioPlaybackConfiguration");
    private static final boolean DEBUG = false;
    public static final int PLAYER_PIID_INVALID = -1;
    public static final int PLAYER_UPID_INVALID = -1;
    public static final int PLAYER_DEVICEID_INVALID = 0;
    public static final int[] PLAYER_DEVICEIDS_INVALID = new int[0];
    @SystemApi
    public static final int PLAYER_TYPE_UNKNOWN = -1;
    @SystemApi
    public static final int PLAYER_TYPE_JAM_AUDIOTRACK = 1;
    @SystemApi
    public static final int PLAYER_TYPE_JAM_MEDIAPLAYER = 2;
    @SystemApi
    public static final int PLAYER_TYPE_JAM_SOUNDPOOL = 3;
    @SystemApi
    public static final int PLAYER_TYPE_SLES_AUDIOPLAYER_BUFFERQUEUE = 11;
    @SystemApi
    public static final int PLAYER_TYPE_SLES_AUDIOPLAYER_URI_FD = 12;
    @SystemApi
    public static final int PLAYER_TYPE_AAUDIO = 13;
    public static final int PLAYER_TYPE_HW_SOURCE = 14;
    public static final int PLAYER_TYPE_EXTERNAL_PROXY = 15;
    @SystemApi
    public static final int PLAYER_STATE_UNKNOWN = -1;
    @SystemApi
    public static final int PLAYER_STATE_RELEASED = 0;
    @SystemApi
    public static final int PLAYER_STATE_IDLE = 1;
    @SystemApi
    public static final int PLAYER_STATE_STARTED = 2;
    @SystemApi
    public static final int PLAYER_STATE_PAUSED = 3;
    @SystemApi
    public static final int PLAYER_STATE_STOPPED = 4;
    public static final int PLAYER_UPDATE_DEVICE_ID = 5;
    public static final int PLAYER_UPDATE_PORT_ID = 6;
    public static final int PLAYER_UPDATE_MUTED = 7;
    public static final int PLAYER_UPDATE_FORMAT = 8;
    public static final String EXTRA_PLAYER_EVENT_SPATIALIZED = "android.media.extra.PLAYER_EVENT_SPATIALIZED";
    public static final String EXTRA_PLAYER_EVENT_SAMPLE_RATE = "android.media.extra.PLAYER_EVENT_SAMPLE_RATE";
    public static final String EXTRA_PLAYER_EVENT_CHANNEL_MASK = "android.media.extra.PLAYER_EVENT_CHANNEL_MASK";
    public static final String EXTRA_PLAYER_EVENT_MUTE = "android.media.extra.PLAYER_EVENT_MUTE";
    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public static final int MUTED_BY_MASTER = 1;
    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public static final int MUTED_BY_STREAM_VOLUME = 2;
    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public static final int MUTED_BY_STREAM_MUTED = 4;
    @SystemApi
    @FlaggedApi(value="android.media.audio.muted_by_port_volume_api")
    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public static final int MUTED_BY_OP_PLAY_AUDIO = 8;
    @SystemApi
    @Deprecated
    @FlaggedApi(value="android.media.audio.muted_by_port_volume_api")
    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public static final int MUTED_BY_APP_OPS = 8;
    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public static final int MUTED_BY_CLIENT_VOLUME = 16;
    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public static final int MUTED_BY_VOLUME_SHAPER = 32;
    @SystemApi
    @FlaggedApi(value="android.media.audio.muted_by_port_volume_api")
    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public static final int MUTED_BY_PORT_VOLUME = 64;
    @SystemApi
    @FlaggedApi(value="android.media.audio.muted_by_port_volume_api")
    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public static final int MUTED_BY_OP_CONTROL_AUDIO = 128;
    private final int mPlayerIId;
    private int mPlayerType;
    private int mClientUid;
    private int mClientPid;
    private IPlayerShell mIPlayerShell;
    private int mPlayerState;
    private AudioAttributes mPlayerAttr;
    private final Object mUpdateablePropLock = new Object();
    @GuardedBy(value={"mUpdateablePropLock"})
    @NonNull
    private int[] mDeviceIds = PLAYER_DEVICEIDS_INVALID;
    @GuardedBy(value={"mUpdateablePropLock"})
    private int mSessionId;
    @GuardedBy(value={"mUpdateablePropLock"})
    @NonNull
    private FormatInfo mFormatInfo;
    @GuardedBy(value={"mUpdateablePropLock"})
    private int mMutedState;
    public static PlayerDeathMonitor sPlayerDeathMonitor;
    @NonNull
    public static final Parcelable.Creator<AudioPlaybackConfiguration> CREATOR;

    public static String playerStateToString(int state) {
        switch (state) {
            case -1: {
                return "PLAYER_STATE_UNKNOWN";
            }
            case 0: {
                return "PLAYER_STATE_RELEASED";
            }
            case 1: {
                return "PLAYER_STATE_IDLE";
            }
            case 2: {
                return "PLAYER_STATE_STARTED";
            }
            case 3: {
                return "PLAYER_STATE_PAUSED";
            }
            case 4: {
                return "PLAYER_STATE_STOPPED";
            }
            case 5: {
                return "PLAYER_UPDATE_DEVICE_ID";
            }
            case 6: {
                return "PLAYER_UPDATE_PORT_ID";
            }
            case 7: {
                return "PLAYER_UPDATE_MUTED";
            }
            case 8: {
                return "PLAYER_UPDATE_FORMAT";
            }
        }
        return "invalid state " + state;
    }

    private AudioPlaybackConfiguration(int piid) {
        this.mPlayerIId = piid;
        this.mIPlayerShell = null;
    }

    public AudioPlaybackConfiguration(PlayerBase.PlayerIdCard pic, int piid, int uid, int pid) {
        this.mPlayerIId = piid;
        this.mPlayerType = pic.mPlayerType;
        this.mClientUid = uid;
        this.mClientPid = pid;
        this.mMutedState = 0;
        this.mDeviceIds = PLAYER_DEVICEIDS_INVALID;
        this.mPlayerState = 1;
        this.mPlayerAttr = pic.mAttributes;
        this.mIPlayerShell = sPlayerDeathMonitor != null && pic.mIPlayer != null ? new IPlayerShell(this, pic.mIPlayer) : null;
        this.mSessionId = pic.mSessionId;
        this.mFormatInfo = FormatInfo.DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        AudioPlaybackConfiguration audioPlaybackConfiguration = this;
        synchronized (audioPlaybackConfiguration) {
            if (this.mIPlayerShell != null) {
                this.mIPlayerShell.monitorDeath();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpdateableFields(int[] deviceIds, int sessionId, int mutedState, FormatInfo format) {
        Object object = this.mUpdateablePropLock;
        synchronized (object) {
            this.mDeviceIds = deviceIds;
            this.mSessionId = sessionId;
            this.mMutedState = mutedState;
            this.mFormatInfo = format;
        }
    }

    public static AudioPlaybackConfiguration anonymizedCopy(AudioPlaybackConfiguration in) {
        AudioPlaybackConfiguration anonymCopy = new AudioPlaybackConfiguration(in.mPlayerIId);
        anonymCopy.mPlayerState = in.mPlayerState;
        AudioAttributes.Builder builder = new AudioAttributes.Builder().setContentType(in.mPlayerAttr.getContentType()).setFlags(in.mPlayerAttr.getFlags()).setAllowedCapturePolicy(in.mPlayerAttr.getAllowedCapturePolicy() == 1 ? 1 : 3);
        if (AudioAttributes.isSystemUsage(in.mPlayerAttr.getSystemUsage())) {
            builder.setSystemUsage(in.mPlayerAttr.getSystemUsage());
        } else {
            builder.setUsage(in.mPlayerAttr.getUsage());
        }
        long testId = in.mPlayerAttr.getTestId();
        if (testId != Long.MIN_VALUE) {
            builder.setTestId(testId);
        }
        anonymCopy.mPlayerAttr = builder.build();
        anonymCopy.mPlayerType = -1;
        anonymCopy.mClientUid = -1;
        anonymCopy.mClientPid = -1;
        anonymCopy.mIPlayerShell = null;
        anonymCopy.setUpdateableFields(new int[0], 0, 0, FormatInfo.DEFAULT);
        return anonymCopy;
    }

    public AudioAttributes getAudioAttributes() {
        return this.mPlayerAttr;
    }

    @SystemApi
    public int getClientUid() {
        return this.mClientUid;
    }

    @SystemApi
    public int getClientPid() {
        return this.mClientPid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @FlaggedApi(value="android.media.audio.routed_device_ids")
    @Nullable
    public AudioDeviceInfo getAudioDeviceInfo() {
        int[] deviceIds;
        Object object = this.mUpdateablePropLock;
        synchronized (object) {
            deviceIds = this.mDeviceIds;
        }
        if (deviceIds.length == 0) {
            return null;
        }
        return AudioManager.getDeviceForPortId((int)deviceIds[0], (int)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @FlaggedApi(value="android.media.audio.routed_device_ids")
    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    @NonNull
    public List<AudioDeviceInfo> getAudioDeviceInfos() {
        int[] deviceIds;
        ArrayList<AudioDeviceInfo> audioDeviceInfos = new ArrayList<AudioDeviceInfo>();
        Object object = this.mUpdateablePropLock;
        synchronized (object) {
            deviceIds = this.mDeviceIds;
        }
        for (int i = 0; i < deviceIds.length; ++i) {
            AudioDeviceInfo audioDeviceInfo = AudioManager.getDeviceForPortId((int)deviceIds[i], (int)2);
            if (audioDeviceInfo == null) continue;
            audioDeviceInfos.add(audioDeviceInfo);
        }
        return audioDeviceInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public int getSessionId() {
        Object object = this.mUpdateablePropLock;
        synchronized (object) {
            return this.mSessionId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public boolean isMuted() {
        Object object = this.mUpdateablePropLock;
        synchronized (object) {
            return this.mMutedState != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public int getMutedBy() {
        Object object = this.mUpdateablePropLock;
        synchronized (object) {
            return this.mMutedState;
        }
    }

    @SystemApi
    public int getPlayerType() {
        switch (this.mPlayerType) {
            case 14: 
            case 15: {
                return -1;
            }
        }
        return this.mPlayerType;
    }

    @SystemApi
    public int getPlayerState() {
        return this.mPlayerState;
    }

    @SystemApi
    public int getPlayerInterfaceId() {
        return this.mPlayerIId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public PlayerProxy getPlayerProxy() {
        IPlayerShell ips;
        AudioPlaybackConfiguration audioPlaybackConfiguration = this;
        synchronized (audioPlaybackConfiguration) {
            ips = this.mIPlayerShell;
        }
        return ips == null ? null : new PlayerProxy(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public boolean isSpatialized() {
        Object object = this.mUpdateablePropLock;
        synchronized (object) {
            return this.mFormatInfo.mIsSpatialized;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public int getSampleRate() {
        Object object = this.mUpdateablePropLock;
        synchronized (object) {
            return this.mFormatInfo.mSampleRate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public int getChannelMask() {
        Object object = this.mUpdateablePropLock;
        synchronized (object) {
            return AudioFormat.convertNativeChannelMaskToOutMask(this.mFormatInfo.mNativeChannelMask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IPlayer getIPlayer() {
        IPlayerShell ips;
        AudioPlaybackConfiguration audioPlaybackConfiguration = this;
        synchronized (audioPlaybackConfiguration) {
            ips = this.mIPlayerShell;
        }
        return ips == null ? null : ips.getIPlayer();
    }

    public boolean handleAudioAttributesEvent(@NonNull AudioAttributes attr2) {
        boolean changed = !attr2.equals(this.mPlayerAttr);
        this.mPlayerAttr = attr2;
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleSessionIdEvent(int sessionId) {
        Object object = this.mUpdateablePropLock;
        synchronized (object) {
            boolean changed = sessionId != this.mSessionId;
            this.mSessionId = sessionId;
            return changed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMutedEvent(int mutedState) {
        Object object = this.mUpdateablePropLock;
        synchronized (object) {
            boolean changed = this.mMutedState != mutedState;
            this.mMutedState = mutedState;
            return changed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleFormatEvent(@NonNull FormatInfo fi) {
        Object object = this.mUpdateablePropLock;
        synchronized (object) {
            boolean changed = !this.mFormatInfo.equals(fi);
            this.mFormatInfo = fi;
            return changed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleStateEvent(int event, int[] deviceIds) {
        boolean changed = false;
        Object object = this.mUpdateablePropLock;
        synchronized (object) {
            if (event != 5) {
                changed = this.mPlayerState != event;
                this.mPlayerState = event;
            }
            if (event == 2 || event == 5) {
                changed = changed || !Arrays.equals(this.mDeviceIds, deviceIds);
                this.mDeviceIds = deviceIds;
            }
            if (changed && event == 0 && this.mIPlayerShell != null) {
                this.mIPlayerShell.release();
                this.mIPlayerShell = null;
            }
        }
        return changed;
    }

    private void playerDied() {
        if (sPlayerDeathMonitor != null) {
            sPlayerDeathMonitor.playerDeath(this.mPlayerIId);
        }
    }

    private boolean isMuteAffectingActiveState() {
        return (this.mMutedState & 0x10) != 0 || (this.mMutedState & 0x20) != 0 || (this.mMutedState & 8) != 0;
    }

    @SystemApi
    public boolean isActive() {
        switch (this.mPlayerState) {
            case 2: {
                return !this.isMuteAffectingActiveState();
            }
        }
        return false;
    }

    public void dump(PrintWriter pw) {
        pw.println("  " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.mUpdateablePropLock;
        synchronized (object) {
            return Objects.hash(this.mPlayerIId, Arrays.toString(this.mDeviceIds), this.mMutedState, this.mPlayerType, this.mClientUid, this.mClientPid, this.mSessionId);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Object object = this.mUpdateablePropLock;
        synchronized (object) {
            IPlayerShell ips;
            dest.writeInt(this.mPlayerIId);
            dest.writeIntArray(this.mDeviceIds);
            dest.writeInt(this.mMutedState);
            dest.writeInt(this.mPlayerType);
            dest.writeInt(this.mClientUid);
            dest.writeInt(this.mClientPid);
            dest.writeInt(this.mPlayerState);
            this.mPlayerAttr.writeToParcel(dest, 0);
            AudioPlaybackConfiguration audioPlaybackConfiguration = this;
            synchronized (audioPlaybackConfiguration) {
                ips = this.mIPlayerShell;
            }
            dest.writeStrongInterface(ips == null ? null : ips.getIPlayer());
            dest.writeInt(this.mSessionId);
            this.mFormatInfo.writeToParcel(dest, 0);
        }
    }

    private AudioPlaybackConfiguration(Parcel in) {
        this.mPlayerIId = in.readInt();
        this.mDeviceIds = new int[in.readInt()];
        for (int i = 0; i < this.mDeviceIds.length; ++i) {
            this.mDeviceIds[i] = in.readInt();
        }
        this.mMutedState = in.readInt();
        this.mPlayerType = in.readInt();
        this.mClientUid = in.readInt();
        this.mClientPid = in.readInt();
        this.mPlayerState = in.readInt();
        this.mPlayerAttr = AudioAttributes.CREATOR.createFromParcel(in);
        IPlayer p = IPlayer.Stub.asInterface(in.readStrongBinder());
        this.mIPlayerShell = p == null ? null : new IPlayerShell(null, p);
        this.mSessionId = in.readInt();
        this.mFormatInfo = FormatInfo.CREATOR.createFromParcel(in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof AudioPlaybackConfiguration)) {
            return false;
        }
        AudioPlaybackConfiguration that = (AudioPlaybackConfiguration)o;
        return this.mPlayerIId == that.mPlayerIId && Arrays.equals(this.mDeviceIds, that.mDeviceIds) && this.mMutedState == that.mMutedState && this.mPlayerType == that.mPlayerType && this.mClientUid == that.mClientUid && this.mClientPid == that.mClientPid && this.mSessionId == that.mSessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder apcToString = new StringBuilder();
        Object object = this.mUpdateablePropLock;
        synchronized (object) {
            apcToString.append("AudioPlaybackConfiguration piid:").append(this.mPlayerIId).append(" deviceIds:").append(Arrays.toString(this.mDeviceIds)).append(" type:").append(AudioPlaybackConfiguration.toLogFriendlyPlayerType(this.mPlayerType)).append(" u/pid:").append(this.mClientUid).append("/").append(this.mClientPid).append(" state:").append(AudioPlaybackConfiguration.toLogFriendlyPlayerState(this.mPlayerState)).append(" attr:").append(this.mPlayerAttr).append(" sessionId:").append(this.mSessionId).append(" mutedState:");
            if (this.mMutedState == 0) {
                apcToString.append("none ");
            } else {
                if ((this.mMutedState & 1) != 0) {
                    apcToString.append("master ");
                }
                if ((this.mMutedState & 2) != 0) {
                    apcToString.append("streamVolume ");
                }
                if ((this.mMutedState & 4) != 0) {
                    apcToString.append("streamMute ");
                }
                if ((this.mMutedState & 8) != 0) {
                    apcToString.append("opPlayAudio ");
                }
                if ((this.mMutedState & 0x10) != 0) {
                    apcToString.append("clientVolume ");
                }
                if ((this.mMutedState & 0x20) != 0) {
                    apcToString.append("volumeShaper ");
                }
                if ((this.mMutedState & 0x40) != 0) {
                    apcToString.append("portVolume ");
                }
                if ((this.mMutedState & 0x80) != 0) {
                    apcToString.append("opControlAudio ");
                }
            }
            apcToString.append(" ").append(this.mFormatInfo);
        }
        return apcToString.toString();
    }

    public static String toLogFriendlyPlayerType(int type) {
        switch (type) {
            case -1: {
                return "unknown";
            }
            case 1: {
                return "android.media.AudioTrack";
            }
            case 2: {
                return "android.media.MediaPlayer";
            }
            case 3: {
                return "android.media.SoundPool";
            }
            case 11: {
                return "OpenSL ES AudioPlayer (Buffer Queue)";
            }
            case 12: {
                return "OpenSL ES AudioPlayer (URI/FD)";
            }
            case 13: {
                return "AAudio";
            }
            case 14: {
                return "hardware source";
            }
            case 15: {
                return "external proxy";
            }
        }
        return "unknown player type " + type + " - FIXME";
    }

    public static String toLogFriendlyPlayerState(int state) {
        switch (state) {
            case -1: {
                return "unknown";
            }
            case 0: {
                return "released";
            }
            case 1: {
                return "idle";
            }
            case 2: {
                return "started";
            }
            case 3: {
                return "paused";
            }
            case 4: {
                return "stopped";
            }
            case 5: {
                return "device updated";
            }
            case 6: {
                return "port updated";
            }
            case 7: {
                return "muted updated";
            }
        }
        return "unknown player state - FIXME";
    }

    static {
        CREATOR = new Parcelable.Creator<AudioPlaybackConfiguration>(){

            @Override
            public AudioPlaybackConfiguration createFromParcel(Parcel p) {
                return new AudioPlaybackConfiguration(p);
            }

            public AudioPlaybackConfiguration[] newArray(int size) {
                return new AudioPlaybackConfiguration[size];
            }
        };
    }

    static class IPlayerShell
    implements IBinder.DeathRecipient {
        final AudioPlaybackConfiguration mMonitor;
        private volatile IPlayer mIPlayer;

        IPlayerShell(@NonNull AudioPlaybackConfiguration monitor, @NonNull IPlayer iplayer) {
            this.mMonitor = monitor;
            this.mIPlayer = iplayer;
        }

        synchronized void monitorDeath() {
            if (this.mIPlayer == null) {
                return;
            }
            try {
                this.mIPlayer.asBinder().linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                if (this.mMonitor != null) {
                    Log.w(TAG, "Could not link to client death for piid=" + this.mMonitor.mPlayerIId, e);
                }
                Log.w(TAG, "Could not link to client death", e);
            }
        }

        IPlayer getIPlayer() {
            return this.mIPlayer;
        }

        @Override
        public void binderDied() {
            if (this.mMonitor != null) {
                this.mMonitor.playerDied();
            }
        }

        synchronized void release() {
            if (this.mIPlayer == null) {
                return;
            }
            this.mIPlayer.asBinder().unlinkToDeath(this, 0);
            this.mIPlayer = null;
            Binder.flushPendingCommands();
        }
    }

    public static interface PlayerDeathMonitor {
        public void playerDeath(int var1);
    }

    public static class FormatInfo
    implements Parcelable {
        static final FormatInfo DEFAULT = new FormatInfo(false, 0, 0);
        final boolean mIsSpatialized;
        final int mNativeChannelMask;
        final int mSampleRate;
        @NonNull
        public static final Parcelable.Creator<FormatInfo> CREATOR = new Parcelable.Creator<FormatInfo>(){

            @Override
            public FormatInfo createFromParcel(Parcel p) {
                return new FormatInfo(p);
            }

            public FormatInfo[] newArray(int size) {
                return new FormatInfo[size];
            }
        };

        public FormatInfo(boolean isSpatialized, int nativeChannelMask, int sampleRate) {
            this.mIsSpatialized = isSpatialized;
            this.mNativeChannelMask = nativeChannelMask;
            this.mSampleRate = sampleRate;
        }

        public String toString() {
            return "FormatInfo{isSpatialized=" + this.mIsSpatialized + ", channelMask=0x" + Integer.toHexString(this.mNativeChannelMask) + ", sampleRate=" + this.mSampleRate + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FormatInfo)) {
                return false;
            }
            FormatInfo that = (FormatInfo)o;
            return this.mIsSpatialized == that.mIsSpatialized && this.mNativeChannelMask == that.mNativeChannelMask && this.mSampleRate == that.mSampleRate;
        }

        public int hashCode() {
            return Objects.hash(this.mIsSpatialized, this.mNativeChannelMask, this.mSampleRate);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@com.android.layoutlib.androidx.annotation.NonNull Parcel dest, int flags) {
            dest.writeBoolean(this.mIsSpatialized);
            dest.writeInt(this.mNativeChannelMask);
            dest.writeInt(this.mSampleRate);
        }

        private FormatInfo(Parcel in) {
            this(in.readBoolean(), in.readInt(), in.readInt());
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PlayerMuteEvent {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PlayerState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PlayerType {
    }
}

