/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.compat.CompatChanges;
import android.compat.annotation.UnsupportedAppUsage;
import android.hardware.Camera;
import android.media.EncoderProfiles;
import com.android.internal.lang.System_Delegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class CamcorderProfile {
    public static final int QUALITY_LOW = 0;
    public static final int QUALITY_HIGH = 1;
    public static final int QUALITY_QCIF = 2;
    public static final int QUALITY_CIF = 3;
    public static final int QUALITY_480P = 4;
    public static final int QUALITY_720P = 5;
    public static final int QUALITY_1080P = 6;
    public static final int QUALITY_QVGA = 7;
    public static final int QUALITY_2160P = 8;
    public static final int QUALITY_VGA = 9;
    public static final int QUALITY_4KDCI = 10;
    public static final int QUALITY_QHD = 11;
    public static final int QUALITY_2K = 12;
    public static final int QUALITY_8KUHD = 13;
    private static final int QUALITY_LIST_START = 0;
    private static final int QUALITY_LIST_END = 13;
    public static final int QUALITY_TIME_LAPSE_LOW = 1000;
    public static final int QUALITY_TIME_LAPSE_HIGH = 1001;
    public static final int QUALITY_TIME_LAPSE_QCIF = 1002;
    public static final int QUALITY_TIME_LAPSE_CIF = 1003;
    public static final int QUALITY_TIME_LAPSE_480P = 1004;
    public static final int QUALITY_TIME_LAPSE_720P = 1005;
    public static final int QUALITY_TIME_LAPSE_1080P = 1006;
    public static final int QUALITY_TIME_LAPSE_QVGA = 1007;
    public static final int QUALITY_TIME_LAPSE_2160P = 1008;
    public static final int QUALITY_TIME_LAPSE_VGA = 1009;
    public static final int QUALITY_TIME_LAPSE_4KDCI = 1010;
    public static final int QUALITY_TIME_LAPSE_QHD = 1011;
    public static final int QUALITY_TIME_LAPSE_2K = 1012;
    public static final int QUALITY_TIME_LAPSE_8KUHD = 1013;
    private static final int QUALITY_TIME_LAPSE_LIST_START = 1000;
    private static final int QUALITY_TIME_LAPSE_LIST_END = 1013;
    public static final int QUALITY_HIGH_SPEED_LOW = 2000;
    public static final int QUALITY_HIGH_SPEED_HIGH = 2001;
    public static final int QUALITY_HIGH_SPEED_480P = 2002;
    public static final int QUALITY_HIGH_SPEED_720P = 2003;
    public static final int QUALITY_HIGH_SPEED_1080P = 2004;
    public static final int QUALITY_HIGH_SPEED_2160P = 2005;
    public static final int QUALITY_HIGH_SPEED_CIF = 2006;
    public static final int QUALITY_HIGH_SPEED_VGA = 2007;
    public static final int QUALITY_HIGH_SPEED_4KDCI = 2008;
    private static final int QUALITY_HIGH_SPEED_LIST_START = 2000;
    private static final int QUALITY_HIGH_SPEED_LIST_END = 2008;
    public int duration;
    public int quality;
    public int fileFormat;
    public int videoCodec;
    public int videoBitRate;
    public int videoFrameRate;
    public int videoFrameWidth;
    public int videoFrameHeight;
    public int audioCodec;
    public int audioBitRate;
    public int audioSampleRate;
    public int audioChannels;
    public static final long RETURN_ADVANCED_VIDEO_PROFILES = 206033068L;

    public static CamcorderProfile get(int quality) {
        int numberOfCameras = Camera.getNumberOfCameras();
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        for (int i = 0; i < numberOfCameras; ++i) {
            Camera.getCameraInfo(i, cameraInfo);
            if (cameraInfo.facing != 0) continue;
            return CamcorderProfile.get(i, quality);
        }
        return null;
    }

    public static CamcorderProfile get(int cameraId, int quality) {
        if (!(quality >= 0 && quality <= 13 || quality >= 1000 && quality <= 1013 || quality >= 2000 && quality <= 2008)) {
            String errMessage = "Unsupported quality level: " + quality;
            throw new IllegalArgumentException(errMessage);
        }
        return CamcorderProfile.native_get_camcorder_profile(cameraId, quality);
    }

    @Nullable
    public static EncoderProfiles getAll(@NonNull String cameraId, int quality) {
        int id2;
        if (!(quality >= 0 && quality <= 13 || quality >= 1000 && quality <= 1013 || quality >= 2000 && quality <= 2008)) {
            String errMessage = "Unsupported quality level: " + quality;
            throw new IllegalArgumentException(errMessage);
        }
        try {
            id2 = Integer.valueOf(cameraId);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return CamcorderProfile.native_get_camcorder_profiles(id2, quality, CompatChanges.isChangeEnabled(206033068L));
    }

    public static boolean hasProfile(int quality) {
        int numberOfCameras = Camera.getNumberOfCameras();
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        for (int i = 0; i < numberOfCameras; ++i) {
            Camera.getCameraInfo(i, cameraInfo);
            if (cameraInfo.facing != 0) continue;
            return CamcorderProfile.hasProfile(i, quality);
        }
        return false;
    }

    public static boolean hasProfile(int cameraId, int quality) {
        return CamcorderProfile.native_has_camcorder_profile(cameraId, quality);
    }

    private CamcorderProfile(int duration, int quality, int fileFormat, int videoCodec, int videoBitRate, int videoFrameRate, int videoWidth, int videoHeight, int audioCodec, int audioBitRate, int audioSampleRate, int audioChannels) {
        this.duration = duration;
        this.quality = quality;
        this.fileFormat = fileFormat;
        this.videoCodec = videoCodec;
        this.videoBitRate = videoBitRate;
        this.videoFrameRate = videoFrameRate;
        this.videoFrameWidth = videoWidth;
        this.videoFrameHeight = videoHeight;
        this.audioCodec = audioCodec;
        this.audioBitRate = audioBitRate;
        this.audioSampleRate = audioSampleRate;
        this.audioChannels = audioChannels;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private static void native_init() {
        OverrideMethod.invokeV("android.media.CamcorderProfile#native_init()V", true, null);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private static CamcorderProfile native_get_camcorder_profile(int n, int n2) {
        return (CamcorderProfile)OverrideMethod.invokeA("android.media.CamcorderProfile#native_get_camcorder_profile(II)Landroid/media/CamcorderProfile;", true, null);
    }

    private static EncoderProfiles native_get_camcorder_profiles(int n, int n2, boolean bl) {
        return (EncoderProfiles)OverrideMethod.invokeA("android.media.CamcorderProfile#native_get_camcorder_profiles(IIZ)Landroid/media/EncoderProfiles;", true, null);
    }

    private static boolean native_has_camcorder_profile(int n, int n2) {
        return OverrideMethod.invokeI("android.media.CamcorderProfile#native_has_camcorder_profile(II)Z", true, null) != 0;
    }

    static {
        System_Delegate.loadLibrary("media_jni");
        CamcorderProfile.native_init();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Quality {
    }
}

