/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.NonNull;
import android.os.Parcel;

public class SubtitleData {
    private static final String TAG = "SubtitleData";
    private int mTrackIndex;
    private long mStartTimeUs;
    private long mDurationUs;
    private byte[] mData;

    public SubtitleData(Parcel parcel) {
        if (!this.parseParcel(parcel)) {
            throw new IllegalArgumentException("parseParcel() fails");
        }
    }

    public SubtitleData(int trackIndex, long startTimeUs, long durationUs, @NonNull byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("null data is not allowed");
        }
        this.mTrackIndex = trackIndex;
        this.mStartTimeUs = startTimeUs;
        this.mDurationUs = durationUs;
        this.mData = data;
    }

    public int getTrackIndex() {
        return this.mTrackIndex;
    }

    public long getStartTimeUs() {
        return this.mStartTimeUs;
    }

    public long getDurationUs() {
        return this.mDurationUs;
    }

    @NonNull
    public byte[] getData() {
        return this.mData;
    }

    private boolean parseParcel(Parcel parcel) {
        parcel.setDataPosition(0);
        if (parcel.dataAvail() == 0) {
            return false;
        }
        this.mTrackIndex = parcel.readInt();
        this.mStartTimeUs = parcel.readLong();
        this.mDurationUs = parcel.readLong();
        this.mData = new byte[parcel.readInt()];
        parcel.readByteArray(this.mData);
        return true;
    }
}

