/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiopolicy;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.media.AudioAttributes;
import android.media.AudioSystem;
import android.media.audiopolicy.AudioVolumeGroup;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@SystemApi
public class AudioProductStrategy
implements Parcelable {
    public static final int DEFAULT_GROUP = -1;
    private static final int MATCH_ON_TAGS_SCORE = 8;
    private static final int MATCH_ON_FLAGS_SCORE = 4;
    private static final int MATCH_ON_USAGE_SCORE = 2;
    private static final int MATCH_ON_CONTENT_TYPE_SCORE = 1;
    private static final int MATCH_ON_DEFAULT_SCORE = 0;
    private static final int NO_MATCH = -1;
    private static final int MATCH_ATTRIBUTES_EQUALS = 15;
    private static final int MATCH_EQUALS = 15;
    private static final String TAG = "AudioProductStrategy";
    private static final int AUDIO_FLAGS_AFFECT_STRATEGY_SELECTION = 13;
    private final AudioAttributesGroup[] mAudioAttributesGroups;
    private final String mName;
    private final int mId;
    private static final Object sLock = new Object();
    @GuardedBy(value={"sLock"})
    private static volatile List<AudioProductStrategy> sAudioProductStrategies;
    @NonNull
    public static final Parcelable.Creator<AudioProductStrategy> CREATOR;
    @NonNull
    private static final AudioAttributes DEFAULT_ATTRIBUTES;
    private static final String INTERNAL_TAG = "reserved_internal_strategy";
    private static final String INDENT = "  ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static List<AudioProductStrategy> getAudioProductStrategies() {
        if (sAudioProductStrategies == null) {
            Object object = sLock;
            synchronized (object) {
                if (sAudioProductStrategies == null) {
                    sAudioProductStrategies = AudioProductStrategy.initializeAudioProductStrategies();
                }
            }
        }
        if (sAudioProductStrategies == null) {
            return Collections.emptyList();
        }
        return sAudioProductStrategies;
    }

    @Nullable
    public static AudioProductStrategy getAudioProductStrategyForAudioAttributes(@NonNull AudioAttributes attributes, boolean fallbackOnDefault) {
        AudioAttributesGroup aag = AudioProductStrategy.getAudioAttributesGroupForAttributes(attributes, fallbackOnDefault);
        return aag != null ? AudioProductStrategy.getAudioProductStrategyWithId(aag.getStrategyId()) : null;
    }

    @Nullable
    public static AudioProductStrategy getAudioProductStrategyWithId(int id2) {
        for (AudioProductStrategy strategy : AudioProductStrategy.getAudioProductStrategies()) {
            if (strategy.getId() != id2) continue;
            return strategy;
        }
        return null;
    }

    @SystemApi
    @NonNull
    public static AudioProductStrategy createInvalidAudioProductStrategy(int id2) {
        ArrayList<AudioProductStrategy> apsList = new ArrayList<AudioProductStrategy>();
        AudioProductStrategy.native_list_audio_product_strategies(apsList);
        return new AudioProductStrategy("invalid strategy", apsList.size() + 1, new AudioAttributesGroup[0]);
    }

    @NonNull
    public static AudioAttributes getAudioAttributesForStrategyWithLegacyStreamType(int streamType) {
        for (AudioProductStrategy productStrategy : AudioProductStrategy.getAudioProductStrategies()) {
            AudioAttributes aa = productStrategy.getAudioAttributesForLegacyStreamType(streamType);
            if (aa == null) continue;
            return aa;
        }
        return DEFAULT_ATTRIBUTES;
    }

    public static int getLegacyStreamTypeForStrategyWithAudioAttributes(@NonNull AudioAttributes audioAttributes) {
        Objects.requireNonNull(audioAttributes, "AudioAttributes must not be null");
        AudioAttributesGroup aag = AudioProductStrategy.getAudioAttributesGroupForAttributes(audioAttributes, true);
        if (aag != null) {
            int streamType = aag.getStreamType();
            if (streamType == -1) {
                Log.w(TAG, "Attributes " + audioAttributes + " supported by strategy " + aag.getStrategyId() + " have no associated stream type, therefore falling back to STREAM_MUSIC");
                return 3;
            }
            if (streamType < AudioSystem.getNumStreamTypes()) {
                return streamType;
            }
        }
        return 3;
    }

    public static int getVolumeGroupIdForAudioAttributes(@NonNull AudioAttributes attributes, boolean fallbackOnDefault) {
        AudioAttributesGroup aag = AudioProductStrategy.getAudioAttributesGroupForAttributes(attributes, fallbackOnDefault);
        return aag != null ? aag.getVolumeGroupId() : -1;
    }

    private static boolean isMatchScoreEquals(int matchScore) {
        return matchScore == 15;
    }

    @Nullable
    private static AudioAttributesGroup getAudioAttributesGroupForAttributes(@NonNull AudioAttributes attributes, boolean fallbackOnDefault) {
        Objects.requireNonNull(attributes, "attributes must not be null");
        int matchScore = -1;
        AudioAttributesGroup bestAudioAttributesGroupOrDefault = null;
        for (AudioProductStrategy productStrategy : AudioProductStrategy.getAudioProductStrategies()) {
            ScoredAudioAttributesGroup scoredAag = productStrategy.getScoredAttributeGroupForAttribute(attributes);
            int score = scoredAag.getScore();
            if (AudioProductStrategy.isMatchScoreEquals(score)) {
                return scoredAag.getAudioAttributesGroup();
            }
            if (score <= matchScore) continue;
            matchScore = score;
            bestAudioAttributesGroupOrDefault = scoredAag.getAudioAttributesGroup();
        }
        return matchScore != 0 || fallbackOnDefault ? bestAudioAttributesGroupOrDefault : null;
    }

    private static List<AudioProductStrategy> initializeAudioProductStrategies() {
        ArrayList<AudioProductStrategy> apsList = new ArrayList<AudioProductStrategy>();
        int status = AudioProductStrategy.native_list_audio_product_strategies(apsList);
        if (status != 0) {
            Log.e(TAG, ": initializeAudioProductStrategies failed: " + status);
            return null;
        }
        apsList.removeIf(AudioProductStrategy::isInternalStrategy);
        return Collections.unmodifiableList(apsList);
    }

    private static int native_list_audio_product_strategies(ArrayList<AudioProductStrategy> arrayList) {
        return OverrideMethod.invokeI("android.media.audiopolicy.AudioProductStrategy#native_list_audio_product_strategies(Ljava/util/ArrayList;)I", true, null);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioProductStrategy thatStrategy = (AudioProductStrategy)o;
        return this.mId == thatStrategy.mId && Objects.equals(this.mName, thatStrategy.mName) && Arrays.equals(this.mAudioAttributesGroups, thatStrategy.mAudioAttributesGroups);
    }

    public int hashCode() {
        return Objects.hash(this.mId, this.mName, Arrays.hashCode(this.mAudioAttributesGroups));
    }

    private AudioProductStrategy(@NonNull String name, int id2, @NonNull AudioAttributesGroup[] aag) {
        Objects.requireNonNull(name, "name must not be null");
        Objects.requireNonNull(aag, "AudioAttributesGroups must not be null");
        this.mName = name;
        this.mId = id2;
        for (AudioAttributesGroup audioAttributesGroup : this.mAudioAttributesGroups = aag) {
            if (audioAttributesGroup.getStrategyId() == this.mId) continue;
            throw new IllegalArgumentException("AudioAttributesGroup strategy id: " + audioAttributesGroup.getStrategyId() + " does not match AudioProductStrategy id: " + this.mId);
        }
    }

    @SystemApi
    public int getId() {
        return this.mId;
    }

    @SystemApi
    @NonNull
    public String getName() {
        return this.mName;
    }

    @SystemApi
    @NonNull
    public AudioAttributes getAudioAttributes() {
        return this.mAudioAttributesGroups.length == 0 ? DEFAULT_ATTRIBUTES : this.mAudioAttributesGroups[0].getAudioAttributes();
    }

    @Nullable
    public AudioAttributes getAudioAttributesForLegacyStreamType(int streamType) {
        AudioAttributesGroup aag = this.getAudioAttributeGroupForLegacyStreamType(streamType);
        return aag != null ? aag.getAudioAttributes() : null;
    }

    public int getLegacyStreamTypeForAudioAttributes(@NonNull AudioAttributes attributes) {
        ScoredAudioAttributesGroup scoredAag = this.getScoredAttributeGroupForAttribute(attributes);
        AudioAttributesGroup aag = scoredAag.getAudioAttributesGroup();
        int score = scoredAag.getScore();
        return aag != null && score != 0 ? aag.getStreamType() : -1;
    }

    @SystemApi
    public boolean supportsAudioAttributes(@NonNull AudioAttributes aa) {
        return this.getAudioAttributesSupportScore(aa) > 0;
    }

    private int getAudioAttributesSupportScore(@NonNull AudioAttributes attributes) {
        return this.getScoredAttributeGroupForAttribute(attributes).getScore();
    }

    private ScoredAudioAttributesGroup getScoredAttributeGroupForAttribute(@NonNull AudioAttributes aa) {
        Objects.requireNonNull(aa, "AudioAttributes must not be null");
        int bestScore = -1;
        AudioAttributesGroup bestAttributGroupOrDefault = null;
        for (AudioAttributesGroup aag : this.mAudioAttributesGroups) {
            int score = aag.getAttributesMatchingScore(aa);
            if (score == 15) {
                return new ScoredAudioAttributesGroup(15, aag);
            }
            if (score <= bestScore) continue;
            bestAttributGroupOrDefault = aag;
            bestScore = score;
        }
        return new ScoredAudioAttributesGroup(bestScore, bestAttributGroupOrDefault);
    }

    public int getVolumeGroupIdForLegacyStreamType(int streamType) {
        AudioAttributesGroup aag = this.getAudioAttributeGroupForLegacyStreamType(streamType);
        return aag != null ? aag.getVolumeGroupId() : -1;
    }

    public int getVolumeGroupIdForAudioAttributes(@NonNull AudioAttributes attributes) {
        ScoredAudioAttributesGroup scoredAag = this.getScoredAttributeGroupForAttribute(attributes);
        AudioAttributesGroup aag = scoredAag.getAudioAttributesGroup();
        int score = scoredAag.getScore();
        return aag != null && score != 0 ? aag.getVolumeGroupId() : -1;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mName);
        dest.writeInt(this.mId);
        dest.writeInt(this.mAudioAttributesGroups.length);
        for (AudioAttributesGroup aag : this.mAudioAttributesGroups) {
            aag.writeToParcel(dest, flags);
        }
    }

    @NonNull
    public String toString() {
        return this.toString("");
    }

    @NonNull
    String toString(@NonNull String indent) {
        StringBuilder s = new StringBuilder();
        s.append("\n").append(indent).append("Name: ").append(this.mName);
        s.append(" Id: ").append(this.mId);
        for (AudioAttributesGroup aag : this.mAudioAttributesGroups) {
            s.append(aag.toString(indent)).append(indent);
        }
        return s.toString();
    }

    @NonNull
    public static AudioAttributes getDefaultAttributes() {
        return DEFAULT_ATTRIBUTES;
    }

    private static int attributesMatchesScore(@NonNull AudioAttributes refAttr, @NonNull AudioAttributes attr2) {
        Objects.requireNonNull(refAttr, "Reference audio attributes must not be null");
        Objects.requireNonNull(attr2, "Audio attributes to check must not be null");
        if (refAttr.equals(attr2)) {
            return 15;
        }
        if (refAttr.equals(DEFAULT_ATTRIBUTES)) {
            return 0;
        }
        int score = 0;
        if (refAttr.getSystemUsage() == 0) {
            score |= 0;
        } else if (attr2.getSystemUsage() == refAttr.getSystemUsage()) {
            score |= 2;
        } else {
            return -1;
        }
        if (refAttr.getContentType() == 0) {
            score |= 0;
        } else if (attr2.getContentType() == refAttr.getContentType()) {
            score |= 1;
        } else {
            return -1;
        }
        String refFormattedTags = TextUtils.join((CharSequence)";", refAttr.getTags());
        String cliFormattedTags = TextUtils.join((CharSequence)";", attr2.getTags());
        if (refFormattedTags.length() == 0) {
            score |= 0;
        } else if (refFormattedTags.equals(cliFormattedTags)) {
            score |= 8;
        } else {
            return -1;
        }
        if ((refAttr.getAllFlags() & 0xD) == 0) {
            score |= 0;
        } else if ((attr2.getAllFlags() & 0xD) != 0 && (attr2.getAllFlags() & refAttr.getAllFlags()) == refAttr.getAllFlags()) {
            score |= 4;
        } else {
            return -1;
        }
        return score;
    }

    @Nullable
    private AudioAttributesGroup getAudioAttributeGroupForLegacyStreamType(int streamType) {
        for (AudioAttributesGroup aag : this.mAudioAttributesGroups) {
            if (!aag.supportsStreamType(streamType)) continue;
            return aag;
        }
        return null;
    }

    private boolean isInternalStrategy() {
        for (AudioAttributesGroup aag : this.mAudioAttributesGroups) {
            if (!aag.isInternalStrategy()) continue;
            return true;
        }
        return false;
    }

    static boolean isInternalAttributesForStrategy(@NonNull AudioAttributes aa) {
        String formattedTags = TextUtils.join((CharSequence)";", aa.getTags());
        return formattedTags.equals(INTERNAL_TAG);
    }

    public static void dump(@NonNull PrintWriter pw) {
        pw.println("- AUDIO PRODUCT STRATEGIES:");
        AudioProductStrategy.getAudioProductStrategies().forEach(aps -> pw.printf("%s%s\n", INDENT, aps.toString("    ")));
        pw.println();
        pw.println("- AUDIO VOLUME GROUPS:");
        AudioVolumeGroup.getAudioVolumeGroups().forEach(avg -> pw.printf("%s%s\n", INDENT, avg.toString("    ")));
        pw.println();
    }

    static {
        CREATOR = new Parcelable.Creator<AudioProductStrategy>(){

            @Override
            public AudioProductStrategy createFromParcel(@NonNull Parcel in) {
                String name = in.readString();
                int id2 = in.readInt();
                int nbAttributesGroups = in.readInt();
                AudioAttributesGroup[] aag = new AudioAttributesGroup[nbAttributesGroups];
                for (int index = 0; index < nbAttributesGroups; ++index) {
                    aag[index] = AudioAttributesGroup.CREATOR.createFromParcel(in);
                }
                return new AudioProductStrategy(name, id2, aag);
            }

            @NonNull
            public AudioProductStrategy[] newArray(int size) {
                return new AudioProductStrategy[size];
            }
        };
        DEFAULT_ATTRIBUTES = new AudioAttributes.Builder().build();
    }

    private static class AudioAttributesGroup
    implements Parcelable {
        private int mVolumeGroupId;
        private int mLegacyStreamType;
        private int mProductStrategyId;
        private final AudioAttributes[] mAudioAttributes;
        @NonNull
        public static final Parcelable.Creator<AudioAttributesGroup> CREATOR = new Parcelable.Creator<AudioAttributesGroup>(){

            @Override
            public AudioAttributesGroup createFromParcel(@NonNull Parcel in) {
                int volumeGroupId = in.readInt();
                int streamType = in.readInt();
                int strategyId = in.readInt();
                int nbAttributes = in.readInt();
                AudioAttributes[] aa = new AudioAttributes[nbAttributes];
                for (int index = 0; index < nbAttributes; ++index) {
                    aa[index] = AudioAttributes.CREATOR.createFromParcel(in);
                }
                return new AudioAttributesGroup(volumeGroupId, streamType, strategyId, aa);
            }

            @NonNull
            public AudioAttributesGroup[] newArray(int size) {
                return new AudioAttributesGroup[size];
            }
        };

        AudioAttributesGroup(int volumeGroupId, int streamType, int productStrategyId, @NonNull AudioAttributes[] audioAttributes) {
            this.mVolumeGroupId = volumeGroupId;
            this.mLegacyStreamType = streamType;
            this.mProductStrategyId = productStrategyId;
            this.mAudioAttributes = audioAttributes;
        }

        private boolean isInternalStrategy() {
            for (AudioAttributes aa : this.mAudioAttributes) {
                if (!AudioProductStrategy.isInternalAttributesForStrategy(aa)) continue;
                return true;
            }
            return false;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AudioAttributesGroup thatAag = (AudioAttributesGroup)o;
            return this.mVolumeGroupId == thatAag.mVolumeGroupId && this.mLegacyStreamType == thatAag.mLegacyStreamType && this.mProductStrategyId == thatAag.mProductStrategyId && Arrays.equals(this.mAudioAttributes, thatAag.mAudioAttributes);
        }

        public int hashCode() {
            return Objects.hash(this.mVolumeGroupId, this.mLegacyStreamType, this.mProductStrategyId, Arrays.hashCode(this.mAudioAttributes));
        }

        public int getStreamType() {
            return this.mLegacyStreamType;
        }

        public int getVolumeGroupId() {
            return this.mVolumeGroupId;
        }

        @NonNull
        public AudioAttributes getAudioAttributes() {
            return this.mAudioAttributes.length == 0 ? DEFAULT_ATTRIBUTES : this.mAudioAttributes[0];
        }

        int getStrategyId() {
            return this.mProductStrategyId;
        }

        public int getAttributesMatchingScore(@NonNull AudioAttributes attributes) {
            int strategyScore = -1;
            for (AudioAttributes refAa : this.mAudioAttributes) {
                int attributesGroupScore = AudioProductStrategy.attributesMatchesScore(refAa, attributes);
                if (attributesGroupScore == 15) {
                    return attributesGroupScore;
                }
                strategyScore = Math.max(strategyScore, attributesGroupScore);
            }
            return strategyScore;
        }

        public boolean supportsStreamType(int streamType) {
            return this.mLegacyStreamType == streamType;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.mVolumeGroupId);
            dest.writeInt(this.mLegacyStreamType);
            dest.writeInt(this.mProductStrategyId);
            dest.writeInt(this.mAudioAttributes.length);
            for (AudioAttributes attributes : this.mAudioAttributes) {
                attributes.writeToParcel(dest, flags | 1);
            }
        }

        @NonNull
        public String toString() {
            return this.toString("");
        }

        String toString(String indent) {
            StringBuilder s = new StringBuilder();
            s.append("\n").append(indent).append("Legacy Stream Type: ");
            s.append(this.mLegacyStreamType);
            s.append(" Volume Group Id: ");
            s.append(this.mVolumeGroupId);
            for (AudioAttributes attribute : this.mAudioAttributes) {
                s.append("\n").append(indent).append("-");
                s.append(attribute.toString());
            }
            return s.toString();
        }
    }

    private static class ScoredAudioAttributesGroup {
        private final int mScore;
        private final AudioAttributesGroup mAudioAttributesGroup;

        ScoredAudioAttributesGroup(int score, AudioAttributesGroup aag) {
            this.mScore = score;
            this.mAudioAttributesGroup = aag;
        }

        public int getScore() {
            return this.mScore;
        }

        public AudioAttributesGroup getAudioAttributesGroup() {
            return this.mAudioAttributesGroup;
        }
    }
}

