/*
 * Decompiled with CFR 0.152.
 */
package android.media.quality;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.media.quality.AmbientBacklightMetadata;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@FlaggedApi(value="android.media.tv.flags.media_quality_fw")
public class AmbientBacklightEvent
implements Parcelable {
    public static final int AMBIENT_BACKLIGHT_EVENT_ENABLED = 1;
    public static final int AMBIENT_BACKLIGHT_EVENT_DISABLED = 2;
    public static final int AMBIENT_BACKLIGHT_EVENT_METADATA_AVAILABLE = 3;
    public static final int AMBIENT_BACKLIGHT_EVENT_INTERRUPTED = 4;
    private final int mEventType;
    @Nullable
    private final AmbientBacklightMetadata mMetadata;
    @NonNull
    public static final Parcelable.Creator<AmbientBacklightEvent> CREATOR = new Parcelable.Creator<AmbientBacklightEvent>(){

        @Override
        public AmbientBacklightEvent createFromParcel(Parcel in) {
            return new AmbientBacklightEvent(in);
        }

        public AmbientBacklightEvent[] newArray(int size) {
            return new AmbientBacklightEvent[size];
        }
    };

    public AmbientBacklightEvent(int eventType, @Nullable AmbientBacklightMetadata metadata) {
        this.mEventType = eventType;
        this.mMetadata = metadata;
    }

    private AmbientBacklightEvent(Parcel in) {
        this.mEventType = in.readInt();
        this.mMetadata = (AmbientBacklightMetadata)in.readParcelable(AmbientBacklightMetadata.class.getClassLoader());
    }

    public int getEventType() {
        return this.mEventType;
    }

    @Nullable
    public AmbientBacklightMetadata getMetadata() {
        return this.mMetadata;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mEventType);
        dest.writeParcelable(this.mMetadata, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AmbientBacklightEvent)) {
            return false;
        }
        AmbientBacklightEvent other = (AmbientBacklightEvent)obj;
        return this.mEventType == other.mEventType && Objects.equals(this.mMetadata, other.mMetadata);
    }

    public int hashCode() {
        return this.mEventType * 31 + (this.mMetadata != null ? this.mMetadata.hashCode() : 0);
    }

    public String toString() {
        return "AmbientBacklightEvent{mEventType=" + this.mEventType + ", mMetadata=" + this.mMetadata + '}';
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

