/*
 * Decompiled with CFR 0.152.
 */
package android.media.quality;

import android.annotation.FlaggedApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;

@FlaggedApi(value="android.media.tv.flags.media_quality_fw")
public class AmbientBacklightMetadata
implements Parcelable {
    public static final int ALGORITHM_NONE = 0;
    public static final int ALGORITHM_RLE = 1;
    @NonNull
    private final String mPackageName;
    private final int mCompressAlgorithm;
    private final int mSource;
    private final int mColorFormat;
    private final int mHorizontalZonesNumber;
    private final int mVerticalZonesNumber;
    @NonNull
    private final int[] mZonesColors;
    @NonNull
    public static final Parcelable.Creator<AmbientBacklightMetadata> CREATOR = new Parcelable.Creator<AmbientBacklightMetadata>(){

        @Override
        public AmbientBacklightMetadata createFromParcel(Parcel in) {
            return new AmbientBacklightMetadata(in);
        }

        public AmbientBacklightMetadata[] newArray(int size) {
            return new AmbientBacklightMetadata[size];
        }
    };

    public AmbientBacklightMetadata(@NonNull String packageName, int compressAlgorithm, int source, int colorFormat, int horizontalZonesNumber, int verticalZonesNumber, @NonNull int[] zonesColors) {
        this.mPackageName = packageName;
        this.mCompressAlgorithm = compressAlgorithm;
        this.mSource = source;
        this.mColorFormat = colorFormat;
        this.mHorizontalZonesNumber = horizontalZonesNumber;
        this.mVerticalZonesNumber = verticalZonesNumber;
        this.mZonesColors = zonesColors;
    }

    private AmbientBacklightMetadata(Parcel in) {
        this.mPackageName = in.readString();
        this.mCompressAlgorithm = in.readInt();
        this.mSource = in.readInt();
        this.mColorFormat = in.readInt();
        this.mHorizontalZonesNumber = in.readInt();
        this.mVerticalZonesNumber = in.readInt();
        this.mZonesColors = in.createIntArray();
    }

    @NonNull
    public String getPackageName() {
        return this.mPackageName;
    }

    public int getCompressionAlgorithm() {
        return this.mCompressAlgorithm;
    }

    public int getSource() {
        return this.mSource;
    }

    public int getColorFormat() {
        return this.mColorFormat;
    }

    public int getHorizontalZonesCount() {
        return this.mHorizontalZonesNumber;
    }

    public int getVerticalZonesCount() {
        return this.mVerticalZonesNumber;
    }

    @NonNull
    public int[] getZoneColors() {
        return this.mZonesColors;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mPackageName);
        dest.writeInt(this.mCompressAlgorithm);
        dest.writeInt(this.mSource);
        dest.writeInt(this.mColorFormat);
        dest.writeInt(this.mHorizontalZonesNumber);
        dest.writeInt(this.mVerticalZonesNumber);
        dest.writeIntArray(this.mZonesColors);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "AmbientBacklightMetadata{packageName=" + this.mPackageName + ", compressAlgorithm=" + this.mCompressAlgorithm + ", source=" + this.mSource + ", colorFormat=" + this.mColorFormat + ", horizontalZonesNumber=" + this.mHorizontalZonesNumber + ", verticalZonesNumber=" + this.mVerticalZonesNumber + ", zonesColors=" + Arrays.toString(this.mZonesColors) + "}";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CompressionAlgorithm {
    }
}

