/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv.ad;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.InputChannel;

public interface ITvAdClient
extends IInterface {
    public static final String DESCRIPTOR = "android.media.tv.ad.ITvAdClient";

    public void onSessionCreated(String var1, IBinder var2, InputChannel var3, int var4) throws RemoteException;

    public void onSessionReleased(int var1) throws RemoteException;

    public void onLayoutSurface(int var1, int var2, int var3, int var4, int var5) throws RemoteException;

    public void onRequestCurrentVideoBounds(int var1) throws RemoteException;

    public void onRequestCurrentChannelUri(int var1) throws RemoteException;

    public void onRequestTrackInfoList(int var1) throws RemoteException;

    public void onRequestCurrentTvInputId(int var1) throws RemoteException;

    public void onRequestSigning(String var1, String var2, String var3, byte[] var4, int var5) throws RemoteException;

    public void onTvAdSessionData(String var1, Bundle var2, int var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITvAdClient {
        static final int TRANSACTION_onSessionCreated = 1;
        static final int TRANSACTION_onSessionReleased = 2;
        static final int TRANSACTION_onLayoutSurface = 3;
        static final int TRANSACTION_onRequestCurrentVideoBounds = 4;
        static final int TRANSACTION_onRequestCurrentChannelUri = 5;
        static final int TRANSACTION_onRequestTrackInfoList = 6;
        static final int TRANSACTION_onRequestCurrentTvInputId = 7;
        static final int TRANSACTION_onRequestSigning = 8;
        static final int TRANSACTION_onTvAdSessionData = 9;

        public Stub() {
            this.attachInterface(this, ITvAdClient.DESCRIPTOR);
        }

        public static ITvAdClient asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITvAdClient.DESCRIPTOR);
            if (iin != null && iin instanceof ITvAdClient) {
                return (ITvAdClient)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onSessionCreated";
                }
                case 2: {
                    return "onSessionReleased";
                }
                case 3: {
                    return "onLayoutSurface";
                }
                case 4: {
                    return "onRequestCurrentVideoBounds";
                }
                case 5: {
                    return "onRequestCurrentChannelUri";
                }
                case 6: {
                    return "onRequestTrackInfoList";
                }
                case 7: {
                    return "onRequestCurrentTvInputId";
                }
                case 8: {
                    return "onRequestSigning";
                }
                case 9: {
                    return "onTvAdSessionData";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITvAdClient.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    IBinder _arg1 = data.readStrongBinder();
                    InputChannel _arg2 = data.readTypedObject(InputChannel.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSessionCreated(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSessionReleased(_arg0);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onLayoutSurface(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestCurrentVideoBounds(_arg0);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestCurrentChannelUri(_arg0);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestTrackInfoList(_arg0);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestCurrentTvInputId(_arg0);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    byte[] _arg3 = data.createByteArray();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestSigning(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTvAdSessionData(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 8;
        }

        private static class Proxy
        implements ITvAdClient {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITvAdClient.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionCreated(String serviceId, IBinder token, InputChannel channel, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvAdClient.DESCRIPTOR);
                    _data.writeString(serviceId);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(channel, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionReleased(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvAdClient.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLayoutSurface(int left, int top, int right, int bottom, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvAdClient.DESCRIPTOR);
                    _data.writeInt(left);
                    _data.writeInt(top);
                    _data.writeInt(right);
                    _data.writeInt(bottom);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestCurrentVideoBounds(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvAdClient.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestCurrentChannelUri(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvAdClient.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestTrackInfoList(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvAdClient.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestCurrentTvInputId(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvAdClient.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestSigning(String id2, String algorithm, String alias, byte[] data, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvAdClient.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeString(algorithm);
                    _data.writeString(alias);
                    _data.writeByteArray(data);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTvAdSessionData(String type, Bundle data, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvAdClient.DESCRIPTOR);
                    _data.writeString(type);
                    _data.writeTypedObject(data, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITvAdClient {
        @Override
        public void onSessionCreated(String serviceId, IBinder token, InputChannel channel, int seq) throws RemoteException {
        }

        @Override
        public void onSessionReleased(int seq) throws RemoteException {
        }

        @Override
        public void onLayoutSurface(int left, int top, int right, int bottom, int seq) throws RemoteException {
        }

        @Override
        public void onRequestCurrentVideoBounds(int seq) throws RemoteException {
        }

        @Override
        public void onRequestCurrentChannelUri(int seq) throws RemoteException {
        }

        @Override
        public void onRequestTrackInfoList(int seq) throws RemoteException {
        }

        @Override
        public void onRequestCurrentTvInputId(int seq) throws RemoteException {
        }

        @Override
        public void onRequestSigning(String id2, String algorithm, String alias, byte[] data, int seq) throws RemoteException {
        }

        @Override
        public void onTvAdSessionData(String type, Bundle data, int seq) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

