/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv.ad;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Rect;
import android.media.tv.TvInputManager;
import android.media.tv.TvTrackInfo;
import android.media.tv.ad.ITvAdClient;
import android.media.tv.ad.ITvAdManager;
import android.media.tv.ad.ITvAdManagerCallback;
import android.media.tv.ad.TvAdServiceInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pools;
import android.util.SparseArray;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventSender;
import android.view.Surface;
import android.view.View;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;

@FlaggedApi(value="android.media.tv.flags.enable_ad_service_fw")
public class TvAdManager {
    private static final String TAG = "TvAdManager";
    public static final String APP_LINK_KEY_PACKAGE_NAME = "package_name";
    public static final String APP_LINK_KEY_CLASS_NAME = "class_name";
    public static final String APP_LINK_KEY_COMMAND_TYPE = "command_type";
    public static final String APP_LINK_KEY_SERVICE_ID = "service_id";
    public static final String APP_LINK_KEY_BACK_URI = "back_uri";
    public static final String ACTION_APP_LINK_COMMAND = "android.media.tv.ad.action.APP_LINK_COMMAND";
    public static final String INTENT_KEY_TV_INPUT_ID = "tv_input_id";
    public static final String INTENT_KEY_AD_SERVICE_ID = "ad_service_id";
    public static final String INTENT_KEY_CHANNEL_URI = "channel_uri";
    public static final String INTENT_KEY_COMMAND_TYPE = "command_type";
    public static final String SESSION_DATA_TYPE_AD_REQUEST = "ad_request";
    public static final String SESSION_DATA_TYPE_AD_BUFFER_READY = "ad_buffer_ready";
    public static final String SESSION_DATA_TYPE_BROADCAST_INFO_REQUEST = "broadcast_info_request";
    public static final String SESSION_DATA_TYPE_REMOVE_BROADCAST_INFO_REQUEST = "remove_broadcast_info_request";
    public static final String SESSION_DATA_KEY_AD_REQUEST = "ad_request";
    public static final String SESSION_DATA_KEY_AD_BUFFER = "ad_buffer";
    public static final String SESSION_DATA_KEY_BROADCAST_INFO_REQUEST = "broadcast_info_request";
    public static final String SESSION_DATA_KEY_REQUEST_ID = "request_id";
    public static final int SESSION_STATE_STOPPED = 1;
    public static final int SESSION_STATE_RUNNING = 2;
    public static final int SESSION_STATE_ERROR = 3;
    public static final int ERROR_NONE = 0;
    public static final int ERROR_UNKNOWN = 1;
    public static final int ERROR_NOT_SUPPORTED = 2;
    public static final int ERROR_WEAK_SIGNAL = 3;
    public static final int ERROR_RESOURCE_UNAVAILABLE = 4;
    public static final int ERROR_BLOCKED = 5;
    public static final int ERROR_ENCRYPTED = 6;
    public static final int ERROR_UNKNOWN_CHANNEL = 7;
    private final ITvAdManager mService;
    private final int mUserId;
    private final SparseArray<SessionCallbackRecord> mSessionCallbackRecordMap = new SparseArray();
    private final List<TvAdServiceCallbackRecord> mCallbackRecords = new ArrayList<TvAdServiceCallbackRecord>();
    private int mNextSeq;
    private final Object mLock = new Object();
    private final ITvAdClient mClient;

    public TvAdManager(ITvAdManager service, int userId) {
        this.mService = service;
        this.mUserId = userId;
        this.mClient = new ITvAdClient.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionCreated(String serviceId, IBinder token, InputChannel channel, int seq) {
                SparseArray<SessionCallbackRecord> sparseArray = TvAdManager.this.mSessionCallbackRecordMap;
                synchronized (sparseArray) {
                    SessionCallbackRecord record = TvAdManager.this.mSessionCallbackRecordMap.get(seq);
                    if (record == null) {
                        Log.e(TvAdManager.TAG, "Callback not found for " + token);
                        return;
                    }
                    Session session = null;
                    if (token != null) {
                        session = new Session(token, channel, TvAdManager.this.mService, TvAdManager.this.mUserId, seq, TvAdManager.this.mSessionCallbackRecordMap);
                    } else {
                        TvAdManager.this.mSessionCallbackRecordMap.delete(seq);
                    }
                    record.postSessionCreated(session);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionReleased(int seq) {
                SparseArray<SessionCallbackRecord> sparseArray = TvAdManager.this.mSessionCallbackRecordMap;
                synchronized (sparseArray) {
                    SessionCallbackRecord record = TvAdManager.this.mSessionCallbackRecordMap.get(seq);
                    TvAdManager.this.mSessionCallbackRecordMap.delete(seq);
                    if (record == null) {
                        Log.e(TvAdManager.TAG, "Callback not found for seq:" + seq);
                        return;
                    }
                    record.mSession.releaseInternal();
                    record.postSessionReleased();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLayoutSurface(int left, int top, int right, int bottom, int seq) {
                SparseArray<SessionCallbackRecord> sparseArray = TvAdManager.this.mSessionCallbackRecordMap;
                synchronized (sparseArray) {
                    SessionCallbackRecord record = TvAdManager.this.mSessionCallbackRecordMap.get(seq);
                    if (record == null) {
                        Log.e(TvAdManager.TAG, "Callback not found for seq " + seq);
                        return;
                    }
                    record.postLayoutSurface(left, top, right, bottom);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestCurrentVideoBounds(int seq) {
                SparseArray<SessionCallbackRecord> sparseArray = TvAdManager.this.mSessionCallbackRecordMap;
                synchronized (sparseArray) {
                    SessionCallbackRecord record = TvAdManager.this.mSessionCallbackRecordMap.get(seq);
                    if (record == null) {
                        Log.e(TvAdManager.TAG, "Callback not found for seq " + seq);
                        return;
                    }
                    record.postRequestCurrentVideoBounds();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestCurrentChannelUri(int seq) {
                SparseArray<SessionCallbackRecord> sparseArray = TvAdManager.this.mSessionCallbackRecordMap;
                synchronized (sparseArray) {
                    SessionCallbackRecord record = TvAdManager.this.mSessionCallbackRecordMap.get(seq);
                    if (record == null) {
                        Log.e(TvAdManager.TAG, "Callback not found for seq " + seq);
                        return;
                    }
                    record.postRequestCurrentChannelUri();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestTrackInfoList(int seq) {
                SparseArray<SessionCallbackRecord> sparseArray = TvAdManager.this.mSessionCallbackRecordMap;
                synchronized (sparseArray) {
                    SessionCallbackRecord record = TvAdManager.this.mSessionCallbackRecordMap.get(seq);
                    if (record == null) {
                        Log.e(TvAdManager.TAG, "Callback not found for seq " + seq);
                        return;
                    }
                    record.postRequestTrackInfoList();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestCurrentTvInputId(int seq) {
                SparseArray<SessionCallbackRecord> sparseArray = TvAdManager.this.mSessionCallbackRecordMap;
                synchronized (sparseArray) {
                    SessionCallbackRecord record = TvAdManager.this.mSessionCallbackRecordMap.get(seq);
                    if (record == null) {
                        Log.e(TvAdManager.TAG, "Callback not found for seq " + seq);
                        return;
                    }
                    record.postRequestCurrentTvInputId();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestSigning(String id2, String algorithm, String alias, byte[] data, int seq) {
                SparseArray<SessionCallbackRecord> sparseArray = TvAdManager.this.mSessionCallbackRecordMap;
                synchronized (sparseArray) {
                    SessionCallbackRecord record = TvAdManager.this.mSessionCallbackRecordMap.get(seq);
                    if (record == null) {
                        Log.e(TvAdManager.TAG, "Callback not found for seq " + seq);
                        return;
                    }
                    record.postRequestSigning(id2, algorithm, alias, data);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTvAdSessionData(String type, Bundle data, int seq) {
                SparseArray<SessionCallbackRecord> sparseArray = TvAdManager.this.mSessionCallbackRecordMap;
                synchronized (sparseArray) {
                    SessionCallbackRecord record = TvAdManager.this.mSessionCallbackRecordMap.get(seq);
                    if (record == null) {
                        Log.e(TvAdManager.TAG, "Callback not found for seq " + seq);
                        return;
                    }
                    record.postTvAdSessionData(type, data);
                }
            }
        };
        ITvAdManagerCallback.Stub managerCallback = new ITvAdManagerCallback.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAdServiceAdded(String serviceId) {
                Object object = TvAdManager.this.mLock;
                synchronized (object) {
                    for (TvAdServiceCallbackRecord record : TvAdManager.this.mCallbackRecords) {
                        record.postAdServiceAdded(serviceId);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAdServiceRemoved(String serviceId) {
                Object object = TvAdManager.this.mLock;
                synchronized (object) {
                    for (TvAdServiceCallbackRecord record : TvAdManager.this.mCallbackRecords) {
                        record.postAdServiceRemoved(serviceId);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAdServiceUpdated(String serviceId) {
                Object object = TvAdManager.this.mLock;
                synchronized (object) {
                    for (TvAdServiceCallbackRecord record : TvAdManager.this.mCallbackRecords) {
                        record.postAdServiceUpdated(serviceId);
                    }
                }
            }
        };
        try {
            if (this.mService != null) {
                this.mService.registerCallback(managerCallback, this.mUserId);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public List<TvAdServiceInfo> getTvAdServiceList() {
        try {
            return this.mService.getTvAdServiceList(this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void createSession(@NonNull String serviceId, @NonNull String type, @NonNull SessionCallback callback, @NonNull Handler handler) {
        this.createSessionInternal(serviceId, type, callback, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSessionInternal(String serviceId, String type, SessionCallback callback, Handler handler) {
        Preconditions.checkNotNull(serviceId);
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull(callback);
        Preconditions.checkNotNull(handler);
        SessionCallbackRecord record = new SessionCallbackRecord(callback, handler);
        SparseArray<SessionCallbackRecord> sparseArray = this.mSessionCallbackRecordMap;
        synchronized (sparseArray) {
            int seq = this.mNextSeq++;
            this.mSessionCallbackRecordMap.put(seq, record);
            try {
                this.mService.createSession(this.mClient, serviceId, type, seq, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void sendAppLinkCommand(@NonNull String serviceId, @NonNull Bundle command) {
        try {
            this.mService.sendAppLinkCommand(serviceId, command, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallback(@NonNull Executor executor, @NonNull TvAdServiceCallback callback) {
        Preconditions.checkNotNull(callback);
        Preconditions.checkNotNull(executor);
        Object object = this.mLock;
        synchronized (object) {
            this.mCallbackRecords.add(new TvAdServiceCallbackRecord(callback, executor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCallback(@NonNull TvAdServiceCallback callback) {
        Preconditions.checkNotNull(callback);
        Object object = this.mLock;
        synchronized (object) {
            Iterator<TvAdServiceCallbackRecord> it = this.mCallbackRecords.iterator();
            while (it.hasNext()) {
                TvAdServiceCallbackRecord record = it.next();
                if (record.getCallback() != callback) continue;
                it.remove();
                break;
            }
        }
    }

    public static abstract class SessionCallback {
        public void onSessionCreated(@Nullable Session session) {
        }

        public void onSessionReleased(@NonNull Session session) {
        }

        public void onLayoutSurface(Session session, int left, int top, int right, int bottom) {
        }

        public void onRequestCurrentVideoBounds(Session session) {
        }

        public void onRequestCurrentChannelUri(Session session) {
        }

        public void onRequestTrackInfoList(Session session) {
        }

        public void onRequestCurrentTvInputId(Session session) {
        }

        public void onRequestSigning(Session session, String signingId, String algorithm, String alias, byte[] data) {
        }
    }

    private static class SessionCallbackRecord {
        private final SessionCallback mSessionCallback;
        private final Handler mHandler;
        private Session mSession;

        SessionCallbackRecord(SessionCallback sessionCallback, Handler handler) {
            this.mSessionCallback = sessionCallback;
            this.mHandler = handler;
        }

        void postSessionCreated(final Session session) {
            this.mSession = session;
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onSessionCreated(session);
                }
            });
        }

        void postSessionReleased() {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onSessionReleased(mSession);
                }
            });
        }

        void postLayoutSurface(final int left, final int top, final int right, final int bottom) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onLayoutSurface(mSession, left, top, right, bottom);
                }
            });
        }

        void postRequestCurrentVideoBounds() {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onRequestCurrentVideoBounds(mSession);
                }
            });
        }

        void postRequestCurrentChannelUri() {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onRequestCurrentChannelUri(mSession);
                }
            });
        }

        void postRequestTrackInfoList() {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onRequestTrackInfoList(mSession);
                }
            });
        }

        void postRequestCurrentTvInputId() {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onRequestCurrentTvInputId(mSession);
                }
            });
        }

        void postRequestSigning(final String id2, final String algorithm, final String alias, final byte[] data) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onRequestSigning(mSession, id2, algorithm, alias, data);
                }
            });
        }

        void postTvAdSessionData(final String type, final Bundle data) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (mSession.getInputSession() != null) {
                        mSession.getInputSession().notifyTvAdSessionData(type, data);
                    }
                }
            });
        }
    }

    private static class TvAdServiceCallbackRecord {
        private final TvAdServiceCallback mCallback;
        private final Executor mExecutor;

        TvAdServiceCallbackRecord(TvAdServiceCallback callback, Executor executor) {
            this.mCallback = callback;
            this.mExecutor = executor;
        }

        public TvAdServiceCallback getCallback() {
            return this.mCallback;
        }

        public void postAdServiceAdded(final String serviceId) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mCallback.onAdServiceAdded(serviceId);
                }
            });
        }

        public void postAdServiceRemoved(final String serviceId) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mCallback.onAdServiceRemoved(serviceId);
                }
            });
        }

        public void postAdServiceUpdated(final String serviceId) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mCallback.onAdServiceUpdated(serviceId);
                }
            });
        }
    }

    public static abstract class TvAdServiceCallback {
        public void onAdServiceAdded(@NonNull String serviceId) {
        }

        public void onAdServiceRemoved(@NonNull String serviceId) {
        }

        public void onAdServiceUpdated(@NonNull String serviceId) {
        }
    }

    public static class Session {
        static final int DISPATCH_IN_PROGRESS = -1;
        static final int DISPATCH_NOT_HANDLED = 0;
        static final int DISPATCH_HANDLED = 1;
        private static final long INPUT_SESSION_NOT_RESPONDING_TIMEOUT = 2500L;
        private final ITvAdManager mService;
        private final int mUserId;
        private final int mSeq;
        private final SparseArray<SessionCallbackRecord> mSessionCallbackRecordMap;
        private final InputEventHandler mHandler = new InputEventHandler(Looper.getMainLooper());
        private TvInputManager.Session mInputSession;
        private final Pools.Pool<PendingEvent> mPendingEventPool = new Pools.SimplePool<PendingEvent>(20);
        private final SparseArray<PendingEvent> mPendingEvents = new SparseArray(20);
        private TvInputEventSender mSender;
        private InputChannel mInputChannel;
        private IBinder mToken;

        private Session(IBinder token, InputChannel channel, ITvAdManager service, int userId, int seq, SparseArray<SessionCallbackRecord> sessionCallbackRecordMap) {
            this.mToken = token;
            this.mInputChannel = channel;
            this.mService = service;
            this.mUserId = userId;
            this.mSeq = seq;
            this.mSessionCallbackRecordMap = sessionCallbackRecordMap;
        }

        public TvInputManager.Session getInputSession() {
            return this.mInputSession;
        }

        public void setInputSession(TvInputManager.Session inputSession) {
            this.mInputSession = inputSession;
        }

        public void release() {
            if (this.mToken == null) {
                Log.w(TvAdManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.releaseSession(this.mToken, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.releaseInternal();
        }

        public void setSurface(Surface surface) {
            if (this.mToken == null) {
                Log.w(TvAdManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.setSurface(this.mToken, surface, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        void createMediaView(@NonNull View view, @NonNull Rect frame) {
            Preconditions.checkNotNull(view);
            Preconditions.checkNotNull(frame);
            if (view.getWindowToken() == null) {
                throw new IllegalStateException("view must be attached to a window");
            }
            if (this.mToken == null) {
                Log.w(TvAdManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.createMediaView(this.mToken, view.getWindowToken(), frame, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        void relayoutMediaView(@NonNull Rect frame) {
            Preconditions.checkNotNull(frame);
            if (this.mToken == null) {
                Log.w(TvAdManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.relayoutMediaView(this.mToken, frame, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        void removeMediaView() {
            if (this.mToken == null) {
                Log.w(TvAdManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.removeMediaView(this.mToken, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        public void dispatchSurfaceChanged(int format, int width, int height) {
            if (this.mToken == null) {
                Log.w(TvAdManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.dispatchSurfaceChanged(this.mToken, format, width, height, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private void flushPendingEventsLocked() {
            this.mHandler.removeMessages(3);
            int count = this.mPendingEvents.size();
            for (int i = 0; i < count; ++i) {
                int seq = this.mPendingEvents.keyAt(i);
                Message msg = this.mHandler.obtainMessage(3, seq, 0);
                msg.setAsynchronous(true);
                msg.sendToTarget();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releaseInternal() {
            this.mToken = null;
            Object object = this.mHandler;
            synchronized (object) {
                if (this.mInputChannel != null) {
                    if (this.mSender != null) {
                        this.flushPendingEventsLocked();
                        this.mSender.dispose();
                        this.mSender = null;
                    }
                    this.mInputChannel.dispose();
                    this.mInputChannel = null;
                }
            }
            object = this.mSessionCallbackRecordMap;
            synchronized (object) {
                this.mSessionCallbackRecordMap.delete(this.mSeq);
            }
        }

        void startAdService() {
            if (this.mToken == null) {
                Log.w(TvAdManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.startAdService(this.mToken, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        void stopAdService() {
            if (this.mToken == null) {
                Log.w(TvAdManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.stopAdService(this.mToken, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        void resetAdService() {
            if (this.mToken == null) {
                Log.w(TvAdManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.resetAdService(this.mToken, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        void sendCurrentVideoBounds(@NonNull Rect bounds) {
            if (this.mToken == null) {
                Log.w(TvAdManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.sendCurrentVideoBounds(this.mToken, bounds, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        void sendCurrentChannelUri(@Nullable Uri channelUri) {
            if (this.mToken == null) {
                Log.w(TvAdManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.sendCurrentChannelUri(this.mToken, channelUri, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        void sendTrackInfoList(@NonNull List<TvTrackInfo> tracks) {
            if (this.mToken == null) {
                Log.w(TvAdManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.sendTrackInfoList(this.mToken, tracks, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        void sendCurrentTvInputId(@Nullable String inputId) {
            if (this.mToken == null) {
                Log.w(TvAdManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.sendCurrentTvInputId(this.mToken, inputId, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        void sendSigningResult(@NonNull String signingId, @NonNull byte[] result) {
            if (this.mToken == null) {
                Log.w(TvAdManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.sendSigningResult(this.mToken, signingId, result, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        void notifyError(@NonNull String errMsg, @NonNull Bundle params) {
            if (this.mToken == null) {
                Log.w(TvAdManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.notifyError(this.mToken, errMsg, params, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        public void notifyTvMessage(int type, Bundle data) {
            if (this.mToken == null) {
                Log.w(TvAdManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.notifyTvMessage(this.mToken, type, data, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        public void notifyTvInputSessionData(String type, Bundle data) {
            if (this.mToken == null) {
                Log.w(TvAdManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.notifyTvInputSessionData(this.mToken, type, data, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int dispatchInputEvent(@NonNull InputEvent event, Object token, @NonNull FinishedInputEventCallback callback, @NonNull Handler handler) {
            Preconditions.checkNotNull(event);
            Preconditions.checkNotNull(callback);
            Preconditions.checkNotNull(handler);
            InputEventHandler inputEventHandler = this.mHandler;
            synchronized (inputEventHandler) {
                if (this.mInputChannel == null) {
                    return 0;
                }
                PendingEvent p = this.obtainPendingEventLocked(event, token, callback, handler);
                if (Looper.myLooper() == Looper.getMainLooper()) {
                    return this.sendInputEventOnMainLooperLocked(p);
                }
                Message msg = this.mHandler.obtainMessage(1, p);
                msg.setAsynchronous(true);
                this.mHandler.sendMessage(msg);
                return -1;
            }
        }

        private PendingEvent obtainPendingEventLocked(InputEvent event, Object token, FinishedInputEventCallback callback, Handler handler) {
            PendingEvent p = this.mPendingEventPool.acquire();
            if (p == null) {
                p = new PendingEvent();
            }
            p.mEvent = event;
            p.mEventToken = token;
            p.mCallback = callback;
            p.mEventHandler = handler;
            return p;
        }

        void invokeFinishedInputEventCallback(PendingEvent p, boolean handled) {
            p.mHandled = handled;
            if (p.mEventHandler.getLooper().isCurrentThread()) {
                p.run();
            } else {
                Message msg = Message.obtain(p.mEventHandler, p);
                msg.setAsynchronous(true);
                msg.sendToTarget();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendInputEventAndReportResultOnMainLooper(PendingEvent p) {
            InputEventHandler inputEventHandler = this.mHandler;
            synchronized (inputEventHandler) {
                int result = this.sendInputEventOnMainLooperLocked(p);
                if (result == -1) {
                    return;
                }
            }
            this.invokeFinishedInputEventCallback(p, false);
        }

        private int sendInputEventOnMainLooperLocked(PendingEvent p) {
            if (this.mInputChannel != null) {
                InputEvent event;
                int seq;
                if (this.mSender == null) {
                    this.mSender = new TvInputEventSender(this.mInputChannel, this.mHandler.getLooper());
                }
                if (this.mSender.sendInputEvent(seq = (event = p.mEvent).getSequenceNumber(), event)) {
                    this.mPendingEvents.put(seq, p);
                    Message msg = this.mHandler.obtainMessage(2, p);
                    msg.setAsynchronous(true);
                    this.mHandler.sendMessageDelayed(msg, 2500L);
                    return -1;
                }
                Log.w(TvAdManager.TAG, "Unable to send input event to session: " + this.mToken + " dropping:" + event);
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finishedInputEvent(int seq, boolean handled, boolean timeout) {
            PendingEvent p;
            InputEventHandler inputEventHandler = this.mHandler;
            synchronized (inputEventHandler) {
                int index = this.mPendingEvents.indexOfKey(seq);
                if (index < 0) {
                    return;
                }
                p = this.mPendingEvents.valueAt(index);
                this.mPendingEvents.removeAt(index);
                if (timeout) {
                    Log.w(TvAdManager.TAG, "Timeout waiting for session to handle input event after 2500 ms: " + this.mToken);
                } else {
                    this.mHandler.removeMessages(2, p);
                }
            }
            this.invokeFinishedInputEventCallback(p, handled);
        }

        private void recyclePendingEventLocked(PendingEvent p) {
            p.recycle();
            this.mPendingEventPool.release(p);
        }

        private class InputEventHandler
        extends Handler {
            public static final int MSG_SEND_INPUT_EVENT = 1;
            public static final int MSG_TIMEOUT_INPUT_EVENT = 2;
            public static final int MSG_FLUSH_INPUT_EVENT = 3;

            InputEventHandler(Looper looper) {
                super(looper, null, true);
            }

            @Override
            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        Session.this.sendInputEventAndReportResultOnMainLooper((PendingEvent)msg.obj);
                        return;
                    }
                    case 2: {
                        Session.this.finishedInputEvent(msg.arg1, false, true);
                        return;
                    }
                    case 3: {
                        Session.this.finishedInputEvent(msg.arg1, false, false);
                        return;
                    }
                }
            }
        }

        private class TvInputEventSender
        extends InputEventSender {
            TvInputEventSender(InputChannel inputChannel, Looper looper) {
                super(inputChannel, looper);
            }

            @Override
            public void onInputEventFinished(int seq, boolean handled) {
                Session.this.finishedInputEvent(seq, handled, false);
            }
        }

        public static interface FinishedInputEventCallback {
            public void onFinishedInputEvent(Object var1, boolean var2);
        }

        private class PendingEvent
        implements Runnable {
            public InputEvent mEvent;
            public Object mEventToken;
            public FinishedInputEventCallback mCallback;
            public Handler mEventHandler;
            public boolean mHandled;

            private PendingEvent() {
            }

            public void recycle() {
                this.mEvent = null;
                this.mEventToken = null;
                this.mCallback = null;
                this.mEventHandler = null;
                this.mHandled = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.mCallback.onFinishedInputEvent(this.mEventToken, this.mHandled);
                Handler handler = this.mEventHandler;
                synchronized (handler) {
                    Session.this.recyclePendingEventLocked(this);
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ErrorCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SessionState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SessionDataKey {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SessionDataType {
    }
}

