/*
 * Decompiled with CFR 0.152.
 */
package android.nearby;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.nearby.CredentialElement;
import android.nearby.PresenceCredential;
import android.net.connectivity.com.android.internal.util.Preconditions;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@SystemApi
public class PublicCredential
extends PresenceCredential
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<PublicCredential> CREATOR = new Parcelable.Creator<PublicCredential>(){

        @Override
        public PublicCredential createFromParcel(Parcel in) {
            in.readInt();
            return PublicCredential.createFromParcelBody(in);
        }

        public PublicCredential[] newArray(int size) {
            return new PublicCredential[size];
        }
    };
    private final byte[] mPublicKey;
    private final byte[] mEncryptedMetadata;
    private final byte[] mEncryptedMetadataKeyTag;

    private PublicCredential(int identityType, byte[] secretId, byte[] authenticityKey, List<CredentialElement> credentialElements, byte[] publicKey, byte[] encryptedMetadata, byte[] metadataEncryptionKeyTag) {
        super(1, identityType, secretId, authenticityKey, credentialElements);
        this.mPublicKey = publicKey;
        this.mEncryptedMetadata = encryptedMetadata;
        this.mEncryptedMetadataKeyTag = metadataEncryptionKeyTag;
    }

    private PublicCredential(Parcel in) {
        super(1, in);
        this.mPublicKey = new byte[in.readInt()];
        in.readByteArray(this.mPublicKey);
        this.mEncryptedMetadata = new byte[in.readInt()];
        in.readByteArray(this.mEncryptedMetadata);
        this.mEncryptedMetadataKeyTag = new byte[in.readInt()];
        in.readByteArray(this.mEncryptedMetadataKeyTag);
    }

    static PublicCredential createFromParcelBody(Parcel in) {
        return new PublicCredential(in);
    }

    @NonNull
    public byte[] getPublicKey() {
        return this.mPublicKey;
    }

    @NonNull
    public byte[] getEncryptedMetadata() {
        return this.mEncryptedMetadata;
    }

    @NonNull
    public byte[] getEncryptedMetadataKeyTag() {
        return this.mEncryptedMetadataKeyTag;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof PublicCredential) {
            PublicCredential that = (PublicCredential)obj;
            return super.equals(obj) && Arrays.equals(this.mPublicKey, that.mPublicKey) && Arrays.equals(this.mEncryptedMetadata, that.mEncryptedMetadata) && Arrays.equals(this.mEncryptedMetadataKeyTag, that.mEncryptedMetadataKeyTag);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.mPublicKey), Arrays.hashCode(this.mEncryptedMetadata), Arrays.hashCode(this.mEncryptedMetadataKeyTag));
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.mPublicKey.length);
        dest.writeByteArray(this.mPublicKey);
        dest.writeInt(this.mEncryptedMetadata.length);
        dest.writeByteArray(this.mEncryptedMetadata);
        dest.writeInt(this.mEncryptedMetadataKeyTag.length);
        dest.writeByteArray(this.mEncryptedMetadataKeyTag);
    }

    public static class Builder {
        private final List<CredentialElement> mCredentialElements;
        private int mIdentityType;
        private final byte[] mSecretId;
        private final byte[] mAuthenticityKey;
        private final byte[] mPublicKey;
        private final byte[] mEncryptedMetadata;
        private final byte[] mEncryptedMetadataKeyTag;

        public Builder(@NonNull byte[] secretId, @NonNull byte[] authenticityKey, @NonNull byte[] publicKey, @NonNull byte[] encryptedMetadata, @NonNull byte[] encryptedMetadataKeyTag) {
            Preconditions.checkState(secretId != null && secretId.length > 0, "secret id cannot be empty");
            Preconditions.checkState(authenticityKey != null && authenticityKey.length > 0, "authenticity key cannot be empty");
            Preconditions.checkState(publicKey != null && publicKey.length > 0, "publicKey cannot be empty");
            Preconditions.checkState(encryptedMetadata != null && encryptedMetadata.length > 0, "encryptedMetadata cannot be empty");
            Preconditions.checkState(encryptedMetadataKeyTag != null && encryptedMetadataKeyTag.length > 0, "encryptedMetadataKeyTag cannot be empty");
            this.mSecretId = secretId;
            this.mAuthenticityKey = authenticityKey;
            this.mPublicKey = publicKey;
            this.mEncryptedMetadata = encryptedMetadata;
            this.mEncryptedMetadataKeyTag = encryptedMetadataKeyTag;
            this.mCredentialElements = new ArrayList<CredentialElement>();
        }

        @NonNull
        public Builder setIdentityType(int identityType) {
            this.mIdentityType = identityType;
            return this;
        }

        @NonNull
        public Builder addCredentialElement(@NonNull CredentialElement credentialElement) {
            Objects.requireNonNull(credentialElement);
            this.mCredentialElements.add(credentialElement);
            return this;
        }

        @NonNull
        public PublicCredential build() {
            return new PublicCredential(this.mIdentityType, this.mSecretId, this.mAuthenticityKey, this.mCredentialElements, this.mPublicKey, this.mEncryptedMetadata, this.mEncryptedMetadataKeyTag);
        }
    }
}

