/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.FlaggedApi;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.app.SystemServiceRegistry;
import android.compat.Compatibility;
import android.net.vcn.IVcnManagementService;
import android.net.vcn.VcnManager;
import android.os.SystemProperties;
import android.os._Original_Build;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
@FlaggedApi(value="android.net.vcn.mainline_vcn_module_api")
public class ConnectivityFrameworkInitializerBaklava {
    private static final long ENABLE_CHECKING_TELEPHONY_FEATURES = 330583731L;
    private static final int VENDOR_API_FOR_ANDROID_V = 202404;

    private ConnectivityFrameworkInitializerBaklava() {
    }

    @Nullable
    private static String getVcnFeatureDependency() {
        if (!Compatibility.isChangeEnabled(330583731L)) {
            return null;
        }
        int vendorApiLevel = SystemProperties.getInt("ro.vendor.api_level", _Original_Build.VERSION.DEVICE_INITIAL_SDK_INT);
        if (vendorApiLevel < 202404) {
            return "android.hardware.telephony";
        }
        return "android.hardware.telephony.subscription";
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="android.net.vcn.mainline_vcn_module_api")
    public static void registerServiceWrappers() {
        SystemServiceRegistry.registerContextAwareService("vcn_management", VcnManager.class, (context, serviceBinder) -> {
            String telephonyFeatureToCheck = ConnectivityFrameworkInitializerBaklava.getVcnFeatureDependency();
            if (telephonyFeatureToCheck != null && !context.getPackageManager().hasSystemFeature(telephonyFeatureToCheck)) {
                return null;
            }
            IVcnManagementService service = IVcnManagementService.Stub.asInterface(serviceBinder);
            return new VcnManager(context, service);
        });
    }
}

