/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.connectivity.com.android.net.module.util.InetAddressUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Range;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Objects;

@SystemApi
public class DscpPolicy
implements Parcelable {
    public static final int PROTOCOL_ANY = -1;
    public static final int SOURCE_PORT_ANY = -1;
    private final int mPolicyId;
    private final int mDscp;
    @Nullable
    private final InetAddress mSrcAddr;
    @Nullable
    private final InetAddress mDstAddr;
    private final int mSrcPort;
    private final int mProtocol;
    @Nullable
    private final Range<Integer> mDstPortRange;
    @SystemApi
    @NonNull
    public static final Parcelable.Creator<DscpPolicy> CREATOR = new Parcelable.Creator<DscpPolicy>(){

        public DscpPolicy[] newArray(int size) {
            return new DscpPolicy[size];
        }

        @Override
        public DscpPolicy createFromParcel(@NonNull Parcel in) {
            return new DscpPolicy(in);
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    DscpPolicy(int policyId, int dscp, @Nullable InetAddress srcAddr, @Nullable InetAddress dstAddr, int srcPort, int protocol, Range<Integer> dstPortRange) {
        this.mPolicyId = policyId;
        this.mDscp = dscp;
        this.mSrcAddr = srcAddr;
        this.mDstAddr = dstAddr;
        this.mSrcPort = srcPort;
        this.mProtocol = protocol;
        this.mDstPortRange = dstPortRange;
        if (this.mPolicyId < 1 || this.mPolicyId > 255) {
            throw new IllegalArgumentException("Policy ID not in valid range: " + this.mPolicyId);
        }
        if (this.mDscp < 0 || this.mDscp > 63) {
            throw new IllegalArgumentException("DSCP value not in valid range: " + this.mDscp);
        }
        if (this.mSrcPort < -1 || this.mSrcPort > 65535) {
            throw new IllegalArgumentException("Source port not in valid range: " + this.mSrcPort);
        }
        if (!(this.mDstPortRange == null || dstPortRange.getLower() >= 0 && this.mDstPortRange.getLower() <= 65535 || this.mDstPortRange.getUpper() >= 0 && this.mDstPortRange.getUpper() <= 65535)) {
            throw new IllegalArgumentException("Destination port not in valid range");
        }
        if (this.mSrcAddr != null && this.mDstAddr != null && this.mSrcAddr instanceof Inet6Address != this.mDstAddr instanceof Inet6Address) {
            throw new IllegalArgumentException("Source/destination address of different family");
        }
    }

    public int getPolicyId() {
        return this.mPolicyId;
    }

    public int getDscpValue() {
        return this.mDscp;
    }

    @Nullable
    public InetAddress getSourceAddress() {
        return this.mSrcAddr;
    }

    @Nullable
    public InetAddress getDestinationAddress() {
        return this.mDstAddr;
    }

    public int getSourcePort() {
        return this.mSrcPort;
    }

    public int getProtocol() {
        return this.mProtocol;
    }

    @Nullable
    public Range<Integer> getDestinationPortRange() {
        return this.mDstPortRange;
    }

    public String toString() {
        return "DscpPolicy { policyId = " + this.mPolicyId + ", dscp = " + this.mDscp + ", srcAddr = " + this.mSrcAddr + ", dstAddr = " + this.mDstAddr + ", srcPort = " + this.mSrcPort + ", protocol = " + this.mProtocol + ", dstPortRange = " + (this.mDstPortRange == null ? "none" : ((Object)this.mDstPortRange).toString()) + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DscpPolicy)) {
            return false;
        }
        DscpPolicy that = (DscpPolicy)o;
        return this.mPolicyId == that.mPolicyId && this.mDscp == that.mDscp && Objects.equals(this.mSrcAddr, that.mSrcAddr) && Objects.equals(this.mDstAddr, that.mDstAddr) && this.mSrcPort == that.mSrcPort && this.mProtocol == that.mProtocol && Objects.equals(this.mDstPortRange, that.mDstPortRange);
    }

    public int hashCode() {
        return Objects.hash(this.mPolicyId, this.mDscp, ((Object)this.mSrcAddr).hashCode(), ((Object)this.mDstAddr).hashCode(), this.mSrcPort, this.mProtocol, ((Object)this.mDstPortRange).hashCode());
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mPolicyId);
        dest.writeInt(this.mDscp);
        InetAddressUtils.parcelInetAddress(dest, this.mSrcAddr, flags);
        InetAddressUtils.parcelInetAddress(dest, this.mDstAddr, flags);
        dest.writeInt(this.mSrcPort);
        dest.writeInt(this.mProtocol);
        dest.writeBoolean(this.mDstPortRange != null);
        if (this.mDstPortRange != null) {
            dest.writeInt(this.mDstPortRange.getLower());
            dest.writeInt(this.mDstPortRange.getUpper());
        }
    }

    DscpPolicy(@NonNull Parcel in) {
        this.mPolicyId = in.readInt();
        this.mDscp = in.readInt();
        this.mSrcAddr = InetAddressUtils.unparcelInetAddress(in);
        this.mDstAddr = InetAddressUtils.unparcelInetAddress(in);
        this.mSrcPort = in.readInt();
        this.mProtocol = in.readInt();
        this.mDstPortRange = in.readBoolean() ? new Range<Integer>(in.readInt(), in.readInt()) : null;
    }

    public static class Builder {
        private final int mPolicyId;
        private final int mDscp;
        @Nullable
        private InetAddress mSrcAddr;
        @Nullable
        private InetAddress mDstAddr;
        private int mSrcPort = -1;
        private int mProtocol = -1;
        @Nullable
        private Range<Integer> mDstPortRange;
        private long mBuilderFieldsSet = 0L;

        public Builder(int policyId, int dscpValue) {
            this.mPolicyId = policyId;
            this.mDscp = dscpValue;
        }

        @NonNull
        public Builder setSourceAddress(@NonNull InetAddress value) {
            this.mSrcAddr = value;
            return this;
        }

        @NonNull
        public Builder setDestinationAddress(@NonNull InetAddress value) {
            this.mDstAddr = value;
            return this;
        }

        @NonNull
        public Builder setSourcePort(int value) {
            this.mSrcPort = value;
            return this;
        }

        @NonNull
        public Builder setProtocol(int value) {
            this.mProtocol = value;
            return this;
        }

        @NonNull
        public Builder setDestinationPortRange(@NonNull Range<Integer> range) {
            this.mDstPortRange = range;
            return this;
        }

        @NonNull
        public DscpPolicy build() {
            return new DscpPolicy(this.mPolicyId, this.mDscp, this.mSrcAddr, this.mDstAddr, this.mSrcPort, this.mProtocol, this.mDstPortRange);
        }
    }
}

