/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.EthernetNetworkSpecifier;
import android.net.MatchAllNetworkSpecifier;
import android.net.NetworkCapabilities;
import android.net.NetworkSpecifier;
import android.net.TelephonyNetworkSpecifier;
import android.net.TestNetworkSpecifier;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.text.TextUtils;
import android.util.Range;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class NetworkRequest
implements Parcelable {
    public static final int FIRST_REQUEST_ID = 1;
    public static final int REQUEST_ID_NONE = -1;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @NonNull
    public final NetworkCapabilities networkCapabilities;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public final int requestId;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public final int legacyType;
    public final Type type;
    @NonNull
    public static final Parcelable.Creator<NetworkRequest> CREATOR = new Parcelable.Creator<NetworkRequest>(){

        @Override
        public NetworkRequest createFromParcel(Parcel in) {
            return new NetworkRequest(in);
        }

        public NetworkRequest[] newArray(int size) {
            return new NetworkRequest[size];
        }
    };

    public NetworkRequest(NetworkCapabilities nc, int legacyType, int rId, Type type) {
        if (nc == null) {
            throw new NullPointerException();
        }
        if (nc.getReservationId() != 0) {
            throw new IllegalArgumentException("ReservationId must only be set by the system");
        }
        this.requestId = rId;
        this.networkCapabilities = nc;
        if (type == Type.RESERVATION) {
            this.networkCapabilities.setReservationId(rId);
        }
        this.legacyType = legacyType;
        this.type = type;
    }

    public NetworkRequest(NetworkRequest that) {
        this.networkCapabilities = new NetworkCapabilities(that.networkCapabilities);
        this.requestId = that.requestId;
        this.legacyType = that.legacyType;
        this.type = that.type;
    }

    private NetworkRequest(Parcel in) {
        this.networkCapabilities = NetworkCapabilities.CREATOR.createFromParcel(in);
        this.legacyType = in.readInt();
        this.requestId = in.readInt();
        this.type = Type.valueOf(in.readString());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.networkCapabilities.writeToParcel(dest, flags);
        dest.writeInt(this.legacyType);
        dest.writeInt(this.requestId);
        dest.writeString(this.type.name());
    }

    public boolean isListen() {
        return this.type == Type.LISTEN;
    }

    public boolean isListenForBest() {
        return this.type == Type.LISTEN_FOR_BEST;
    }

    public boolean isRequest() {
        return this.type == Type.REQUEST || this.type == Type.BACKGROUND_REQUEST || this.type == Type.RESERVATION;
    }

    public boolean isBackgroundRequest() {
        return this.type == Type.BACKGROUND_REQUEST;
    }

    public boolean hasCapability(int capability) {
        return this.networkCapabilities.hasCapability(capability);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public boolean hasForbiddenCapability(int capability) {
        return this.networkCapabilities.hasForbiddenCapability(capability);
    }

    public boolean canBeSatisfiedBy(@Nullable NetworkCapabilities nc) {
        return this.networkCapabilities.satisfiedByNetworkCapabilities(nc);
    }

    public boolean hasTransport(int transportType) {
        return this.networkCapabilities.hasTransport(transportType);
    }

    @Nullable
    public NetworkSpecifier getNetworkSpecifier() {
        return this.networkCapabilities.getNetworkSpecifier();
    }

    @SystemApi
    public int getRequestorUid() {
        return this.networkCapabilities.getRequestorUid();
    }

    @SystemApi
    @Nullable
    public String getRequestorPackageName() {
        return this.networkCapabilities.getRequestorPackageName();
    }

    public String toString() {
        return "NetworkRequest [ " + (Object)((Object)this.type) + " id=" + this.requestId + (this.legacyType != -1 ? ", legacyType=" + this.legacyType : "") + ", " + this.networkCapabilities.toString() + " ]";
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof NetworkRequest)) {
            return false;
        }
        NetworkRequest that = (NetworkRequest)obj;
        return that.legacyType == this.legacyType && that.requestId == this.requestId && that.type == this.type && Objects.equals(that.networkCapabilities, this.networkCapabilities);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requestId, this.legacyType, this.networkCapabilities, this.type});
    }

    @NonNull
    public int[] getCapabilities() {
        return this.networkCapabilities.getCapabilities();
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @NonNull
    public int[] getEnterpriseIds() {
        return this.networkCapabilities.getEnterpriseIds();
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public boolean hasEnterpriseId(int enterpriseId) {
        return this.networkCapabilities.hasEnterpriseId(enterpriseId);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @NonNull
    public int[] getForbiddenCapabilities() {
        return this.networkCapabilities.getForbiddenCapabilities();
    }

    @NonNull
    public int[] getTransportTypes() {
        return this.networkCapabilities.getTransportTypes();
    }

    @NonNull
    @FlaggedApi(value="com.android.net.flags.request_restricted_wifi")
    public Set<Integer> getSubscriptionIds() {
        return this.networkCapabilities.getSubscriptionIds();
    }

    public static enum Type {
        NONE,
        LISTEN,
        TRACK_DEFAULT,
        REQUEST,
        BACKGROUND_REQUEST,
        TRACK_SYSTEM_DEFAULT,
        LISTEN_FOR_BEST,
        RESERVATION;

    }

    public static class Builder {
        private static final List<Integer> VCN_SUPPORTED_CAPABILITIES = Arrays.asList(17, 2, 19, 12, 20, 11, 13, 18, 21, 15, 24, 25, 14, 16, 37);
        private final NetworkCapabilities mNetworkCapabilities;
        private boolean mShouldDeduceNotVcnManaged = true;

        public Builder() {
            this.mNetworkCapabilities = new NetworkCapabilities();
            this.mNetworkCapabilities.setSingleUid(Process.myUid());
        }

        public Builder(@NonNull NetworkRequest request) {
            Objects.requireNonNull(request);
            this.mNetworkCapabilities = request.networkCapabilities;
            this.mShouldDeduceNotVcnManaged = false;
        }

        public NetworkRequest build() {
            NetworkCapabilities nc = new NetworkCapabilities(this.mNetworkCapabilities);
            nc.maybeMarkCapabilitiesRestricted();
            this.deduceNotVcnManagedCapability(nc);
            return new NetworkRequest(nc, -1, 0, Type.NONE);
        }

        public Builder addCapability(int capability) {
            this.mNetworkCapabilities.addCapability(capability);
            if (capability == 28) {
                this.mShouldDeduceNotVcnManaged = false;
            }
            return this;
        }

        public Builder removeCapability(int capability) {
            this.mNetworkCapabilities.removeCapability(capability);
            if (capability == 28) {
                this.mShouldDeduceNotVcnManaged = false;
            }
            return this;
        }

        public Builder setCapabilities(NetworkCapabilities nc) {
            this.mNetworkCapabilities.set(nc);
            return this;
        }

        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setUids(@Nullable Set<Range<Integer>> uids) {
            this.mNetworkCapabilities.setUids(uids);
            return this;
        }

        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addForbiddenCapability(int capability) {
            this.mNetworkCapabilities.addForbiddenCapability(capability);
            return this;
        }

        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        @NonNull
        @SuppressLint(value={"BuilderSetStyle"})
        public Builder removeForbiddenCapability(int capability) {
            this.mNetworkCapabilities.removeForbiddenCapability(capability);
            return this;
        }

        @NonNull
        public Builder clearCapabilities() {
            this.mNetworkCapabilities.clearAll();
            this.mShouldDeduceNotVcnManaged = false;
            return this;
        }

        public Builder addTransportType(int transportType) {
            this.mNetworkCapabilities.addTransportType(transportType);
            return this;
        }

        public Builder removeTransportType(int transportType) {
            this.mNetworkCapabilities.removeTransportType(transportType);
            return this;
        }

        public Builder setLinkUpstreamBandwidthKbps(int upKbps) {
            this.mNetworkCapabilities.setLinkUpstreamBandwidthKbps(upKbps);
            return this;
        }

        public Builder setLinkDownstreamBandwidthKbps(int downKbps) {
            this.mNetworkCapabilities.setLinkDownstreamBandwidthKbps(downKbps);
            return this;
        }

        @Deprecated
        public Builder setNetworkSpecifier(String networkSpecifier) {
            try {
                int subId = Integer.parseInt(networkSpecifier);
                return this.setNetworkSpecifier(new TelephonyNetworkSpecifier.Builder().setSubscriptionId(subId).build());
            }
            catch (NumberFormatException nfe) {
                if (TextUtils.isEmpty(networkSpecifier)) {
                    return this.setNetworkSpecifier((NetworkSpecifier)null);
                }
                if (this.mNetworkCapabilities.hasTransport(7)) {
                    return this.setNetworkSpecifier(new TestNetworkSpecifier(networkSpecifier));
                }
                return this.setNetworkSpecifier(new EthernetNetworkSpecifier(networkSpecifier));
            }
        }

        public Builder setNetworkSpecifier(NetworkSpecifier networkSpecifier) {
            if (networkSpecifier instanceof MatchAllNetworkSpecifier) {
                throw new IllegalArgumentException("A MatchAllNetworkSpecifier is not permitted");
            }
            this.mNetworkCapabilities.setNetworkSpecifier(networkSpecifier);
            this.mShouldDeduceNotVcnManaged = false;
            return this;
        }

        @SystemApi
        @RequiresPermission(value="android.permission.NETWORK_SIGNAL_STRENGTH_WAKEUP")
        @NonNull
        public Builder setSignalStrength(int signalStrength) {
            this.mNetworkCapabilities.setSignalStrength(signalStrength);
            return this;
        }

        private void deduceNotVcnManagedCapability(NetworkCapabilities nc) {
            if (!this.mShouldDeduceNotVcnManaged) {
                return;
            }
            for (int cap : nc.getCapabilities()) {
                if (VCN_SUPPORTED_CAPABILITIES.contains(cap)) continue;
                return;
            }
            nc.addCapability(28);
        }

        @NonNull
        @FlaggedApi(value="com.android.net.flags.request_restricted_wifi")
        public Builder setSubscriptionIds(@NonNull Set<Integer> subIds) {
            this.mNetworkCapabilities.setSubscriptionIds(subIds);
            return this;
        }

        @NonNull
        public Builder setIncludeOtherUidNetworks(boolean include) {
            if (include) {
                this.mNetworkCapabilities.setUids(null);
            } else {
                this.mNetworkCapabilities.setSingleUid(Process.myUid());
            }
            return this;
        }
    }
}

