/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.InetAddresses;
import android.net.PacProxySelector;
import android.net.ProxyInfo;
import android.net.Uri;
import android.text.TextUtils;
import com.android.net.module.util.ProxyUtils;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.util.List;

public class Proxy {
    private static final String TAG = "Proxy";
    private static final ProxySelector sDefaultProxySelector;
    public static final String PROXY_CHANGE_ACTION = "android.intent.action.PROXY_CHANGE";
    @Deprecated
    public static final String EXTRA_PROXY_INFO = "android.intent.extra.PROXY_INFO";
    private static ConnectivityManager sConnectivityManager;

    @UnsupportedAppUsage
    public static java.net.Proxy getProxy(Context ctx, String url) {
        String host = "";
        if (url != null && !Proxy.isLocalHost(host)) {
            URI uri = URI.create(url);
            ProxySelector proxySelector = ProxySelector.getDefault();
            List<java.net.Proxy> proxyList = proxySelector.select(uri);
            if (proxyList.size() > 0) {
                return proxyList.get(0);
            }
        }
        return java.net.Proxy.NO_PROXY;
    }

    @Deprecated
    public static String getHost(Context ctx) {
        java.net.Proxy proxy = Proxy.getProxy(ctx, null);
        if (proxy == java.net.Proxy.NO_PROXY) {
            return null;
        }
        try {
            return ((InetSocketAddress)proxy.address()).getHostName();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Deprecated
    public static int getPort(Context ctx) {
        java.net.Proxy proxy = Proxy.getProxy(ctx, null);
        if (proxy == java.net.Proxy.NO_PROXY) {
            return -1;
        }
        try {
            return ((InetSocketAddress)proxy.address()).getPort();
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Deprecated
    public static String getDefaultHost() {
        String host = System.getProperty("http.proxyHost");
        if (TextUtils.isEmpty(host)) {
            return null;
        }
        return host;
    }

    @Deprecated
    public static int getDefaultPort() {
        if (Proxy.getDefaultHost() == null) {
            return -1;
        }
        try {
            return Integer.parseInt(System.getProperty("http.proxyPort"));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static boolean isLocalHost(String host) {
        if (host == null) {
            return false;
        }
        try {
            if (host != null) {
                if (host.equalsIgnoreCase("localhost")) {
                    return true;
                }
                if (InetAddresses.parseNumericAddress(host).isLoopbackAddress()) {
                    return true;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static void setHttpProxySystemProperty(ProxyInfo p) {
        Proxy.setHttpProxyConfiguration(p);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void setHttpProxyConfiguration(@Nullable ProxyInfo p) {
        String host = null;
        String port = null;
        String exclList = null;
        Uri pacFileUrl = Uri.EMPTY;
        if (p != null) {
            host = p.getHost();
            port = Integer.toString(p.getPort());
            exclList = ProxyUtils.exclusionListAsString(p.getExclusionList());
            pacFileUrl = p.getPacFileUrl();
        }
        Proxy.setHttpProxyConfiguration(host, port, exclList, pacFileUrl);
    }

    public static void setHttpProxyConfiguration(String host, String port, String exclList, Uri pacFileUrl) {
        if (exclList != null) {
            exclList = exclList.replace(",", "|");
        }
        if (host != null) {
            System.setProperty("http.proxyHost", host);
            System.setProperty("https.proxyHost", host);
        } else {
            System.clearProperty("http.proxyHost");
            System.clearProperty("https.proxyHost");
        }
        if (port != null) {
            System.setProperty("http.proxyPort", port);
            System.setProperty("https.proxyPort", port);
        } else {
            System.clearProperty("http.proxyPort");
            System.clearProperty("https.proxyPort");
        }
        if (exclList != null) {
            System.setProperty("http.nonProxyHosts", exclList);
            System.setProperty("https.nonProxyHosts", exclList);
        } else {
            System.clearProperty("http.nonProxyHosts");
            System.clearProperty("https.nonProxyHosts");
        }
        if (!Uri.EMPTY.equals(pacFileUrl)) {
            ProxySelector.setDefault(new PacProxySelector());
        } else {
            ProxySelector.setDefault(sDefaultProxySelector);
        }
    }

    static {
        sConnectivityManager = null;
        sDefaultProxySelector = ProxySelector.getDefault();
    }
}

