/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.net.NetworkReleasedException;
import android.net.SocketLocalAddressChangedException;
import android.net.SocketNotBoundException;
import android.net.SocketNotConnectedException;
import android.net.SocketRemoteAddressChangedException;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
public class QosCallbackException
extends Exception {
    private static final String TAG = "QosCallbackException";
    public static final int EX_TYPE_FILTER_NONE = 0;
    public static final int EX_TYPE_FILTER_NETWORK_RELEASED = 1;
    public static final int EX_TYPE_FILTER_SOCKET_NOT_BOUND = 2;
    public static final int EX_TYPE_FILTER_NOT_SUPPORTED = 3;
    public static final int EX_TYPE_FILTER_SOCKET_LOCAL_ADDRESS_CHANGED = 4;
    public static final int EX_TYPE_FILTER_SOCKET_NOT_CONNECTED = 5;
    public static final int EX_TYPE_FILTER_SOCKET_REMOTE_ADDRESS_CHANGED = 6;

    @NonNull
    public static QosCallbackException createException(int type) {
        switch (type) {
            case 1: {
                return new QosCallbackException(new NetworkReleasedException());
            }
            case 2: {
                return new QosCallbackException(new SocketNotBoundException());
            }
            case 5: {
                return new QosCallbackException(new SocketNotConnectedException());
            }
            case 3: {
                return new QosCallbackException(new UnsupportedOperationException("This device does not support the specified filter"));
            }
            case 4: {
                return new QosCallbackException(new SocketLocalAddressChangedException());
            }
            case 6: {
                return new QosCallbackException(new SocketRemoteAddressChangedException());
            }
        }
        Log.wtf(TAG, "create: No case setup for exception type: '" + type + "'");
        return new QosCallbackException(new RuntimeException("Unknown exception code: " + type));
    }

    @VisibleForTesting
    public QosCallbackException(@NonNull String message) {
        super(message);
    }

    @VisibleForTesting
    public QosCallbackException(@NonNull Throwable cause) {
        super(cause);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ExceptionType {
    }
}

