/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.android.net;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface INetworkActivityListener
extends IInterface {
    public static final String DESCRIPTOR = "android.net.connectivity.android.net.INetworkActivityListener";

    public void onNetworkActive() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INetworkActivityListener {
        static final int TRANSACTION_onNetworkActive = 1;

        public Stub() {
            this.attachInterface(this, INetworkActivityListener.DESCRIPTOR);
        }

        public static INetworkActivityListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(INetworkActivityListener.DESCRIPTOR);
            if (iin != null && iin instanceof INetworkActivityListener) {
                return (INetworkActivityListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onNetworkActive";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = INetworkActivityListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    this.onNetworkActive();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements INetworkActivityListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return INetworkActivityListener.DESCRIPTOR;
            }

            @Override
            public void onNetworkActive() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkActivityListener.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INetworkActivityListener {
        @Override
        public void onNetworkActive() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

