/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.android.net;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.ConnectivityManager;
import android.net.QosCallback;
import android.net.QosCallbackException;
import android.net.QosSession;
import android.net.connectivity.android.net.IQosCallback;
import android.telephony.data.EpsBearerQosSessionAttributes;
import android.telephony.data.NrQosSessionAttributes;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.concurrent.Executor;

public class QosCallbackConnection
extends IQosCallback.Stub {
    @NonNull
    private final ConnectivityManager mConnectivityManager;
    @Nullable
    private volatile QosCallback mCallback;
    @NonNull
    private final Executor mExecutor;

    @VisibleForTesting
    @Nullable
    public QosCallback getCallback() {
        return this.mCallback;
    }

    public QosCallbackConnection(@NonNull ConnectivityManager connectivityManager, @NonNull QosCallback callback, @NonNull Executor executor) {
        this.mConnectivityManager = Objects.requireNonNull(connectivityManager, "connectivityManager must be non-null");
        this.mCallback = Objects.requireNonNull(callback, "callback must be non-null");
        this.mExecutor = Objects.requireNonNull(executor, "executor must be non-null");
    }

    @Override
    public void onQosEpsBearerSessionAvailable(@NonNull QosSession session, @NonNull EpsBearerQosSessionAttributes attributes) {
        this.mExecutor.execute(() -> {
            QosCallback callback = this.mCallback;
            if (callback != null) {
                callback.onQosSessionAvailable(session, attributes);
            }
        });
    }

    @Override
    public void onNrQosSessionAvailable(@NonNull QosSession session, @NonNull NrQosSessionAttributes attributes) {
        this.mExecutor.execute(() -> {
            QosCallback callback = this.mCallback;
            if (callback != null) {
                callback.onQosSessionAvailable(session, attributes);
            }
        });
    }

    @Override
    public void onQosSessionLost(@NonNull QosSession session) {
        this.mExecutor.execute(() -> {
            QosCallback callback = this.mCallback;
            if (callback != null) {
                callback.onQosSessionLost(session);
            }
        });
    }

    @Override
    public void onError(int errorType) {
        this.mExecutor.execute(() -> {
            QosCallback callback = this.mCallback;
            if (callback != null) {
                this.stopReceivingMessages();
                this.mConnectivityManager.unregisterQosCallback(callback);
                callback.onError(QosCallbackException.createException(errorType));
            }
        });
    }

    public void stopReceivingMessages() {
        this.mCallback = null;
    }
}

