/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.android.net.thread;

import android.net.connectivity.android.net.thread.IThreadNetworkController;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IThreadNetworkManager
extends IInterface {
    public static final String DESCRIPTOR = "android.net.connectivity.android.net.thread.IThreadNetworkManager";

    public List<IThreadNetworkController> getAllThreadNetworkControllers() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IThreadNetworkManager {
        static final int TRANSACTION_getAllThreadNetworkControllers = 1;

        public Stub() {
            this.attachInterface(this, IThreadNetworkManager.DESCRIPTOR);
        }

        public static IThreadNetworkManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IThreadNetworkManager.DESCRIPTOR);
            if (iin != null && iin instanceof IThreadNetworkManager) {
                return (IThreadNetworkManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getAllThreadNetworkControllers";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IThreadNetworkManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    List<IThreadNetworkController> _result = this.getAllThreadNetworkControllers();
                    reply.writeNoException();
                    reply.writeInterfaceList(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IThreadNetworkManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IThreadNetworkManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<IThreadNetworkController> getAllThreadNetworkControllers() throws RemoteException {
                ArrayList<IThreadNetworkController> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IThreadNetworkManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createInterfaceArrayList(IThreadNetworkController.Stub::asInterface);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IThreadNetworkManager {
        @Override
        public List<IThreadNetworkController> getAllThreadNetworkControllers() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

