/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.com.android.net.module.util;

import android.net.connectivity.com.android.net.module.util.Struct;
import android.system.ErrnoException;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.io.IOException;
import java.util.NoSuchElementException;

public interface IBpfMap<K extends Struct, V extends Struct>
extends AutoCloseable {
    public void updateEntry(K var1, V var2) throws ErrnoException;

    public void insertEntry(K var1, V var2) throws ErrnoException, IllegalStateException;

    public void replaceEntry(K var1, V var2) throws ErrnoException, NoSuchElementException;

    public boolean insertOrReplaceEntry(K var1, V var2) throws ErrnoException;

    public boolean deleteEntry(K var1) throws ErrnoException;

    public K getNextKey(@NonNull K var1) throws ErrnoException;

    public K getFirstKey() throws ErrnoException;

    default public boolean isEmpty() throws ErrnoException {
        return this.getFirstKey() == null;
    }

    public boolean containsKey(@NonNull K var1) throws ErrnoException;

    public V getValue(@NonNull K var1) throws ErrnoException;

    default public void forEach(ThrowingBiConsumer<K, V> action) throws ErrnoException {
        K nextKey = this.getFirstKey();
        while (nextKey != null) {
            K curKey = nextKey;
            V value = this.getValue(curKey);
            nextKey = this.getNextKey(curKey);
            action.accept(curKey, value);
        }
    }

    default public void clear() throws ErrnoException {
        K key = this.getFirstKey();
        while (key != null) {
            this.deleteEntry(key);
            key = this.getFirstKey();
        }
    }

    @Override
    default public void close() throws IOException {
    }

    public static interface ThrowingBiConsumer<T, U> {
        public void accept(T var1, U var2) throws ErrnoException;
    }
}

