/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.com.android.net.module.util;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.RouteInfo;
import android.text.TextUtils;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class LinkPropertiesUtils {
    @NonNull
    public static CompareResult<LinkAddress> compareAddresses(@Nullable LinkProperties left, @Nullable LinkProperties right) {
        return new CompareResult<LinkAddress>(left != null ? left.getLinkAddresses() : null, right != null ? right.getLinkAddresses() : null);
    }

    @NonNull
    public static CompareResult<LinkAddress> compareAllAddresses(@Nullable LinkProperties left, @Nullable LinkProperties right) {
        return new CompareResult<LinkAddress>(left != null ? left.getAllLinkAddresses() : null, right != null ? right.getAllLinkAddresses() : null);
    }

    public static boolean isIdenticalAllLinkAddresses(@Nullable LinkProperties left, @Nullable LinkProperties right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        List<LinkAddress> leftAddresses = left.getAllLinkAddresses();
        List<LinkAddress> rightAddresses = right.getAllLinkAddresses();
        if (leftAddresses.size() != rightAddresses.size()) {
            return false;
        }
        return leftAddresses.containsAll(rightAddresses);
    }

    public static boolean isIdenticalAddresses(@NonNull LinkProperties left, @NonNull LinkProperties right) {
        List<InetAddress> leftAddresses = left.getAddresses();
        List<InetAddress> rightAddresses = right.getAddresses();
        return leftAddresses.size() == rightAddresses.size() ? leftAddresses.containsAll(rightAddresses) : false;
    }

    public static boolean isIdenticalDnses(@NonNull LinkProperties left, @NonNull LinkProperties right) {
        List<InetAddress> leftDnses = left.getDnsServers();
        List<InetAddress> rightDnses = right.getDnsServers();
        String leftDomains = left.getDomains();
        String rightDomains = right.getDomains();
        if (leftDomains == null ? rightDomains != null : !leftDomains.equals(rightDomains)) {
            return false;
        }
        return leftDnses.size() == rightDnses.size() ? leftDnses.containsAll(rightDnses) : false;
    }

    public static boolean isIdenticalHttpProxy(@NonNull LinkProperties left, @NonNull LinkProperties right) {
        return Objects.equals(left.getHttpProxy(), right.getHttpProxy());
    }

    public static boolean isIdenticalInterfaceName(@NonNull LinkProperties left, @NonNull LinkProperties right) {
        return TextUtils.equals(left.getInterfaceName(), right.getInterfaceName());
    }

    public static boolean isIdenticalRoutes(@NonNull LinkProperties left, @NonNull LinkProperties right) {
        List<RouteInfo> leftRoutes = left.getRoutes();
        List<RouteInfo> rightRoutes = right.getRoutes();
        return leftRoutes.size() == rightRoutes.size() ? leftRoutes.containsAll(rightRoutes) : false;
    }

    public static class CompareResult<T> {
        public final List<T> removed = new ArrayList<T>();
        public final List<T> added = new ArrayList<T>();

        public CompareResult() {
        }

        public CompareResult(@Nullable Collection<T> oldItems, @Nullable Collection<T> newItems) {
            if (oldItems != null) {
                this.removed.addAll(oldItems);
            }
            if (newItems != null) {
                for (T newItem : newItems) {
                    if (this.removed.remove(newItem)) continue;
                    this.added.add(newItem);
                }
            }
        }

        public String toString() {
            return "removed=[" + TextUtils.join((CharSequence)",", this.removed) + "] added=[" + TextUtils.join((CharSequence)",", this.added) + "]";
        }
    }

    public static class CompareOrUpdateResult<K, T> {
        public final List<T> added = new ArrayList<T>();
        public final List<T> removed = new ArrayList<T>();
        public final List<T> updated = new ArrayList<T>();

        public CompareOrUpdateResult(Collection<T> oldItems, Collection<T> newItems, Function<T, K> keyCalculator) {
            HashMap<K, T> updateTracker = new HashMap<K, T>();
            if (oldItems != null) {
                for (T oldItem : oldItems) {
                    updateTracker.put(keyCalculator.apply(oldItem), oldItem);
                }
            }
            if (newItems != null) {
                for (T newItem : newItems) {
                    Object oldItem = updateTracker.remove(keyCalculator.apply(newItem));
                    if (oldItem != null) {
                        if (oldItem.equals(newItem)) continue;
                        this.updated.add(newItem);
                        continue;
                    }
                    this.added.add(newItem);
                }
            }
            this.removed.addAll(updateTracker.values());
        }

        public String toString() {
            return "removed=[" + TextUtils.join((CharSequence)",", this.removed) + "] added=[" + TextUtils.join((CharSequence)",", this.added) + "] updated=[" + TextUtils.join((CharSequence)",", this.updated) + "]";
        }
    }
}

