/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.base.metrics;

import android.net.connectivity.org.chromium.base.metrics.CachingUmaRecorder;
import android.net.connectivity.org.chromium.base.metrics.NativeUmaRecorder;
import android.net.connectivity.org.chromium.base.metrics.UmaRecorder;
import android.net.connectivity.org.chromium.build.annotations.NullMarked;

@NullMarked
public class UmaRecorderHolder {
    private static CachingUmaRecorder sRecorder = new CachingUmaRecorder();
    private static boolean sSetUpNativeUmaRecorder = true;
    private static boolean sNativeInitialized;

    private UmaRecorderHolder() {
    }

    public static UmaRecorder get() {
        return sRecorder;
    }

    public static void setNonNativeDelegate(UmaRecorder recorder) {
        UmaRecorder previous = sRecorder.setDelegate(recorder);
        assert (!(previous instanceof NativeUmaRecorder)) : "A NativeUmaRecorder has already been set";
    }

    public static void setUpNativeUmaRecorder(boolean setUpNativeUmaRecorder) {
        sSetUpNativeUmaRecorder = setUpNativeUmaRecorder;
    }

    public static void onLibraryLoaded() {
        if (!sSetUpNativeUmaRecorder) {
            return;
        }
        assert (!sNativeInitialized);
        sNativeInitialized = true;
        sRecorder.setDelegate(new NativeUmaRecorder());
    }

    public static void resetForTesting() {
        if (!sNativeInitialized) {
            sRecorder = new CachingUmaRecorder();
        }
    }
}

