/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net;

import android.annotation.SuppressLint;
import android.net.connectivity.org.chromium.net.CronetException;
import android.net.connectivity.org.chromium.net.UrlResponseInfo;
import java.nio.ByteBuffer;

public abstract class BidirectionalStream {
    public abstract void start();

    public abstract void read(ByteBuffer var1);

    public abstract void write(ByteBuffer var1, boolean var2);

    public abstract void flush();

    public abstract void cancel();

    public abstract boolean isDone();

    public static abstract class Callback {
        public abstract void onStreamReady(BidirectionalStream var1);

        public abstract void onResponseHeadersReceived(BidirectionalStream var1, UrlResponseInfo var2);

        public abstract void onReadCompleted(BidirectionalStream var1, UrlResponseInfo var2, ByteBuffer var3, boolean var4);

        public abstract void onWriteCompleted(BidirectionalStream var1, UrlResponseInfo var2, ByteBuffer var3, boolean var4);

        public void onResponseTrailersReceived(BidirectionalStream stream, UrlResponseInfo info, UrlResponseInfo.HeaderBlock trailers) {
        }

        public abstract void onSucceeded(BidirectionalStream var1, UrlResponseInfo var2);

        public abstract void onFailed(BidirectionalStream var1, UrlResponseInfo var2, CronetException var3);

        public void onCanceled(BidirectionalStream stream, UrlResponseInfo info) {
        }
    }

    public static abstract class Builder {
        public static final int STREAM_PRIORITY_IDLE = 0;
        public static final int STREAM_PRIORITY_LOWEST = 1;
        public static final int STREAM_PRIORITY_LOW = 2;
        public static final int STREAM_PRIORITY_MEDIUM = 3;
        public static final int STREAM_PRIORITY_HIGHEST = 4;

        public abstract Builder setHttpMethod(String var1);

        public abstract Builder addHeader(String var1, String var2);

        public abstract Builder setPriority(int var1);

        public abstract Builder delayRequestHeadersUntilFirstFlush(boolean var1);

        public Builder addRequestAnnotation(Object annotation) {
            return this;
        }

        public Builder setTrafficStatsTag(int tag) {
            return this;
        }

        public Builder setTrafficStatsUid(int uid) {
            return this;
        }

        public Builder bindToNetwork(long networkHandle) {
            return this;
        }

        @SuppressLint(value={"WrongConstant"})
        public abstract BidirectionalStream build();
    }
}

