/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net;

import android.net.NetworkCapabilities;
import android.net.connectivity.org.chromium.build.annotations.NullMarked;
import android.net.connectivity.org.chromium.build.annotations.Nullable;

@NullMarked
class NetworkCapabilitiesWrapper {
    private final @Nullable NetworkCapabilities mWrapped;
    private final long mNetworkCapabilities;
    private final long mTransportTypes;

    NetworkCapabilitiesWrapper(int[] networkCapabilities, int[] transportTypes) {
        this.mNetworkCapabilities = NetworkCapabilitiesWrapper.packIntoLong(networkCapabilities);
        this.mTransportTypes = NetworkCapabilitiesWrapper.packIntoLong(transportTypes);
        this.mWrapped = null;
    }

    NetworkCapabilitiesWrapper(@Nullable NetworkCapabilities other) {
        this.mWrapped = other;
        this.mNetworkCapabilities = -1L;
        this.mTransportTypes = -1L;
    }

    public boolean hasCapability(int capability) {
        if (this.mWrapped != null) {
            return this.mWrapped.hasCapability(capability);
        }
        return capability >= 0 && capability < 64 && (this.mNetworkCapabilities & 1L << capability) != 0L;
    }

    public boolean hasTransport(int transportType) {
        if (this.mWrapped != null) {
            return this.mWrapped.hasTransport(transportType);
        }
        return transportType >= 0 && transportType < 64 && (this.mTransportTypes & (long)(1 << transportType)) != 0L;
    }

    private static long packIntoLong(int[] bits) {
        long packed = 0L;
        for (int b : bits) {
            packed |= 1L << b;
        }
        return packed;
    }
}

