/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net;

import com.android.layoutlib.androidx.annotation.NonNull;
import com.android.layoutlib.androidx.annotation.Nullable;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import com.android.layoutlib.androidx.annotation.RequiresOptIn;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class QuicOptions {
    private final Set<String> mQuicHostAllowlist;
    private final Set<String> mEnabledQuicVersions;
    private final Set<String> mConnectionOptions;
    private final Set<String> mClientConnectionOptions;
    @Nullable
    private final Integer mInMemoryServerConfigsCacheSize;
    @Nullable
    private final String mHandshakeUserAgent;
    @Nullable
    private final Boolean mRetryWithoutAltSvcOnQuicErrors;
    @Nullable
    private final Boolean mEnableTlsZeroRtt;
    @Nullable
    private final Long mPreCryptoHandshakeIdleTimeoutSeconds;
    @Nullable
    private final Long mCryptoHandshakeTimeoutSeconds;
    @Nullable
    private final Long mIdleConnectionTimeoutSeconds;
    @Nullable
    private final Long mRetransmittableOnWireTimeoutMillis;
    @Nullable
    private final Boolean mCloseSessionsOnIpChange;
    @Nullable
    private final Boolean mGoawaySessionsOnIpChange;
    @Nullable
    private final Long mInitialBrokenServicePeriodSeconds;
    @Nullable
    private final Boolean mIncreaseBrokenServicePeriodExponentially;
    @Nullable
    private final Boolean mDelayJobsWithAvailableSpdySession;
    private final Set<String> mExtraQuicheFlags;

    QuicOptions(Builder builder) {
        this.mQuicHostAllowlist = Collections.unmodifiableSet(new LinkedHashSet<String>(builder.mQuicHostAllowlist));
        this.mEnabledQuicVersions = Collections.unmodifiableSet(new LinkedHashSet<String>(builder.mEnabledQuicVersions));
        this.mConnectionOptions = Collections.unmodifiableSet(new LinkedHashSet<String>(builder.mConnectionOptions));
        this.mClientConnectionOptions = Collections.unmodifiableSet(new LinkedHashSet<String>(builder.mClientConnectionOptions));
        this.mInMemoryServerConfigsCacheSize = builder.mInMemoryServerConfigsCacheSize;
        this.mHandshakeUserAgent = builder.mHandshakeUserAgent;
        this.mRetryWithoutAltSvcOnQuicErrors = builder.mRetryWithoutAltSvcOnQuicErrors;
        this.mEnableTlsZeroRtt = builder.mEnableTlsZeroRtt;
        this.mPreCryptoHandshakeIdleTimeoutSeconds = builder.mPreCryptoHandshakeIdleTimeoutSeconds;
        this.mCryptoHandshakeTimeoutSeconds = builder.mCryptoHandshakeTimeoutSeconds;
        this.mIdleConnectionTimeoutSeconds = builder.mIdleConnectionTimeoutSeconds;
        this.mRetransmittableOnWireTimeoutMillis = builder.mRetransmittableOnWireTimeoutMillis;
        this.mCloseSessionsOnIpChange = builder.mCloseSessionsOnIpChange;
        this.mGoawaySessionsOnIpChange = builder.mGoawaySessionsOnIpChange;
        this.mInitialBrokenServicePeriodSeconds = builder.mInitialBrokenServicePeriodSeconds;
        this.mIncreaseBrokenServicePeriodExponentially = builder.mIncreaseBrokenServicePeriodExponentially;
        this.mDelayJobsWithAvailableSpdySession = builder.mDelayJobsWithAvailableSpdySession;
        this.mExtraQuicheFlags = Collections.unmodifiableSet(new LinkedHashSet<String>(builder.mExtraQuicheFlags));
    }

    public Set<String> getQuicHostAllowlist() {
        return this.mQuicHostAllowlist;
    }

    public Set<String> getEnabledQuicVersions() {
        return this.mEnabledQuicVersions;
    }

    public Set<String> getConnectionOptions() {
        return this.mConnectionOptions;
    }

    public Set<String> getClientConnectionOptions() {
        return this.mClientConnectionOptions;
    }

    @Nullable
    public Integer getInMemoryServerConfigsCacheSize() {
        return this.mInMemoryServerConfigsCacheSize;
    }

    @Nullable
    public String getHandshakeUserAgent() {
        return this.mHandshakeUserAgent;
    }

    @Nullable
    public Boolean getRetryWithoutAltSvcOnQuicErrors() {
        return this.mRetryWithoutAltSvcOnQuicErrors;
    }

    @Nullable
    public Boolean getEnableTlsZeroRtt() {
        return this.mEnableTlsZeroRtt;
    }

    @Nullable
    public Long getPreCryptoHandshakeIdleTimeoutSeconds() {
        return this.mPreCryptoHandshakeIdleTimeoutSeconds;
    }

    @Nullable
    public Long getCryptoHandshakeTimeoutSeconds() {
        return this.mCryptoHandshakeTimeoutSeconds;
    }

    @Nullable
    public Long getIdleConnectionTimeoutSeconds() {
        return this.mIdleConnectionTimeoutSeconds;
    }

    @Nullable
    public Long getRetransmittableOnWireTimeoutMillis() {
        return this.mRetransmittableOnWireTimeoutMillis;
    }

    @Nullable
    public Boolean getCloseSessionsOnIpChange() {
        return this.mCloseSessionsOnIpChange;
    }

    @Nullable
    public Boolean getGoawaySessionsOnIpChange() {
        return this.mGoawaySessionsOnIpChange;
    }

    @Nullable
    public Long getInitialBrokenServicePeriodSeconds() {
        return this.mInitialBrokenServicePeriodSeconds;
    }

    @Nullable
    public Boolean getIncreaseBrokenServicePeriodExponentially() {
        return this.mIncreaseBrokenServicePeriodExponentially;
    }

    @Nullable
    public Boolean getDelayJobsWithAvailableSpdySession() {
        return this.mDelayJobsWithAvailableSpdySession;
    }

    public Set<String> getExtraQuicheFlags() {
        return this.mExtraQuicheFlags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<String> mQuicHostAllowlist = new LinkedHashSet<String>();
        private final Set<String> mEnabledQuicVersions = new LinkedHashSet<String>();
        private final Set<String> mConnectionOptions = new LinkedHashSet<String>();
        private final Set<String> mClientConnectionOptions = new LinkedHashSet<String>();
        @Nullable
        private Integer mInMemoryServerConfigsCacheSize;
        @Nullable
        private String mHandshakeUserAgent;
        @Nullable
        private Boolean mRetryWithoutAltSvcOnQuicErrors;
        @Nullable
        private Boolean mEnableTlsZeroRtt;
        @Nullable
        private Long mPreCryptoHandshakeIdleTimeoutSeconds;
        @Nullable
        private Long mCryptoHandshakeTimeoutSeconds;
        @Nullable
        private Long mIdleConnectionTimeoutSeconds;
        @Nullable
        private Long mRetransmittableOnWireTimeoutMillis;
        @Nullable
        private Boolean mCloseSessionsOnIpChange;
        @Nullable
        private Boolean mGoawaySessionsOnIpChange;
        @Nullable
        private Long mInitialBrokenServicePeriodSeconds;
        @Nullable
        private Boolean mIncreaseBrokenServicePeriodExponentially;
        @Nullable
        private Boolean mDelayJobsWithAvailableSpdySession;
        @Nullable
        private final Set<String> mExtraQuicheFlags = new LinkedHashSet<String>();

        Builder() {
        }

        public Builder addAllowedQuicHost(String quicHost) {
            this.mQuicHostAllowlist.add(quicHost);
            return this;
        }

        @QuichePassthroughOption
        public Builder addEnabledQuicVersion(String enabledQuicVersion) {
            this.mEnabledQuicVersions.add(enabledQuicVersion);
            return this;
        }

        @QuichePassthroughOption
        public Builder addConnectionOption(String connectionOption) {
            this.mConnectionOptions.add(connectionOption);
            return this;
        }

        @QuichePassthroughOption
        public Builder addClientConnectionOption(String clientConnectionOption) {
            this.mClientConnectionOptions.add(clientConnectionOption);
            return this;
        }

        public Builder setInMemoryServerConfigsCacheSize(int inMemoryServerConfigsCacheSize) {
            this.mInMemoryServerConfigsCacheSize = inMemoryServerConfigsCacheSize;
            return this;
        }

        public Builder setHandshakeUserAgent(String handshakeUserAgent) {
            this.mHandshakeUserAgent = handshakeUserAgent;
            return this;
        }

        @Experimental
        public Builder retryWithoutAltSvcOnQuicErrors(boolean retryWithoutAltSvcOnQuicErrors) {
            this.mRetryWithoutAltSvcOnQuicErrors = retryWithoutAltSvcOnQuicErrors;
            return this;
        }

        @Experimental
        public Builder enableTlsZeroRtt(boolean enableTlsZeroRtt) {
            this.mEnableTlsZeroRtt = enableTlsZeroRtt;
            return this;
        }

        @Experimental
        public Builder setPreCryptoHandshakeIdleTimeoutSeconds(long preCryptoHandshakeIdleTimeoutSeconds) {
            this.mPreCryptoHandshakeIdleTimeoutSeconds = preCryptoHandshakeIdleTimeoutSeconds;
            return this;
        }

        @Experimental
        public Builder setCryptoHandshakeTimeoutSeconds(long cryptoHandshakeTimeoutSeconds) {
            this.mCryptoHandshakeTimeoutSeconds = cryptoHandshakeTimeoutSeconds;
            return this;
        }

        public Builder setIdleConnectionTimeoutSeconds(long idleConnectionTimeoutSeconds) {
            this.mIdleConnectionTimeoutSeconds = idleConnectionTimeoutSeconds;
            return this;
        }

        @RequiresApi(value=26)
        public Builder setIdleConnectionTimeout(@NonNull Duration idleConnectionTimeout) {
            Objects.requireNonNull(idleConnectionTimeout);
            return this.setIdleConnectionTimeoutSeconds(idleConnectionTimeout.toSeconds());
        }

        @Experimental
        public Builder setRetransmittableOnWireTimeoutMillis(long retransmittableOnWireTimeoutMillis) {
            this.mRetransmittableOnWireTimeoutMillis = retransmittableOnWireTimeoutMillis;
            return this;
        }

        @Experimental
        public Builder closeSessionsOnIpChange(boolean closeSessionsOnIpChange) {
            this.mCloseSessionsOnIpChange = closeSessionsOnIpChange;
            return this;
        }

        @Experimental
        public Builder goawaySessionsOnIpChange(boolean goawaySessionsOnIpChange) {
            this.mGoawaySessionsOnIpChange = goawaySessionsOnIpChange;
            return this;
        }

        @Experimental
        public Builder setInitialBrokenServicePeriodSeconds(long initialBrokenServicePeriodSeconds) {
            this.mInitialBrokenServicePeriodSeconds = initialBrokenServicePeriodSeconds;
            return this;
        }

        @Experimental
        public Builder increaseBrokenServicePeriodExponentially(boolean increaseBrokenServicePeriodExponentially) {
            this.mIncreaseBrokenServicePeriodExponentially = increaseBrokenServicePeriodExponentially;
            return this;
        }

        @Experimental
        public Builder delayJobsWithAvailableSpdySession(boolean delayJobsWithAvailableSpdySession) {
            this.mDelayJobsWithAvailableSpdySession = delayJobsWithAvailableSpdySession;
            return this;
        }

        @QuichePassthroughOption
        public Builder addExtraQuicheFlag(String extraQuicheFlag) {
            this.mExtraQuicheFlags.add(extraQuicheFlag);
            return this;
        }

        public QuicOptions build() {
            return new QuicOptions(this);
        }
    }

    @RequiresOptIn
    public static @interface QuichePassthroughOption {
    }

    @RequiresOptIn
    public static @interface Experimental {
    }
}

