/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net.impl;

import android.content.Context;
import android.net.connectivity.javax.annotation.concurrent.GuardedBy;
import android.net.connectivity.org.chromium.base.BuildInfo;
import android.net.connectivity.org.chromium.base.ContextUtils;
import android.net.connectivity.org.chromium.base.Log;
import android.net.connectivity.org.chromium.base.metrics.ScopedSysTraceEvent;
import android.net.connectivity.org.chromium.net.NetworkChangeNotifier;
import android.net.connectivity.org.chromium.net.RegistrationPolicyAlwaysRegister;
import android.net.connectivity.org.chromium.net.httpflags.BaseFeature;
import android.net.connectivity.org.chromium.net.httpflags.Flags;
import android.net.connectivity.org.chromium.net.httpflags.HttpFlagsLoader;
import android.net.connectivity.org.chromium.net.httpflags.ResolvedFlags;
import android.net.connectivity.org.chromium.net.impl.CronetEngineBuilderImpl;
import android.net.connectivity.org.chromium.net.impl.CronetLibraryLoaderJni;
import android.net.connectivity.org.chromium.net.impl.CronetManifest;
import android.net.connectivity.org.chromium.net.impl.ImplVersion;
import android.net.connectivity.org.chromium.net.impl.UserAgent;
import android.net.connectivity.org.chromium.net.telemetry.Hash;
import android.net.connectivity.org.jni_zero.CalledByNative;
import android.net.connectivity.org.jni_zero.JNINamespace;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Process;
import android.os.SystemClock;
import android.util.Pair;
import com.android.internal.lang.System_Delegate;
import com.android.layoutlib.androidx.annotation.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JNINamespace(value="cronet")
@VisibleForTesting
public class CronetLibraryLoader {
    private static final Object sLoadLock = new Object();
    @GuardedBy(value="sLoadLock")
    private static boolean sInitialized;
    private static final String LIBRARY_NAME;
    private static final String TESTING_LIBRARY_NAME;
    private static boolean sSwitchToTestLibrary;
    @VisibleForTesting
    public static final String TAG;
    private static final HandlerThread sInitThread;
    private static final ConditionVariable sWaitForLibLoad;
    private static final ConditionVariable sHttpFlagsLoaded;
    @VisibleForTesting
    public static final String UPDATE_NETWORK_STATE_ONCE_ON_STARTUP_FLAG_NAME = "Cronet_UpdateNetworkStateOnlyOnceOnStartup";
    @VisibleForTesting
    public static final String INITIALIZE_BUILD_INFO_ON_STARTUP = "Cronet_InitializeBuildInfoOnStartup";
    private static ResolvedFlags sHttpFlags;
    private static CronetInitializedInfo sInitializedInfo;
    @VisibleForTesting
    public static final String LOG_FLAG_NAME = "Cronet_log_me";

    public static boolean ensureInitialized(Context applicationContext, CronetEngineBuilderImpl builder) {
        return CronetLibraryLoader.ensureInitialized(applicationContext, builder, false);
    }

    public static void preload() {
        CronetLibraryLoader.loadLibrary();
    }

    @VisibleForTesting
    public static void loadLibrary() {
        if (sSwitchToTestLibrary) {
            System_Delegate.loadLibrary(TESTING_LIBRARY_NAME);
        } else {
            System_Delegate.loadLibrary(LIBRARY_NAME);
        }
    }

    @VisibleForTesting
    public static void switchToTestLibrary() {
        sSwitchToTestLibrary = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ensureInitialized(Context applicationContext, CronetEngineBuilderImpl builder, boolean libAlreadyLoaded) {
        try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("CronetLibraryLoader#ensureInitialized");){
            Object object = sLoadLock;
            synchronized (object) {
                String implVersion;
                block35: {
                    if (!sInitialized) break block35;
                    boolean bl = false;
                    return bl;
                }
                ContextUtils.initApplicationContext(applicationContext);
                if (!sInitThread.isAlive()) {
                    try (ScopedSysTraceEvent startInitThreadTraceEvent = ScopedSysTraceEvent.scoped("CronetLibraryLoader#ensureInitialized starting init thread");){
                        sInitThread.start();
                        CronetLibraryLoader.postToInitThread(() -> CronetLibraryLoader.initializeOnInitThread());
                    }
                }
                if (!libAlreadyLoaded) {
                    try (ScopedSysTraceEvent loadLibTraceEvent = ScopedSysTraceEvent.scoped("CronetLibraryLoader#ensureInitialized loading native library");){
                        if (builder.libraryLoader() != null) {
                            builder.libraryLoader().loadLibrary(LIBRARY_NAME);
                        } else {
                            CronetLibraryLoader.loadLibrary();
                        }
                    }
                }
                try (ScopedSysTraceEvent nativeInitTraceEvent = ScopedSysTraceEvent.scoped("CronetLibraryLoader#ensureInitialized calling nativeInit");){
                    CronetLibraryLoaderJni.get().nativeInit();
                }
                ResolvedFlags.Value initializeBuildInfoOnStartup = CronetLibraryLoader.getHttpFlags().flags().get(INITIALIZE_BUILD_INFO_ON_STARTUP);
                if (initializeBuildInfoOnStartup == null || initializeBuildInfoOnStartup.getBoolValue()) {
                    BuildInfo.getInstance();
                }
                if (!(implVersion = ImplVersion.getCronetVersion()).equals(CronetLibraryLoaderJni.get().getCronetVersion())) {
                    throw new RuntimeException(String.format("Expected Cronet version number %s, actual version number %s.", implVersion, CronetLibraryLoaderJni.get().getCronetVersion()));
                }
                Log.i(TAG, "Cronet version: %s, arch: %s", (Object)implVersion, (Object)System.getProperty("os.arch"));
                CronetLibraryLoader.setNativeLoggingLevel();
                sWaitForLibLoad.open();
                sInitialized = true;
                boolean bl = true;
                return bl;
            }
        }
    }

    private static void setNativeLoggingLevel() {
        int loggingLevel;
        String nativeLogTag = "chromium";
        if (Log.isLoggable("chromium", 2)) {
            loggingLevel = -2;
        } else if (Log.isLoggable("chromium", 3)) {
            loggingLevel = -1;
        } else {
            return;
        }
        CronetLibraryLoaderJni.get().setMinLogLevel(loggingLevel);
    }

    private static boolean onInitThread() {
        return sInitThread.getLooper() == Looper.myLooper();
    }

    static void initializeOnInitThread() {
        try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("CronetLibraryLoader#initializeOnInitThread");){
            assert (CronetLibraryLoader.onInitThread());
            assert (sInitializedInfo == null);
            sInitializedInfo = new CronetInitializedInfo();
            try (ScopedSysTraceEvent httpFlagsTraceEvent = ScopedSysTraceEvent.scoped("CronetLibraryLoader#initializeOnInitThread loading HTTP flags");){
                Flags flags;
                long httpFlagsLoadingStartUptimeMillis = SystemClock.uptimeMillis();
                Context applicationContext = ContextUtils.getApplicationContext();
                assert (sHttpFlags == null);
                if (!CronetManifest.shouldReadHttpFlags(applicationContext)) {
                    Log.d(TAG, "Not loading HTTP flags because they are disabled in the manifest", new Object[0]);
                    flags = null;
                } else {
                    flags = HttpFlagsLoader.load(applicationContext);
                    CronetLibraryLoader.sInitializedInfo.httpFlagsSuccessful = flags != null;
                }
                sHttpFlags = ResolvedFlags.resolve(flags != null ? flags : (Flags)Flags.newBuilder().build(), applicationContext.getPackageName(), ImplVersion.getCronetVersion());
                CronetLibraryLoader.sInitializedInfo.httpFlagsLatencyMillis = (int)(SystemClock.uptimeMillis() - httpFlagsLoadingStartUptimeMillis);
            }
            sHttpFlagsLoaded.open();
            ResolvedFlags.Value logMe = sHttpFlags.flags().get(LOG_FLAG_NAME);
            if (logMe != null) {
                Log.i(TAG, "HTTP flags log line: %s", (Object)logMe.getStringValue());
            }
            CronetLibraryLoader.populateCronetInitializedHttpFlagNamesValues();
            NetworkChangeNotifier.init();
            ResolvedFlags.Value updateNetworkStateOnceFlagValue = CronetLibraryLoader.getHttpFlags().flags().get(UPDATE_NETWORK_STATE_ONCE_ON_STARTUP_FLAG_NAME);
            boolean updateNetworkStateOnce = updateNetworkStateOnceFlagValue != null && updateNetworkStateOnceFlagValue.getBoolValue();
            NetworkChangeNotifier.setAutoDetectConnectivityState(new RegistrationPolicyAlwaysRegister(), !updateNetworkStateOnce);
            try (ScopedSysTraceEvent libLoadTraceEvent = ScopedSysTraceEvent.scoped("CronetLibraryLoader#initializeOnInitThread waiting on library load");){
                sWaitForLibLoad.block();
            }
            try (ScopedSysTraceEvent nativeInitTraceEvent = ScopedSysTraceEvent.scoped("CronetLibraryLoader#ensureInitialized calling cronetInitOnInitThread");){
                CronetLibraryLoaderJni.get().cronetInitOnInitThread(!updateNetworkStateOnce);
            }
        }
    }

    private static void populateCronetInitializedHttpFlagNamesValues() {
        ArrayList<Pair<Long, Long>> hashedNamesValues = new ArrayList<Pair<Long, Long>>();
        for (Map.Entry<String, ResolvedFlags.Value> entry : sHttpFlags.flags().entrySet()) {
            hashedNamesValues.add(new Pair<Long, Long>(Hash.hash(entry.getKey()), CronetLibraryLoader.hashHttpFlagValueForLogging(entry.getValue())));
        }
        Collections.sort(hashedNamesValues, (left, right) -> ((Long)left.first).compareTo((Long)right.first));
        CronetLibraryLoader.sInitializedInfo.httpFlagsNames = new ArrayList<Long>();
        CronetLibraryLoader.sInitializedInfo.httpFlagsValues = new ArrayList<Long>();
        for (Pair pair : hashedNamesValues) {
            CronetLibraryLoader.sInitializedInfo.httpFlagsNames.add((Long)pair.first);
            CronetLibraryLoader.sInitializedInfo.httpFlagsValues.add((Long)pair.second);
        }
    }

    private static long hashHttpFlagValueForLogging(ResolvedFlags.Value value) {
        switch (value.getType()) {
            case BOOL: {
                return value.getBoolValue() ? 1L : 0L;
            }
            case INT: {
                return value.getIntValue();
            }
            case FLOAT: {
                return Math.round((double)value.getFloatValue() * 1.0E9);
            }
            case STRING: {
                return Hash.hash(value.getStringValue());
            }
            case BYTES: {
                return Hash.hash(value.getBytesValue().toByteArray());
            }
        }
        throw new IllegalArgumentException("Unexpected flag value type: " + value.getClass().getName());
    }

    public static CronetInitializedInfo getCronetInitializedInfo() {
        assert (sInitializedInfo != null);
        return sInitializedInfo;
    }

    public static void postToInitThread(Runnable r) {
        if (CronetLibraryLoader.onInitThread()) {
            r.run();
        } else {
            new Handler(sInitThread.getLooper()).post(r);
        }
    }

    public static ResolvedFlags getHttpFlags() {
        if (sHttpFlags == null) {
            try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("CronetLibraryLoader#getHttpFlags waiting for HTTP flags load");){
                sHttpFlagsLoaded.block();
            }
        } else {
            sHttpFlagsLoaded.block();
        }
        return sHttpFlags;
    }

    @CalledByNative
    private static byte[] getBaseFeatureOverrides() {
        return BaseFeature.getOverrides(CronetLibraryLoader.getHttpFlags()).toByteArray();
    }

    @CalledByNative
    private static String getDefaultUserAgent() {
        return UserAgent.getDefault();
    }

    @CalledByNative
    private static void ensureInitializedFromNative() {
        Context applicationContext = ContextUtils.getApplicationContext();
        assert (applicationContext != null);
        CronetLibraryLoader.ensureInitialized(applicationContext, null, true);
    }

    @CalledByNative
    private static void setNetworkThreadPriorityOnNetworkThread(int priority) {
        Log.d(TAG, "Setting network thread priority to " + priority, new Object[0]);
        Process.setThreadPriority(priority);
    }

    static {
        LIBRARY_NAME = "mainlinecronet." + ImplVersion.getCronetVersion();
        TESTING_LIBRARY_NAME = LIBRARY_NAME + "_for_testing";
        TAG = CronetLibraryLoader.class.getSimpleName();
        sInitThread = new HandlerThread("CronetInit");
        sWaitForLibLoad = new ConditionVariable();
        sHttpFlagsLoaded = new ConditionVariable();
    }

    static interface Natives {
        public void nativeInit();

        public void cronetInitOnInitThread(boolean var1);

        public String getCronetVersion();

        public void setMinLogLevel(int var1);
    }

    public static class CronetInitializedInfo {
        public int httpFlagsLatencyMillis = -1;
        public Boolean httpFlagsSuccessful;
        public List<Long> httpFlagsNames;
        public List<Long> httpFlagsValues;
    }
}

