/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net.impl;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.net.connectivity.org.chromium.base.metrics.ScopedSysTraceEvent;
import android.net.connectivity.org.chromium.net.impl.CronetLogger;
import android.os.Bundle;
import com.android.layoutlib.androidx.annotation.VisibleForTesting;

@VisibleForTesting
public class CronetManifest {
    @VisibleForTesting
    static final String META_DATA_HOLDER_SERVICE_NAME = "android.net.http.MetaDataHolder";
    @VisibleForTesting
    static final String ENABLE_TELEMETRY_META_DATA_KEY = "android.net.http.EnableTelemetry";
    @VisibleForTesting
    public static final String READ_HTTP_FLAGS_META_DATA_KEY = "android.net.http.ReadHttpFlags";
    private static final Object sLock = new Object();
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context sLastContext;
    private static Bundle sMetaData;

    private CronetManifest() {
    }

    public static boolean isAppOptedInForTelemetry(Context context, CronetLogger.CronetSource source) {
        boolean telemetryIsDefaultEnabled = source == CronetLogger.CronetSource.CRONET_SOURCE_PLATFORM || source == CronetLogger.CronetSource.CRONET_SOURCE_PLAY_SERVICES;
        return CronetManifest.getMetaData(context).getBoolean(ENABLE_TELEMETRY_META_DATA_KEY, telemetryIsDefaultEnabled);
    }

    public static boolean shouldReadHttpFlags(Context context) {
        return CronetManifest.getMetaData(context).getBoolean(READ_HTTP_FLAGS_META_DATA_KEY, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bundle getMetaData(Context context) {
        context = context.getApplicationContext();
        Object object = sLock;
        synchronized (object) {
            if (context != sLastContext) {
                try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("CronetManifest#getMetaData fetching info");){
                    ServiceInfo serviceInfo;
                    try {
                        serviceInfo = context.getPackageManager().getServiceInfo(new ComponentName(context, META_DATA_HOLDER_SERVICE_NAME), 787072);
                    }
                    catch (PackageManager.NameNotFoundException | NullPointerException e) {
                        serviceInfo = null;
                    }
                    sMetaData = serviceInfo != null && serviceInfo.metaData != null ? serviceInfo.metaData : new Bundle();
                    sLastContext = context;
                }
            }
            assert (sMetaData != null);
            return sMetaData;
        }
    }

    @VisibleForTesting
    public static void resetCache() {
        sMetaData = null;
        sLastContext = null;
    }
}

