/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net.telemetry;

import android.net.connectivity.org.chromium.net.telemetry.CronetLoggerImpl;
import android.util.Log;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Hash {
    private static final String TAG = CronetLoggerImpl.class.getSimpleName();
    private static final MessageDigest MD5_MESSAGE_DIGEST = Hash.getMd5MessageDigest();

    private static MessageDigest getMd5MessageDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            if (Log.isLoggable(TAG, 3)) {
                Log.d(TAG, "Error while instantiating messageDigest", e);
            }
            return null;
        }
    }

    public static long hash(byte[] bytes) {
        return MD5_MESSAGE_DIGEST == null || bytes == null || bytes.length == 0 ? 0L : ByteBuffer.wrap(MD5_MESSAGE_DIGEST.digest(bytes)).getLong();
    }

    public static long hash(String string2) {
        return MD5_MESSAGE_DIGEST == null || string2 == null || string2.isEmpty() ? 0L : Hash.hash(string2.getBytes(StandardCharsets.UTF_8));
    }
}

