/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net.telemetry;

public class SizeBuckets {
    public static int calcRequestHeadersSizeBucket(long sizeBytes) {
        SizeBuckets.checkSizeIsValid(sizeBytes, "Request header size is negative");
        double sizeKB = (double)sizeBytes / 1024.0;
        if (SizeBuckets.isInClosedOpenRange(sizeKB, 0, 1)) {
            return 1;
        }
        if (SizeBuckets.isInClosedOpenRange(sizeKB, 1, 10)) {
            return 2;
        }
        if (SizeBuckets.isInClosedOpenRange(sizeKB, 10, 25)) {
            return 3;
        }
        if (SizeBuckets.isInClosedOpenRange(sizeKB, 25, 50)) {
            return 4;
        }
        if (SizeBuckets.isInClosedOpenRange(sizeKB, 50, 100)) {
            return 5;
        }
        return 6;
    }

    public static int calcResponseHeadersSizeBucket(long sizeBytes) {
        SizeBuckets.checkSizeIsValid(sizeBytes, "Response header size is negative");
        double sizeKB = (double)sizeBytes / 1024.0;
        if (SizeBuckets.isInClosedOpenRange(sizeKB, 0, 1)) {
            return 1;
        }
        if (SizeBuckets.isInClosedOpenRange(sizeKB, 1, 10)) {
            return 2;
        }
        if (SizeBuckets.isInClosedOpenRange(sizeKB, 10, 25)) {
            return 3;
        }
        if (SizeBuckets.isInClosedOpenRange(sizeKB, 25, 50)) {
            return 4;
        }
        if (SizeBuckets.isInClosedOpenRange(sizeKB, 50, 100)) {
            return 5;
        }
        return 6;
    }

    public static int calcRequestBodySizeBucket(long sizeBytes) {
        SizeBuckets.checkSizeIsValid(sizeBytes, "Request body size is negative");
        double sizeKB = (double)sizeBytes / 1024.0;
        if (sizeKB == 0.0) {
            return 1;
        }
        if (sizeKB > 0.0 && sizeKB < 10.0) {
            return 2;
        }
        if (SizeBuckets.isInClosedOpenRange(sizeKB, 10, 50)) {
            return 3;
        }
        if (SizeBuckets.isInClosedOpenRange(sizeKB, 50, 200)) {
            return 4;
        }
        if (SizeBuckets.isInClosedOpenRange(sizeKB, 200, 500)) {
            return 5;
        }
        if (SizeBuckets.isInClosedOpenRange(sizeKB, 500, 1000)) {
            return 6;
        }
        if (SizeBuckets.isInClosedOpenRange(sizeKB, 1000, 5000)) {
            return 7;
        }
        return 8;
    }

    public static int calcResponseBodySizeBucket(long sizeBytes) {
        SizeBuckets.checkSizeIsValid(sizeBytes, "Response body size is negative");
        double sizeKB = (double)sizeBytes / 1024.0;
        if (sizeKB == 0.0) {
            return 1;
        }
        if (sizeKB > 0.0 && sizeKB < 10.0) {
            return 2;
        }
        if (SizeBuckets.isInClosedOpenRange(sizeKB, 10, 50)) {
            return 3;
        }
        if (SizeBuckets.isInClosedOpenRange(sizeKB, 50, 200)) {
            return 4;
        }
        if (SizeBuckets.isInClosedOpenRange(sizeKB, 200, 500)) {
            return 5;
        }
        if (SizeBuckets.isInClosedOpenRange(sizeKB, 500, 1000)) {
            return 6;
        }
        if (SizeBuckets.isInClosedOpenRange(sizeKB, 1000, 5000)) {
            return 7;
        }
        return 8;
    }

    private static void checkSizeIsValid(long sizeBytes, String errMessage) {
        if (sizeBytes < 0L) {
            throw new IllegalArgumentException(errMessage);
        }
    }

    private static boolean isInClosedOpenRange(double value, int lowerBound, int upperBound) {
        return value >= (double)lowerBound && value < (double)upperBound;
    }

    private SizeBuckets() {
    }
}

