/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.connectivity.org.chromium.net.BidirectionalStream;
import android.net.connectivity.org.chromium.net.CronetException;
import android.net.connectivity.org.chromium.net.UrlResponseInfo;
import android.net.http.BidirectionalStream;
import android.net.http.BidirectionalStreamWrapper;
import android.net.http.CronetExceptionTranslationUtils;
import android.net.http.HeaderBlockWrapper;
import android.net.http.HttpException;
import android.net.http.UrlResponseInfoWrapper;
import java.nio.ByteBuffer;

public class BidirectionalStreamCallbackWrapper
extends BidirectionalStream.Callback {
    private final BidirectionalStream.Callback backend;
    private BidirectionalStreamWrapper mOriginalStreamWrapper;

    public BidirectionalStreamCallbackWrapper(BidirectionalStream.Callback backend) {
        this.backend = backend;
    }

    public void setOriginalStreamWrapper(BidirectionalStreamWrapper wrapper) {
        this.mOriginalStreamWrapper = wrapper;
    }

    public BidirectionalStreamWrapper createWrapperFromStream(BidirectionalStream stream) {
        return new BidirectionalStreamWrapper(stream, this.mOriginalStreamWrapper.getHttpMethod(), this.mOriginalStreamWrapper.hasTrafficStatsTag(), this.mOriginalStreamWrapper.hasTrafficStatsTag() ? this.mOriginalStreamWrapper.getTrafficStatsTag() : 0, this.mOriginalStreamWrapper.hasTrafficStatsUid(), this.mOriginalStreamWrapper.hasTrafficStatsUid() ? this.mOriginalStreamWrapper.getTrafficStatsUid() : 0, this.mOriginalStreamWrapper.getPriority(), this.mOriginalStreamWrapper.getHeaders(), this.mOriginalStreamWrapper.isDelayRequestHeadersUntilFirstFlushEnabled());
    }

    @Override
    public void onStreamReady(BidirectionalStream stream) {
        BidirectionalStreamWrapper wrappedStream = this.createWrapperFromStream(stream);
        this.backend.onStreamReady(wrappedStream);
    }

    @Override
    public void onResponseHeadersReceived(BidirectionalStream stream, UrlResponseInfo info) {
        BidirectionalStreamWrapper wrappedStream = this.createWrapperFromStream(stream);
        UrlResponseInfoWrapper wrappedInfo = new UrlResponseInfoWrapper(info);
        this.backend.onResponseHeadersReceived(wrappedStream, wrappedInfo);
    }

    @Override
    public void onReadCompleted(BidirectionalStream stream, UrlResponseInfo info, ByteBuffer byteBuffer, boolean endOfStream) {
        BidirectionalStreamWrapper wrappedStream = this.createWrapperFromStream(stream);
        UrlResponseInfoWrapper wrappedInfo = new UrlResponseInfoWrapper(info);
        this.backend.onReadCompleted(wrappedStream, wrappedInfo, byteBuffer, endOfStream);
    }

    @Override
    public void onWriteCompleted(BidirectionalStream stream, UrlResponseInfo info, ByteBuffer byteBuffer, boolean endOfStream) {
        BidirectionalStreamWrapper wrappedStream = this.createWrapperFromStream(stream);
        UrlResponseInfoWrapper wrappedInfo = new UrlResponseInfoWrapper(info);
        this.backend.onWriteCompleted(wrappedStream, wrappedInfo, byteBuffer, endOfStream);
    }

    @Override
    public void onResponseTrailersReceived(BidirectionalStream stream, UrlResponseInfo info, UrlResponseInfo.HeaderBlock headers) {
        BidirectionalStreamWrapper wrappedStream = this.createWrapperFromStream(stream);
        UrlResponseInfoWrapper wrappedInfo = new UrlResponseInfoWrapper(info);
        HeaderBlockWrapper wrappedHeaders = new HeaderBlockWrapper(headers);
        this.backend.onResponseTrailersReceived(wrappedStream, wrappedInfo, wrappedHeaders);
    }

    @Override
    public void onSucceeded(BidirectionalStream stream, UrlResponseInfo info) {
        BidirectionalStreamWrapper wrappedStream = this.createWrapperFromStream(stream);
        UrlResponseInfoWrapper wrappedInfo = new UrlResponseInfoWrapper(info);
        this.backend.onSucceeded(wrappedStream, wrappedInfo);
    }

    @Override
    public void onFailed(BidirectionalStream stream, UrlResponseInfo info, CronetException e) {
        BidirectionalStreamWrapper wrappedStream = this.createWrapperFromStream(stream);
        UrlResponseInfoWrapper wrappedInfo = new UrlResponseInfoWrapper(info);
        HttpException wrappedException = CronetExceptionTranslationUtils.translateException(e);
        this.backend.onFailed(wrappedStream, wrappedInfo, wrappedException);
    }

    @Override
    public void onCanceled(BidirectionalStream stream, UrlResponseInfo info) {
        BidirectionalStreamWrapper wrappedStream = this.createWrapperFromStream(stream);
        UrlResponseInfoWrapper wrappedInfo = new UrlResponseInfoWrapper(info);
        this.backend.onCanceled(wrappedStream, wrappedInfo);
    }
}

