/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.Network;
import android.net.connectivity.org.chromium.net.ExperimentalCronetEngine;
import android.net.http.BidirectionalStream;
import android.net.http.BidirectionalStreamBuilderWrapper;
import android.net.http.CronetExceptionTranslationUtils;
import android.net.http.HttpEngine;
import android.net.http.UrlRequest;
import android.net.http.UrlRequestBuilderWrapper;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import java.util.concurrent.Executor;

class CronetEngineWrapper
extends HttpEngine {
    private final ExperimentalCronetEngine backend;

    public CronetEngineWrapper(ExperimentalCronetEngine backend) {
        this.backend = backend;
    }

    @Override
    public void shutdown() {
        this.backend.shutdown();
    }

    @Override
    public URLConnection openConnection(URL url) throws IOException {
        return CronetExceptionTranslationUtils.executeTranslatingExceptions(() -> this.backend.openConnection(url));
    }

    @Override
    public URLStreamHandlerFactory createUrlStreamHandlerFactory() {
        return this.backend.createURLStreamHandlerFactory();
    }

    @Override
    public void bindToNetwork(Network network) {
        long networkHandle = -1L;
        if (network != null) {
            networkHandle = network.getNetworkHandle();
        }
        this.backend.bindToNetwork(networkHandle);
    }

    @Override
    public BidirectionalStream.Builder newBidirectionalStreamBuilder(String url, Executor executor, BidirectionalStream.Callback callback) {
        return new BidirectionalStreamBuilderWrapper(this.backend, url, executor, callback);
    }

    @Override
    public UrlRequest.Builder newUrlRequestBuilder(String url, Executor executor, UrlRequest.Callback callback) {
        return new UrlRequestBuilderWrapper(this.backend, url, executor, callback);
    }
}

