/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.http.HeaderBlock;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HeaderBlockImpl
extends HeaderBlock {
    private final List<Map.Entry<String, String>> mAllHeadersList;
    private Map<String, List<String>> mAllHeadersMap;

    public HeaderBlockImpl(List<Map.Entry<String, String>> allHeaders) {
        this.mAllHeadersList = Collections.unmodifiableList(allHeaders);
    }

    @Override
    @NonNull
    public List<Map.Entry<String, String>> getAsList() {
        return this.mAllHeadersList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Map<String, List<String>> getAsMap() {
        if (this.mAllHeadersMap != null) {
            return this.mAllHeadersMap;
        }
        List<Map.Entry<String, String>> list = this.mAllHeadersList;
        synchronized (list) {
            TreeMap map = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            for (Map.Entry<String, String> entry : this.mAllHeadersList) {
                ArrayList<String> values = new ArrayList<String>();
                if (map.containsKey(entry.getKey())) {
                    values.addAll((Collection)map.get(entry.getKey()));
                }
                values.add(entry.getValue());
                map.put(entry.getKey(), Collections.unmodifiableList(values));
            }
            this.mAllHeadersMap = Collections.unmodifiableMap(map);
        }
        return this.mAllHeadersMap;
    }
}

