/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.annotation.FlaggedApi;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.Context;
import android.net.Network;
import android.net.connectivity.org.chromium.base.metrics.ScopedSysTraceEvent;
import android.net.connectivity.org.chromium.net.ApiVersion;
import android.net.connectivity.org.chromium.net.ExperimentalCronetEngine;
import android.net.connectivity.org.chromium.net.impl.CronetLibraryLoader;
import android.net.connectivity.org.chromium.net.impl.NativeCronetEngineBuilderImpl;
import android.net.http.BidirectionalStream;
import android.net.http.ConnectionMigrationOptions;
import android.net.http.CronetEngineBuilderWrapper;
import android.net.http.DnsOptions;
import android.net.http.Flags;
import android.net.http.HttpEngineJavaClasses;
import android.net.http.IHttpEngineBuilder;
import android.net.http.QuicOptions;
import android.net.http.UrlRequest;
import com.android.internal.annotations.VisibleForTesting;
import com.android.layoutlib.androidx.annotation.NonNull;
import com.android.layoutlib.androidx.annotation.Nullable;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import java.time.Instant;
import java.util.Set;
import java.util.concurrent.Executor;

@SuppressLint(value={"NotCloseable"})
public abstract class HttpEngine {
    private static boolean sPreloaded = false;

    protected HttpEngine() {
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="android.net.http.preload_httpengine_in_zygote")
    public static void preload() {
        if (sPreloaded) {
            throw new IllegalStateException("HttpEngine already preloaded");
        }
        if (Flags.preloadHttpengineSharedLibrary()) {
            CronetLibraryLoader.preload();
        }
        try {
            if (Flags.preloadHttpengineJavaImplClasses()) {
                for (String clazz : HttpEngineJavaClasses.ALL_CLASSES) {
                    Class.forName(clazz, true, null);
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to preload class", e);
        }
        finally {
            sPreloaded = true;
        }
    }

    @NonNull
    public static Builder builder(@NonNull Context context) {
        return new Builder(context);
    }

    @NonNull
    public static String getVersionString() {
        return ApiVersion.getCronetVersion();
    }

    public abstract void shutdown();

    public void bindToNetwork(@Nullable Network network) {
    }

    @SuppressLint(value={"AndroidUri"})
    @NonNull
    public abstract URLConnection openConnection(@SuppressLint(value={"AndroidUri"}) @NonNull URL var1) throws IOException;

    @SuppressLint(value={"AndroidUri"})
    @NonNull
    public abstract URLStreamHandlerFactory createUrlStreamHandlerFactory();

    @NonNull
    public abstract UrlRequest.Builder newUrlRequestBuilder(@NonNull String var1, @NonNull Executor var2, @NonNull UrlRequest.Callback var3);

    @NonNull
    public abstract BidirectionalStream.Builder newBidirectionalStreamBuilder(@NonNull String var1, @NonNull Executor var2, @NonNull BidirectionalStream.Callback var3);

    @SuppressLint(value={"StaticFinalBuilder"})
    public static class Builder {
        protected final IHttpEngineBuilder mBuilderDelegate;
        public static final int HTTP_CACHE_DISABLED = 0;
        public static final int HTTP_CACHE_IN_MEMORY = 1;
        public static final int HTTP_CACHE_DISK_NO_HTTP = 2;
        public static final int HTTP_CACHE_DISK = 3;

        public Builder(@NonNull Context context) {
            this(Builder.createBuilderDelegate(context));
        }

        @VisibleForTesting
        public Builder(@NonNull IHttpEngineBuilder builderDelegate) {
            this.mBuilderDelegate = builderDelegate;
        }

        @NonNull
        @SuppressLint(value={"GetterOnBuilder"})
        public String getDefaultUserAgent() {
            return this.mBuilderDelegate.getDefaultUserAgent();
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setUserAgent(@NonNull String userAgent) {
            this.mBuilderDelegate.setUserAgent(userAgent);
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setStoragePath(@NonNull String value) {
            this.mBuilderDelegate.setStoragePath(value);
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setEnableQuic(boolean value) {
            this.mBuilderDelegate.setEnableQuic(value);
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setEnableHttp2(boolean value) {
            this.mBuilderDelegate.setEnableHttp2(value);
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setEnableBrotli(boolean value) {
            this.mBuilderDelegate.setEnableBrotli(value);
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setEnableHttpCache(int cacheMode, long maxSize) {
            this.mBuilderDelegate.setEnableHttpCache(cacheMode, maxSize);
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addQuicHint(@NonNull String host, int port, int alternatePort) {
            this.mBuilderDelegate.addQuicHint(host, port, alternatePort);
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addPublicKeyPins(@NonNull String hostName, @NonNull Set<byte[]> pinsSha256, boolean includeSubdomains, @NonNull Instant expirationInstant) {
            this.mBuilderDelegate.addPublicKeyPins(hostName, pinsSha256, includeSubdomains, expirationInstant);
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setEnablePublicKeyPinningBypassForLocalTrustAnchors(boolean value) {
            this.mBuilderDelegate.setEnablePublicKeyPinningBypassForLocalTrustAnchors(value);
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @QuicOptions.Experimental
        public Builder setQuicOptions(@NonNull QuicOptions quicOptions) {
            this.mBuilderDelegate.setQuicOptions(quicOptions);
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @DnsOptions.Experimental
        public Builder setDnsOptions(@NonNull DnsOptions dnsOptions) {
            this.mBuilderDelegate.setDnsOptions(dnsOptions);
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @ConnectionMigrationOptions.Experimental
        public Builder setConnectionMigrationOptions(@NonNull ConnectionMigrationOptions connectionMigrationOptions) {
            this.mBuilderDelegate.setConnectionMigrationOptions(connectionMigrationOptions);
            return this;
        }

        @NonNull
        public HttpEngine build() {
            try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("HttpEngine#build");){
                HttpEngine httpEngine = this.mBuilderDelegate.build();
                return httpEngine;
            }
        }

        private static IHttpEngineBuilder createBuilderDelegate(Context context) {
            try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("HttpEngine#createBuilderDelegate");){
                CronetEngineBuilderWrapper cronetEngineBuilderWrapper = new CronetEngineBuilderWrapper(new ExperimentalCronetEngine.Builder(new NativeCronetEngineBuilderImpl(context)));
                return cronetEngineBuilderWrapper;
            }
        }
    }
}

