/*
 * Decompiled with CFR 0.152.
 */
package android.net.ipsec.ike;

import android.annotation.NonNull;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.net.InetAddresses;
import android.net.ipsec.ike.ChildSaProposal;
import android.net.ipsec.ike.IkeTrafficSelector;
import android.net.ipsec.ike.SaProposal;
import android.net.ipsec.ike.TransportModeChildSessionParams;
import android.net.ipsec.ike.TunnelModeChildSessionParams;
import android.os.PersistableBundle;
import com.android.internal.net.vcn.util.PersistableBundleUtils;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public abstract class ChildSessionParams {
    protected static final int CHILD_HARD_LIFETIME_SEC_MINIMUM = 300;
    protected static final int CHILD_HARD_LIFETIME_SEC_MAXIMUM = 14400;
    protected static final int CHILD_HARD_LIFETIME_SEC_DEFAULT = 7200;
    protected static final int CHILD_SOFT_LIFETIME_SEC_MINIMUM = 120;
    protected static final int CHILD_SOFT_LIFETIME_SEC_DEFAULT = 3600;
    protected static final int CHILD_LIFETIME_MARGIN_SEC_MINIMUM = (int)TimeUnit.MINUTES.toSeconds(1L);
    @NonNull
    private static final IkeTrafficSelector DEFAULT_TRAFFIC_SELECTOR_IPV4 = ChildSessionParams.buildDefaultTrafficSelector(7);
    @NonNull
    private static final IkeTrafficSelector DEFAULT_TRAFFIC_SELECTOR_IPV6 = ChildSessionParams.buildDefaultTrafficSelector(8);
    private static final String IS_TRANPORT_KEY = "mIsTransport";
    protected static final String INBOUND_TS_KEY = "mInboundTrafficSelectors";
    protected static final String OUTBOUND_TS_KEY = "mOutboundTrafficSelectors";
    protected static final String SA_PROPOSALS_KEY = "mSaProposals";
    protected static final String HARD_LIFETIME_SEC_KEY = "mHardLifetimeSec";
    protected static final String SOFT_LIFETIME_SEC_KEY = "mSoftLifetimeSec";
    @NonNull
    private final IkeTrafficSelector[] mInboundTrafficSelectors;
    @NonNull
    private final IkeTrafficSelector[] mOutboundTrafficSelectors;
    @NonNull
    private final ChildSaProposal[] mSaProposals;
    private final int mHardLifetimeSec;
    private final int mSoftLifetimeSec;
    private final boolean mIsTransport;

    protected ChildSessionParams(IkeTrafficSelector[] inboundTs, IkeTrafficSelector[] outboundTs, ChildSaProposal[] proposals, int hardLifetimeSec, int softLifetimeSec, boolean isTransport) {
        this.mInboundTrafficSelectors = inboundTs;
        this.mOutboundTrafficSelectors = outboundTs;
        this.mSaProposals = proposals;
        this.mHardLifetimeSec = hardLifetimeSec;
        this.mSoftLifetimeSec = softLifetimeSec;
        this.mIsTransport = isTransport;
    }

    @NonNull
    public static ChildSessionParams fromPersistableBundle(@NonNull PersistableBundle in) {
        Objects.requireNonNull(in, "PersistableBundle is null");
        if (in.getBoolean(IS_TRANPORT_KEY)) {
            return TransportModeChildSessionParams.fromPersistableBundle(in);
        }
        return TunnelModeChildSessionParams.fromPersistableBundle(in);
    }

    @NonNull
    public PersistableBundle toPersistableBundle() {
        PersistableBundle result = new PersistableBundle();
        result.putBoolean(IS_TRANPORT_KEY, this.mIsTransport);
        PersistableBundle saProposalBundle = PersistableBundleUtils.fromList(Arrays.asList(this.mSaProposals), ChildSaProposal::toPersistableBundle);
        result.putPersistableBundle(SA_PROPOSALS_KEY, saProposalBundle);
        PersistableBundle inTsBundle = PersistableBundleUtils.fromList(Arrays.asList(this.mInboundTrafficSelectors), IkeTrafficSelector::toPersistableBundle);
        result.putPersistableBundle(INBOUND_TS_KEY, inTsBundle);
        PersistableBundle outTsBundle = PersistableBundleUtils.fromList(Arrays.asList(this.mOutboundTrafficSelectors), IkeTrafficSelector::toPersistableBundle);
        result.putPersistableBundle(OUTBOUND_TS_KEY, outTsBundle);
        result.putInt(HARD_LIFETIME_SEC_KEY, this.mHardLifetimeSec);
        result.putInt(SOFT_LIFETIME_SEC_KEY, this.mSoftLifetimeSec);
        return result;
    }

    protected static List<ChildSaProposal> getProposalsFromPersistableBundle(PersistableBundle in) {
        PersistableBundle proposalBundle = in.getPersistableBundle(SA_PROPOSALS_KEY);
        Objects.requireNonNull(proposalBundle, "Value for key mSaProposals was null");
        return PersistableBundleUtils.toList(proposalBundle, ChildSaProposal::fromPersistableBundle);
    }

    protected static List<IkeTrafficSelector> getTsFromPersistableBundle(PersistableBundle in, String key) {
        PersistableBundle tsBundle = in.getPersistableBundle(key);
        Objects.requireNonNull(tsBundle, "Value for key " + key + " was null");
        return PersistableBundleUtils.toList(tsBundle, IkeTrafficSelector::fromPersistableBundle);
    }

    @NonNull
    public List<IkeTrafficSelector> getInboundTrafficSelectors() {
        return Arrays.asList(this.mInboundTrafficSelectors);
    }

    @NonNull
    public List<IkeTrafficSelector> getOutboundTrafficSelectors() {
        return Arrays.asList(this.mOutboundTrafficSelectors);
    }

    @Deprecated
    @SystemApi
    @NonNull
    public List<ChildSaProposal> getSaProposals() {
        return this.getChildSaProposals();
    }

    @NonNull
    public List<ChildSaProposal> getChildSaProposals() {
        return Arrays.asList(this.mSaProposals);
    }

    @SuppressLint(value={"MethodNameUnits"})
    public int getHardLifetimeSeconds() {
        return this.mHardLifetimeSec;
    }

    @SuppressLint(value={"MethodNameUnits"})
    public int getSoftLifetimeSeconds() {
        return this.mSoftLifetimeSec;
    }

    public IkeTrafficSelector[] getInboundTrafficSelectorsInternal() {
        return Arrays.copyOf(this.mInboundTrafficSelectors, this.mInboundTrafficSelectors.length);
    }

    public IkeTrafficSelector[] getOutboundTrafficSelectorsInternal() {
        return Arrays.copyOf(this.mOutboundTrafficSelectors, this.mOutboundTrafficSelectors.length);
    }

    public ChildSaProposal[] getSaProposalsInternal() {
        return Arrays.copyOf(this.mSaProposals, this.mSaProposals.length);
    }

    public long getHardLifetimeMsInternal() {
        return TimeUnit.SECONDS.toMillis(this.mHardLifetimeSec);
    }

    public long getSoftLifetimeMsInternal() {
        return TimeUnit.SECONDS.toMillis(this.mSoftLifetimeSec);
    }

    public boolean isTransportMode() {
        return this.mIsTransport;
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.mInboundTrafficSelectors), Arrays.hashCode(this.mOutboundTrafficSelectors), Arrays.hashCode(this.mSaProposals), this.mHardLifetimeSec, this.mSoftLifetimeSec, this.mIsTransport);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ChildSessionParams)) {
            return false;
        }
        ChildSessionParams other = (ChildSessionParams)o;
        return Arrays.equals(this.mInboundTrafficSelectors, other.mInboundTrafficSelectors) && Arrays.equals(this.mOutboundTrafficSelectors, other.mOutboundTrafficSelectors) && Arrays.equals(this.mSaProposals, other.mSaProposals) && this.mHardLifetimeSec == other.mHardLifetimeSec && this.mSoftLifetimeSec == other.mSoftLifetimeSec && this.mIsTransport == other.mIsTransport;
    }

    private static IkeTrafficSelector buildDefaultTrafficSelector(int tsType) {
        int startPort = 0;
        int endPort = 65535;
        InetAddress startAddress = null;
        InetAddress endAddress = null;
        switch (tsType) {
            case 7: {
                startAddress = InetAddresses.parseNumericAddress("0.0.0.0");
                endAddress = InetAddresses.parseNumericAddress("255.255.255.255");
                break;
            }
            case 8: {
                startAddress = InetAddresses.parseNumericAddress("::");
                endAddress = InetAddresses.parseNumericAddress("ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Traffic Selector type: " + tsType);
            }
        }
        return new IkeTrafficSelector(tsType, startPort, endPort, startAddress, endAddress);
    }

    protected static abstract class Builder {
        @NonNull
        protected final List<IkeTrafficSelector> mInboundTsList = new LinkedList<IkeTrafficSelector>();
        @NonNull
        protected final List<IkeTrafficSelector> mOutboundTsList = new LinkedList<IkeTrafficSelector>();
        @NonNull
        protected final List<SaProposal> mSaProposalList = new LinkedList<SaProposal>();
        protected int mHardLifetimeSec = 7200;
        protected int mSoftLifetimeSec = 3600;

        Builder() {
        }

        Builder(@NonNull ChildSessionParams childParams) {
            Objects.requireNonNull(childParams, "childParams was null");
            this.mInboundTsList.addAll(childParams.getInboundTrafficSelectors());
            this.mOutboundTsList.addAll(childParams.getOutboundTrafficSelectors());
            this.mSaProposalList.addAll(childParams.getSaProposals());
            this.mHardLifetimeSec = childParams.getHardLifetimeSeconds();
            this.mSoftLifetimeSec = childParams.getSoftLifetimeSeconds();
        }

        protected void addProposal(@NonNull ChildSaProposal proposal) {
            this.mSaProposalList.add(proposal);
        }

        protected void addInboundTs(@NonNull IkeTrafficSelector trafficSelector) {
            this.mInboundTsList.add(trafficSelector);
        }

        protected void addOutboundTs(@NonNull IkeTrafficSelector trafficSelector) {
            this.mOutboundTsList.add(trafficSelector);
        }

        protected void validateAndSetLifetime(int hardLifetimeSec, int softLifetimeSec) {
            if (hardLifetimeSec < 300 || hardLifetimeSec > 14400 || softLifetimeSec < 120 || hardLifetimeSec - softLifetimeSec < CHILD_LIFETIME_MARGIN_SEC_MINIMUM) {
                throw new IllegalArgumentException("Invalid lifetime value");
            }
        }

        protected void validateOrThrow() {
            if (this.mSaProposalList.isEmpty()) {
                throw new IllegalArgumentException("ChildSessionParams requires at least one Child SA proposal.");
            }
        }

        protected void addDefaultTsIfNotConfigured() {
            if (this.mInboundTsList.isEmpty()) {
                this.mInboundTsList.add(DEFAULT_TRAFFIC_SELECTOR_IPV4);
                this.mInboundTsList.add(DEFAULT_TRAFFIC_SELECTOR_IPV6);
            }
            if (this.mOutboundTsList.isEmpty()) {
                this.mOutboundTsList.add(DEFAULT_TRAFFIC_SELECTOR_IPV4);
                this.mOutboundTsList.add(DEFAULT_TRAFFIC_SELECTOR_IPV6);
            }
        }
    }
}

