/*
 * Decompiled with CFR 0.152.
 */
package android.net.netstats.provider;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.NetworkStats;
import android.net.netstats.provider.INetworkStatsProvider;
import android.net.netstats.provider.INetworkStatsProviderCallback;
import android.os.RemoteException;

@SystemApi
public abstract class NetworkStatsProvider {
    public static final int QUOTA_UNLIMITED = -1;
    @NonNull
    private final INetworkStatsProvider mProviderBinder = new INetworkStatsProvider.Stub(){

        @Override
        public void onRequestStatsUpdate(int token) {
            NetworkStatsProvider.this.onRequestStatsUpdate(token);
        }

        @Override
        public void onSetAlert(long quotaBytes) {
            NetworkStatsProvider.this.onSetAlert(quotaBytes);
        }

        @Override
        public void onSetWarningAndLimit(String iface, long warningBytes, long limitBytes) {
            NetworkStatsProvider.this.onSetWarningAndLimit(iface, warningBytes, limitBytes);
        }
    };
    @Nullable
    private INetworkStatsProviderCallback mProviderCbBinder;

    @NonNull
    public INetworkStatsProvider getProviderBinder() {
        return this.mProviderBinder;
    }

    public void setProviderCallbackBinder(@NonNull INetworkStatsProviderCallback binder) {
        if (this.mProviderCbBinder != null) {
            throw new IllegalArgumentException("provider is already registered");
        }
        this.mProviderCbBinder = binder;
    }

    @Nullable
    public INetworkStatsProviderCallback getProviderCallbackBinder() {
        return this.mProviderCbBinder;
    }

    @NonNull
    public INetworkStatsProviderCallback getProviderCallbackBinderOrThrow() {
        if (this.mProviderCbBinder == null) {
            throw new IllegalStateException("the provider is not registered");
        }
        return this.mProviderCbBinder;
    }

    public void notifyStatsUpdated(int token, @NonNull NetworkStats ifaceStats, @NonNull NetworkStats uidStats) {
        try {
            this.getProviderCallbackBinderOrThrow().notifyStatsUpdated(token, ifaceStats, uidStats);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    public void notifyAlertReached() {
        try {
            this.getProviderCallbackBinderOrThrow().notifyAlertReached();
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    public void notifyWarningReached() {
        try {
            this.getProviderCallbackBinderOrThrow().notifyWarningReached();
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    public void notifyLimitReached() {
        try {
            this.getProviderCallbackBinderOrThrow().notifyLimitReached();
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    public abstract void onRequestStatsUpdate(int var1);

    public abstract void onSetLimit(@NonNull String var1, long var2);

    public void onSetWarningAndLimit(@NonNull String iface, long warningBytes, long limitBytes) {
        this.onSetLimit(iface, limitBytes);
    }

    public abstract void onSetAlert(long var1);
}

