/*
 * Decompiled with CFR 0.152.
 */
package android.net.nsd;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.Network;
import android.net.nsd.NsdManager;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.Objects;

@FlaggedApi(value="com.android.net.flags.nsd_subtypes_support_enabled")
public class DiscoveryRequest
implements Parcelable {
    private final int mProtocolType;
    @NonNull
    private final String mServiceType;
    @Nullable
    private final String mSubtype;
    @Nullable
    private final Network mNetwork;
    @NonNull
    public static final Parcelable.Creator<DiscoveryRequest> CREATOR = new Parcelable.Creator<DiscoveryRequest>(){

        @Override
        public DiscoveryRequest createFromParcel(Parcel in) {
            int protocolType = in.readInt();
            String serviceType = in.readString();
            String subtype = in.readString();
            Network network = in.readParcelable(Network.class.getClassLoader(), Network.class);
            return new DiscoveryRequest(protocolType, serviceType, subtype, network);
        }

        public DiscoveryRequest[] newArray(int size) {
            return new DiscoveryRequest[size];
        }
    };

    private DiscoveryRequest(int protocolType, @NonNull String serviceType, @Nullable String subtype, @Nullable Network network) {
        this.mProtocolType = protocolType;
        this.mServiceType = serviceType;
        this.mSubtype = subtype;
        this.mNetwork = network;
    }

    @NonNull
    public String getServiceType() {
        return this.mServiceType;
    }

    @Nullable
    public String getSubtype() {
        return this.mSubtype;
    }

    public int getProtocolType() {
        return this.mProtocolType;
    }

    @Nullable
    public Network getNetwork() {
        return this.mNetwork;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(", protocolType: ").append(this.mProtocolType).append(", serviceType: ").append(this.mServiceType).append(", subtype: ").append(this.mSubtype).append(", network: ").append(this.mNetwork);
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DiscoveryRequest)) {
            return false;
        }
        DiscoveryRequest otherRequest = (DiscoveryRequest)other;
        return this.mProtocolType == otherRequest.mProtocolType && Objects.equals(this.mServiceType, otherRequest.mServiceType) && Objects.equals(this.mSubtype, otherRequest.mSubtype) && Objects.equals(this.mNetwork, otherRequest.mNetwork);
    }

    public int hashCode() {
        return Objects.hash(this.mProtocolType, this.mServiceType, this.mSubtype, this.mNetwork);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mProtocolType);
        dest.writeString(this.mServiceType);
        dest.writeString(this.mSubtype);
        dest.writeParcelable(this.mNetwork, flags);
    }

    public static class Builder {
        private final int mProtocolType;
        @NonNull
        private String mServiceType;
        @Nullable
        private String mSubtype;
        @Nullable
        private Network mNetwork;

        public Builder(@NonNull String serviceType) {
            this(1, serviceType);
        }

        public Builder(int protocolType, @NonNull String serviceType) {
            NsdManager.checkProtocol(protocolType);
            this.mProtocolType = protocolType;
            this.setServiceType(serviceType);
        }

        @NonNull
        public Builder setServiceType(@NonNull String serviceType) {
            if (TextUtils.isEmpty(serviceType)) {
                throw new IllegalArgumentException("Service type cannot be empty");
            }
            this.mServiceType = serviceType;
            return this;
        }

        @NonNull
        public Builder setSubtype(@Nullable String subtype) {
            this.mSubtype = subtype;
            return this;
        }

        @NonNull
        public Builder setNetwork(@Nullable Network network) {
            this.mNetwork = network;
            return this;
        }

        @NonNull
        public DiscoveryRequest build() {
            return new DiscoveryRequest(this.mProtocolType, this.mServiceType, this.mSubtype, this.mNetwork);
        }
    }
}

