/*
 * Decompiled with CFR 0.152.
 */
package android.net.thread;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.IpPrefix;
import android.net.connectivity.com.android.internal.util.Preconditions;
import android.net.connectivity.com.android.net.module.util.HexDump;
import android.net.thread.OperationalDatasetTimestamp;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="com.android.net.thread.flags.thread_enabled")
public class ActiveOperationalDataset
implements Parcelable {
    public static final int LENGTH_MAX_DATASET_TLVS = 254;
    public static final int LENGTH_EXTENDED_PAN_ID = 8;
    public static final int LENGTH_MIN_NETWORK_NAME_BYTES = 1;
    public static final int LENGTH_MAX_NETWORK_NAME_BYTES = 16;
    public static final int LENGTH_NETWORK_KEY = 16;
    public static final int LENGTH_MESH_LOCAL_PREFIX_BITS = 64;
    public static final int LENGTH_PSKC = 16;
    public static final int CHANNEL_PAGE_24_GHZ = 0;
    public static final int CHANNEL_MIN_24_GHZ = 11;
    public static final int CHANNEL_MAX_24_GHZ = 26;
    @VisibleForTesting
    public static final int TYPE_CHANNEL = 0;
    @VisibleForTesting
    public static final int TYPE_PAN_ID = 1;
    @VisibleForTesting
    public static final int TYPE_EXTENDED_PAN_ID = 2;
    @VisibleForTesting
    public static final int TYPE_NETWORK_NAME = 3;
    @VisibleForTesting
    public static final int TYPE_PSKC = 4;
    @VisibleForTesting
    public static final int TYPE_NETWORK_KEY = 5;
    @VisibleForTesting
    public static final int TYPE_MESH_LOCAL_PREFIX = 7;
    @VisibleForTesting
    public static final int TYPE_SECURITY_POLICY = 12;
    @VisibleForTesting
    public static final int TYPE_ACTIVE_TIMESTAMP = 14;
    @VisibleForTesting
    public static final int TYPE_CHANNEL_MASK = 53;
    public static final byte MESH_LOCAL_PREFIX_FIRST_BYTE = -3;
    private static final int LENGTH_CHANNEL = 3;
    private static final int LENGTH_PAN_ID = 2;
    @NonNull
    public static final Parcelable.Creator<ActiveOperationalDataset> CREATOR = new Parcelable.Creator<ActiveOperationalDataset>(){

        @Override
        public ActiveOperationalDataset createFromParcel(Parcel in) {
            return ActiveOperationalDataset.fromThreadTlvs(in.createByteArray());
        }

        public ActiveOperationalDataset[] newArray(int size) {
            return new ActiveOperationalDataset[size];
        }
    };
    private final OperationalDatasetTimestamp mActiveTimestamp;
    private final String mNetworkName;
    private final byte[] mExtendedPanId;
    private final int mPanId;
    private final int mChannel;
    private final int mChannelPage;
    private final SparseArray<byte[]> mChannelMask;
    private final byte[] mPskc;
    private final byte[] mNetworkKey;
    private final IpPrefix mMeshLocalPrefix;
    private final SecurityPolicy mSecurityPolicy;
    private final SparseArray<byte[]> mUnknownTlvs;

    private ActiveOperationalDataset(Builder builder) {
        this(Objects.requireNonNull(builder.mActiveTimestamp), Objects.requireNonNull(builder.mNetworkName), Objects.requireNonNull(builder.mExtendedPanId), Objects.requireNonNull(builder.mPanId), Objects.requireNonNull(builder.mChannelPage), Objects.requireNonNull(builder.mChannel), Objects.requireNonNull(builder.mChannelMask), Objects.requireNonNull(builder.mPskc), Objects.requireNonNull(builder.mNetworkKey), Objects.requireNonNull(builder.mMeshLocalPrefix), Objects.requireNonNull(builder.mSecurityPolicy), Objects.requireNonNull(builder.mUnknownTlvs));
    }

    private ActiveOperationalDataset(OperationalDatasetTimestamp activeTimestamp, String networkName, byte[] extendedPanId, int panId, int channelPage, int channel, SparseArray<byte[]> channelMask, byte[] pskc, byte[] networkKey, IpPrefix meshLocalPrefix, SecurityPolicy securityPolicy, SparseArray<byte[]> unknownTlvs) {
        this.mActiveTimestamp = activeTimestamp;
        this.mNetworkName = networkName;
        this.mExtendedPanId = (byte[])extendedPanId.clone();
        this.mPanId = panId;
        this.mChannel = channel;
        this.mChannelPage = channelPage;
        this.mChannelMask = ActiveOperationalDataset.deepCloneSparseArray(channelMask);
        this.mPskc = (byte[])pskc.clone();
        this.mNetworkKey = (byte[])networkKey.clone();
        this.mMeshLocalPrefix = meshLocalPrefix;
        this.mSecurityPolicy = securityPolicy;
        this.mUnknownTlvs = ActiveOperationalDataset.deepCloneSparseArray(unknownTlvs);
    }

    @NonNull
    public static ActiveOperationalDataset fromThreadTlvs(@NonNull byte[] tlvs) {
        int length;
        Objects.requireNonNull(tlvs, "tlvs cannot be null");
        if (tlvs.length > 254) {
            throw new IllegalArgumentException(String.format("tlvs length exceeds max length %d (actual is %d)", 254, tlvs.length));
        }
        Builder builder = new Builder();
        for (int i = 0; i < tlvs.length; i += length) {
            int type = tlvs[i++] & 0xFF;
            if (i >= tlvs.length) {
                throw new IllegalArgumentException(String.format("Found TLV type %d at end of operational dataset with length %d", type, tlvs.length));
            }
            if (i + (length = tlvs[i++] & 0xFF) > tlvs.length) {
                throw new IllegalArgumentException(String.format("Found TLV type %d with length %d which exceeds the remaining data in the operational dataset with length %d", type, length, tlvs.length));
            }
            ActiveOperationalDataset.initWithTlv(builder, type, Arrays.copyOfRange(tlvs, i, i + length));
        }
        try {
            return builder.build();
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException("Failed to build the ActiveOperationalDataset object", e);
        }
    }

    private static void initWithTlv(Builder builder, int type, byte[] value) {
        if (value.length > 252) {
            throw new IllegalArgumentException(String.format("Length of TLV %d exceeds %d (actualLength = %d)", type & 0xFF, 252, value.length));
        }
        switch (type) {
            case 0: {
                Preconditions.checkArgument(value.length == 3, "Invalid channel (length = %d, expectedLength = %d)", value.length, 3);
                builder.setChannel(value[0] & 0xFF, (value[1] & 0xFF) << 8 | value[2] & 0xFF);
                break;
            }
            case 1: {
                Preconditions.checkArgument(value.length == 2, "Invalid PAN ID (length = %d, expectedLength = %d)", value.length, 2);
                builder.setPanId((value[0] & 0xFF) << 8 | value[1] & 0xFF);
                break;
            }
            case 2: {
                builder.setExtendedPanId(value);
                break;
            }
            case 3: {
                builder.setNetworkName(new String(value, StandardCharsets.UTF_8));
                break;
            }
            case 4: {
                builder.setPskc(value);
                break;
            }
            case 5: {
                builder.setNetworkKey(value);
                break;
            }
            case 7: {
                builder.setMeshLocalPrefix(value);
                break;
            }
            case 12: {
                builder.setSecurityPolicy(SecurityPolicy.fromTlvValue(value));
                break;
            }
            case 14: {
                builder.setActiveTimestamp(OperationalDatasetTimestamp.fromTlvValue(value));
                break;
            }
            case 53: {
                builder.setChannelMask(ActiveOperationalDataset.decodeChannelMask(value));
                break;
            }
            default: {
                builder.addUnknownTlv(type & 0xFF, value);
            }
        }
    }

    private static SparseArray<byte[]> decodeChannelMask(byte[] tlvValue) {
        int maskLength;
        SparseArray<byte[]> channelMask = new SparseArray<byte[]>();
        for (int i = 0; i < tlvValue.length; i += maskLength) {
            int channelPage = tlvValue[i++] & 0xFF;
            if (i >= tlvValue.length) {
                throw new IllegalArgumentException("Invalid channel mask - channel mask length is missing");
            }
            if (i + (maskLength = tlvValue[i++] & 0xFF) > tlvValue.length) {
                throw new IllegalArgumentException(String.format("Invalid channel mask - channel mask is incomplete (offset = %d, length = %d, totalLength = %d)", i, maskLength, tlvValue.length));
            }
            channelMask.put(channelPage, Arrays.copyOfRange(tlvValue, i, i + maskLength));
        }
        return channelMask;
    }

    private static void encodeChannelMask(SparseArray<byte[]> channelMask, ByteArrayOutputStream outputStream) {
        ByteArrayOutputStream entryStream = new ByteArrayOutputStream();
        for (int i = 0; i < channelMask.size(); ++i) {
            int key = channelMask.keyAt(i);
            byte[] value = channelMask.get(key);
            entryStream.write(key);
            entryStream.write(value.length);
            entryStream.write(value, 0, value.length);
        }
        byte[] entries = entryStream.toByteArray();
        outputStream.write(53);
        outputStream.write(entries.length);
        outputStream.write(entries, 0, entries.length);
    }

    private static boolean areByteSparseArraysEqual(@NonNull SparseArray<byte[]> first, @NonNull SparseArray<byte[]> second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.size() != second.size()) {
            return false;
        }
        for (int i = 0; i < first.size(); ++i) {
            byte[] secondValue;
            int secondKey;
            int firstKey = first.keyAt(i);
            if (firstKey != (secondKey = second.keyAt(i))) {
                return false;
            }
            byte[] firstValue = first.valueAt(i);
            if (Arrays.equals(firstValue, secondValue = second.valueAt(i))) continue;
            return false;
        }
        return true;
    }

    private static int deepHashCode(Object ... values) {
        return Arrays.deepHashCode(values);
    }

    @NonNull
    public byte[] toThreadTlvs() {
        ByteArrayOutputStream dataset = new ByteArrayOutputStream();
        dataset.write(14);
        byte[] activeTimestampBytes = this.mActiveTimestamp.toTlvValue();
        dataset.write(activeTimestampBytes.length);
        dataset.write(activeTimestampBytes, 0, activeTimestampBytes.length);
        dataset.write(3);
        byte[] networkNameBytes = this.mNetworkName.getBytes(StandardCharsets.UTF_8);
        dataset.write(networkNameBytes.length);
        dataset.write(networkNameBytes, 0, networkNameBytes.length);
        dataset.write(2);
        dataset.write(this.mExtendedPanId.length);
        dataset.write(this.mExtendedPanId, 0, this.mExtendedPanId.length);
        dataset.write(1);
        dataset.write(2);
        dataset.write(this.mPanId >> 8);
        dataset.write(this.mPanId);
        dataset.write(0);
        dataset.write(3);
        dataset.write(this.mChannelPage);
        dataset.write(this.mChannel >> 8);
        dataset.write(this.mChannel);
        ActiveOperationalDataset.encodeChannelMask(this.mChannelMask, dataset);
        dataset.write(4);
        dataset.write(this.mPskc.length);
        dataset.write(this.mPskc, 0, this.mPskc.length);
        dataset.write(5);
        dataset.write(this.mNetworkKey.length);
        dataset.write(this.mNetworkKey, 0, this.mNetworkKey.length);
        dataset.write(7);
        dataset.write(this.mMeshLocalPrefix.getPrefixLength() / 8);
        dataset.write(this.mMeshLocalPrefix.getRawAddress(), 0, this.mMeshLocalPrefix.getPrefixLength() / 8);
        dataset.write(12);
        byte[] securityPolicyBytes = this.mSecurityPolicy.toTlvValue();
        dataset.write(securityPolicyBytes.length);
        dataset.write(securityPolicyBytes, 0, securityPolicyBytes.length);
        for (int i = 0; i < this.mUnknownTlvs.size(); ++i) {
            byte[] value = this.mUnknownTlvs.valueAt(i);
            dataset.write(this.mUnknownTlvs.keyAt(i));
            dataset.write(value.length);
            dataset.write(value, 0, value.length);
        }
        return dataset.toByteArray();
    }

    @NonNull
    public OperationalDatasetTimestamp getActiveTimestamp() {
        return this.mActiveTimestamp;
    }

    @NonNull
    public String getNetworkName() {
        return this.mNetworkName;
    }

    @NonNull
    public byte[] getExtendedPanId() {
        return (byte[])this.mExtendedPanId.clone();
    }

    public int getPanId() {
        return this.mPanId;
    }

    public int getChannel() {
        return this.mChannel;
    }

    public int getChannelPage() {
        return this.mChannelPage;
    }

    @NonNull
    public SparseArray<byte[]> getChannelMask() {
        return ActiveOperationalDataset.deepCloneSparseArray(this.mChannelMask);
    }

    private static SparseArray<byte[]> deepCloneSparseArray(SparseArray<byte[]> src) {
        SparseArray<byte[]> dst = new SparseArray<byte[]>(src.size());
        for (int i = 0; i < src.size(); ++i) {
            dst.put(src.keyAt(i), (byte[])src.valueAt(i).clone());
        }
        return dst;
    }

    @NonNull
    public byte[] getPskc() {
        return (byte[])this.mPskc.clone();
    }

    @NonNull
    public byte[] getNetworkKey() {
        return (byte[])this.mNetworkKey.clone();
    }

    @NonNull
    public IpPrefix getMeshLocalPrefix() {
        return this.mMeshLocalPrefix;
    }

    @NonNull
    public SecurityPolicy getSecurityPolicy() {
        return this.mSecurityPolicy;
    }

    @NonNull
    public SparseArray<byte[]> getUnknownTlvs() {
        return ActiveOperationalDataset.deepCloneSparseArray(this.mUnknownTlvs);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeByteArray(this.toThreadTlvs());
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ActiveOperationalDataset)) {
            return false;
        }
        ActiveOperationalDataset otherDataset = (ActiveOperationalDataset)other;
        return this.mActiveTimestamp.equals(otherDataset.mActiveTimestamp) && this.mNetworkName.equals(otherDataset.mNetworkName) && Arrays.equals(this.mExtendedPanId, otherDataset.mExtendedPanId) && this.mPanId == otherDataset.mPanId && this.mChannelPage == otherDataset.mChannelPage && this.mChannel == otherDataset.mChannel && ActiveOperationalDataset.areByteSparseArraysEqual(this.mChannelMask, otherDataset.mChannelMask) && Arrays.equals(this.mPskc, otherDataset.mPskc) && Arrays.equals(this.mNetworkKey, otherDataset.mNetworkKey) && this.mMeshLocalPrefix.equals(otherDataset.mMeshLocalPrefix) && this.mSecurityPolicy.equals(otherDataset.mSecurityPolicy) && ActiveOperationalDataset.areByteSparseArraysEqual(this.mUnknownTlvs, otherDataset.mUnknownTlvs);
    }

    public int hashCode() {
        return ActiveOperationalDataset.deepHashCode(this.mActiveTimestamp, this.mNetworkName, this.mExtendedPanId, this.mPanId, this.mChannel, this.mChannelPage, this.mChannelMask, this.mPskc, this.mNetworkKey, this.mMeshLocalPrefix, this.mSecurityPolicy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{networkName=").append(this.getNetworkName()).append(", extendedPanId=").append(HexDump.toHexString(this.getExtendedPanId())).append(", panId=").append(this.getPanId()).append(", channel=").append(this.getChannel()).append(", activeTimestamp=").append(this.getActiveTimestamp()).append("}");
        return sb.toString();
    }

    static String checkNetworkName(@NonNull String networkName) {
        Objects.requireNonNull(networkName, "networkName cannot be null");
        int nameLength = networkName.getBytes(StandardCharsets.UTF_8).length;
        Preconditions.checkArgument(nameLength >= 1 && nameLength <= 16, "Invalid network name (length = %d, expectedLengthRange = [%d, %d])", nameLength, 1, 16);
        return networkName;
    }

    public static class Builder {
        private OperationalDatasetTimestamp mActiveTimestamp;
        private String mNetworkName;
        private byte[] mExtendedPanId;
        private Integer mPanId;
        private Integer mChannel;
        private Integer mChannelPage;
        private SparseArray<byte[]> mChannelMask;
        private byte[] mPskc;
        private byte[] mNetworkKey;
        private IpPrefix mMeshLocalPrefix;
        private SecurityPolicy mSecurityPolicy;
        private SparseArray<byte[]> mUnknownTlvs;

        public Builder(@NonNull ActiveOperationalDataset activeOpDataset) {
            Objects.requireNonNull(activeOpDataset, "activeOpDataset cannot be null");
            this.mActiveTimestamp = activeOpDataset.mActiveTimestamp;
            this.mNetworkName = activeOpDataset.mNetworkName;
            this.mExtendedPanId = (byte[])activeOpDataset.mExtendedPanId.clone();
            this.mPanId = activeOpDataset.mPanId;
            this.mChannel = activeOpDataset.mChannel;
            this.mChannelPage = activeOpDataset.mChannelPage;
            this.mChannelMask = ActiveOperationalDataset.deepCloneSparseArray(activeOpDataset.mChannelMask);
            this.mPskc = (byte[])activeOpDataset.mPskc.clone();
            this.mNetworkKey = (byte[])activeOpDataset.mNetworkKey.clone();
            this.mMeshLocalPrefix = activeOpDataset.mMeshLocalPrefix;
            this.mSecurityPolicy = activeOpDataset.mSecurityPolicy;
            this.mUnknownTlvs = ActiveOperationalDataset.deepCloneSparseArray(activeOpDataset.mUnknownTlvs);
        }

        public Builder() {
            this.mChannelMask = new SparseArray();
            this.mUnknownTlvs = new SparseArray();
        }

        @NonNull
        public Builder setActiveTimestamp(@NonNull OperationalDatasetTimestamp activeTimestamp) {
            Objects.requireNonNull(activeTimestamp, "activeTimestamp cannot be null");
            this.mActiveTimestamp = activeTimestamp;
            return this;
        }

        @NonNull
        public Builder setNetworkName(@NonNull String networkName) {
            this.mNetworkName = ActiveOperationalDataset.checkNetworkName(networkName);
            return this;
        }

        @NonNull
        public Builder setExtendedPanId(@NonNull byte[] extendedPanId) {
            Objects.requireNonNull(extendedPanId, "extendedPanId cannot be null");
            Preconditions.checkArgument(extendedPanId.length == 8, "Invalid extended PAN ID (length = %d, expectedLength = %d)", extendedPanId.length, 8);
            this.mExtendedPanId = (byte[])extendedPanId.clone();
            return this;
        }

        @NonNull
        public Builder setPanId(int panId) {
            Preconditions.checkArgument(panId >= 0 && panId <= 65534, "PAN ID exceeds allowed range (panid = %d, allowedRange = [0x0, 0xffff])", panId);
            this.mPanId = panId;
            return this;
        }

        @NonNull
        public Builder setChannel(int page, int channel) {
            Preconditions.checkArgument(page >= 0 && page <= 255, "Invalid channel page (page = %d, allowedRange = [0, 255])", page);
            if (page == 0) {
                Preconditions.checkArgument(channel >= 11 && channel <= 26, "Invalid channel %d in page %d (allowedChannelRange = [%d, %d])", channel, page, 11, 26);
            } else {
                Preconditions.checkArgument(channel >= 0 && channel <= 65535, "Invalid channel %d in page %d (channel = %d, allowedChannelRange = [0, 65535])", channel, page, channel);
            }
            this.mChannelPage = page;
            this.mChannel = channel;
            return this;
        }

        @NonNull
        public Builder setChannelMask(@NonNull SparseArray<byte[]> channelMask) {
            Objects.requireNonNull(channelMask, "channelMask cannot be null");
            Preconditions.checkArgument(channelMask.size() > 0, "channelMask is empty");
            this.mChannelMask = ActiveOperationalDataset.deepCloneSparseArray(channelMask);
            return this;
        }

        @NonNull
        public Builder setPskc(@NonNull byte[] pskc) {
            Objects.requireNonNull(pskc, "pskc cannot be null");
            Preconditions.checkArgument(pskc.length == 16, "Invalid PSKc length (length = %d, expectedLength = %d)", pskc.length, 16);
            this.mPskc = (byte[])pskc.clone();
            return this;
        }

        @NonNull
        public Builder setNetworkKey(@NonNull byte[] networkKey) {
            Objects.requireNonNull(networkKey, "networkKey cannot be null");
            Preconditions.checkArgument(networkKey.length == 16, "Invalid network key length (length = %d, expectedLength = %d)", networkKey.length, 16);
            this.mNetworkKey = (byte[])networkKey.clone();
            return this;
        }

        @NonNull
        public Builder setMeshLocalPrefix(@NonNull IpPrefix meshLocalPrefix) {
            Objects.requireNonNull(meshLocalPrefix, "meshLocalPrefix cannot be null");
            Preconditions.checkArgument(meshLocalPrefix.getPrefixLength() == 64, "Invalid mesh-local prefix length (length = %d, expectedLength = %d)", meshLocalPrefix.getPrefixLength(), 64);
            Preconditions.checkArgument(meshLocalPrefix.getRawAddress()[0] == -3, "Mesh-local prefix must start with 0xfd: " + meshLocalPrefix);
            this.mMeshLocalPrefix = meshLocalPrefix;
            return this;
        }

        @NonNull
        public Builder setMeshLocalPrefix(byte[] meshLocalPrefix) {
            int prefixLength = meshLocalPrefix.length * 8;
            Preconditions.checkArgument(prefixLength == 64, "Invalid mesh-local prefix length (length = %d, expectedLength = %d)", prefixLength, 64);
            byte[] ip6RawAddress = new byte[16];
            System.arraycopy(meshLocalPrefix, 0, ip6RawAddress, 0, meshLocalPrefix.length);
            try {
                return this.setMeshLocalPrefix(new IpPrefix(Inet6Address.getByAddress(ip6RawAddress), prefixLength));
            }
            catch (UnknownHostException e) {
                throw new AssertionError((Object)e);
            }
        }

        @NonNull
        public Builder setSecurityPolicy(@NonNull SecurityPolicy securityPolicy) {
            Objects.requireNonNull(securityPolicy, "securityPolicy cannot be null");
            this.mSecurityPolicy = securityPolicy;
            return this;
        }

        @NonNull
        public Builder setUnknownTlvs(@NonNull SparseArray<byte[]> unknownTlvs) {
            Objects.requireNonNull(unknownTlvs, "unknownTlvs cannot be null");
            this.mUnknownTlvs = ActiveOperationalDataset.deepCloneSparseArray(unknownTlvs);
            return this;
        }

        @VisibleForTesting
        @NonNull
        public Builder addUnknownTlv(int type, byte[] value) {
            this.mUnknownTlvs.put(type, value);
            return this;
        }

        @NonNull
        public ActiveOperationalDataset build() {
            Preconditions.checkState(this.mActiveTimestamp != null, "Active Timestamp is missing");
            Preconditions.checkState(this.mNetworkName != null, "Network Name is missing");
            Preconditions.checkState(this.mExtendedPanId != null, "Extended PAN ID is missing");
            Preconditions.checkState(this.mPanId != null, "PAN ID is missing");
            Preconditions.checkState(this.mChannel != null, "Channel is missing");
            Preconditions.checkState(this.mChannelPage != null, "Channel Page is missing");
            Preconditions.checkState(this.mChannelMask.size() != 0, "Channel Mask is missing");
            Preconditions.checkState(this.mPskc != null, "PSKc is missing");
            Preconditions.checkState(this.mNetworkKey != null, "Network Key is missing");
            Preconditions.checkState(this.mMeshLocalPrefix != null, "Mesh Local Prefix is missing");
            Preconditions.checkState(this.mSecurityPolicy != null, "Security Policy is missing");
            int length = this.getTotalDatasetLength();
            if (length > 254) {
                throw new IllegalStateException(String.format("Total dataset length exceeds max length %d (actual is %d)", 254, length));
            }
            return new ActiveOperationalDataset(this);
        }

        private int getTotalDatasetLength() {
            int i;
            int length = 26 + this.mNetworkName.getBytes(StandardCharsets.UTF_8).length + 8 + 2 + 3 + 16 + 16 + 8 + this.mSecurityPolicy.toTlvValue().length;
            for (i = 0; i < this.mChannelMask.size(); ++i) {
                length += 2 + this.mChannelMask.valueAt(i).length;
            }
            length += 2;
            for (i = 0; i < this.mUnknownTlvs.size(); ++i) {
                length += 2 + this.mUnknownTlvs.valueAt(i).length;
            }
            return length;
        }
    }

    public static class SecurityPolicy {
        public static final int DEFAULT_ROTATION_TIME_HOURS = 672;
        public static final int LENGTH_MIN_SECURITY_POLICY_FLAGS = 1;
        private static final int LENGTH_SECURITY_POLICY_ROTATION_TIME = 2;
        private final int mRotationTimeHours;
        private final byte[] mFlags;

        public SecurityPolicy(int rotationTimeHours, @NonNull byte[] flags) {
            Objects.requireNonNull(flags, "flags cannot be null");
            Preconditions.checkArgument(rotationTimeHours >= 1 && rotationTimeHours <= 65535, "Rotation time exceeds allowed range (rotationTimeHours = %d, allowedRange = [0x1, 0xffff])", rotationTimeHours);
            Preconditions.checkArgument(flags.length >= 1, "Invalid security policy flags length (length = %d, minimumLength = %d)", flags.length, 1);
            this.mRotationTimeHours = rotationTimeHours;
            this.mFlags = (byte[])flags.clone();
        }

        @VisibleForTesting
        @NonNull
        public static SecurityPolicy fromTlvValue(byte[] encodedSecurityPolicy) {
            Preconditions.checkArgument(encodedSecurityPolicy.length >= 3, "Invalid Security Policy TLV length (length = %d, minimumLength = %d)", encodedSecurityPolicy.length, 3);
            return new SecurityPolicy((encodedSecurityPolicy[0] & 0xFF) << 8 | encodedSecurityPolicy[1] & 0xFF, Arrays.copyOfRange(encodedSecurityPolicy, 2, encodedSecurityPolicy.length));
        }

        @VisibleForTesting
        @NonNull
        public byte[] toTlvValue() {
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            result.write(this.mRotationTimeHours >> 8);
            result.write(this.mRotationTimeHours);
            result.write(this.mFlags, 0, this.mFlags.length);
            return result.toByteArray();
        }

        public int getRotationTimeHours() {
            return this.mRotationTimeHours;
        }

        @NonNull
        public byte[] getFlags() {
            return (byte[])this.mFlags.clone();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SecurityPolicy)) {
                return false;
            }
            SecurityPolicy otherSecurityPolicy = (SecurityPolicy)other;
            return this.mRotationTimeHours == otherSecurityPolicy.mRotationTimeHours && Arrays.equals(this.mFlags, otherSecurityPolicy.mFlags);
        }

        public int hashCode() {
            return ActiveOperationalDataset.deepHashCode(this.mRotationTimeHours, this.mFlags);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{rotation=").append(this.mRotationTimeHours).append(", flags=").append(HexDump.toHexString(this.mFlags)).append("}");
            return sb.toString();
        }
    }
}

