/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.FlaggedApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.util.Objects;

@FlaggedApi(value="com.android.wifi.flags.bssid_blocklist_for_suggestion")
public class BlockingOption
implements Parcelable {
    private final int mDisableTime;
    private final boolean mBSSIDOnly;
    @NonNull
    public static final Parcelable.Creator<BlockingOption> CREATOR = new Parcelable.Creator<BlockingOption>(){

        @Override
        public BlockingOption createFromParcel(Parcel in) {
            return new BlockingOption(in);
        }

        public BlockingOption[] newArray(int size) {
            return new BlockingOption[size];
        }
    };

    public BlockingOption(int disableTime, boolean bssidOnly) {
        this.mDisableTime = disableTime;
        this.mBSSIDOnly = bssidOnly;
    }

    public BlockingOption(Parcel in) {
        this.mDisableTime = in.readInt();
        this.mBSSIDOnly = in.readBoolean();
    }

    public int getBlockingTimeSeconds() {
        return this.mDisableTime;
    }

    public boolean isBlockingBssidOnly() {
        return this.mBSSIDOnly;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mDisableTime);
        dest.writeBoolean(this.mBSSIDOnly);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BlockingOption)) {
            return false;
        }
        BlockingOption lhs = (BlockingOption)obj;
        return this.mBSSIDOnly == lhs.mBSSIDOnly && this.mDisableTime == lhs.mDisableTime;
    }

    public int hashCode() {
        return Objects.hash(this.mBSSIDOnly, this.mDisableTime);
    }

    public String toString() {
        return "BlockingOption[ DisableTime=" + this.mDisableTime + ", BSSIDOnly=" + this.mBSSIDOnly;
    }

    @FlaggedApi(value="com.android.wifi.flags.bssid_blocklist_for_suggestion")
    public static class Builder {
        private int mDisableTime;
        private boolean mBSSIDOnly;

        public Builder(int blockingTimeSec) {
            if (blockingTimeSec < 1 || blockingTimeSec > 86400) {
                throw new IllegalArgumentException("blockingTimeSec should between 1 to 86400");
            }
            this.mDisableTime = blockingTimeSec;
            this.mBSSIDOnly = false;
        }

        @NonNull
        public Builder setBlockingBssidOnly(boolean bssidOnly) {
            this.mBSSIDOnly = bssidOnly;
            return this;
        }

        @NonNull
        public BlockingOption build() {
            return new BlockingOption(this.mDisableTime, this.mBSSIDOnly);
        }
    }
}

