/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ITwtCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.ITwtCallback";

    public void onFailure(int var1) throws RemoteException;

    public void onTeardown(int var1) throws RemoteException;

    public void onCreate(int var1, long var2, int var4, int var5, int var6) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITwtCallback {
        static final int TRANSACTION_onFailure = 1;
        static final int TRANSACTION_onTeardown = 2;
        static final int TRANSACTION_onCreate = 3;

        public Stub() {
            this.attachInterface(this, ITwtCallback.DESCRIPTOR);
        }

        public static ITwtCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITwtCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ITwtCallback) {
                return (ITwtCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onFailure";
                }
                case 2: {
                    return "onTeardown";
                }
                case 3: {
                    return "onCreate";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITwtCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    this.onFailure(_arg0);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    this.onTeardown(_arg0);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    this.onCreate(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements ITwtCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITwtCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(int errorCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITwtCallback.DESCRIPTOR);
                    _data.writeInt(errorCode);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTeardown(int reasonCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITwtCallback.DESCRIPTOR);
                    _data.writeInt(reasonCode);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCreate(int wakeDuration, long wakeInterval, int mloLinkId, int owner, int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITwtCallback.DESCRIPTOR);
                    _data.writeInt(wakeDuration);
                    _data.writeLong(wakeInterval);
                    _data.writeInt(mloLinkId);
                    _data.writeInt(owner);
                    _data.writeInt(sessionId);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITwtCallback {
        @Override
        public void onFailure(int errorCode) throws RemoteException {
        }

        @Override
        public void onTeardown(int reasonCode) throws RemoteException {
        }

        @Override
        public void onCreate(int wakeDuration, long wakeInterval, int mloLinkId, int owner, int sessionId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

