/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IWifiNetworkStateChangedListener
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.IWifiNetworkStateChangedListener";

    public void onWifiNetworkStateChanged(int var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWifiNetworkStateChangedListener {
        static final int TRANSACTION_onWifiNetworkStateChanged = 1;

        public Stub() {
            this.attachInterface(this, IWifiNetworkStateChangedListener.DESCRIPTOR);
        }

        public static IWifiNetworkStateChangedListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IWifiNetworkStateChangedListener.DESCRIPTOR);
            if (iin != null && iin instanceof IWifiNetworkStateChangedListener) {
                return (IWifiNetworkStateChangedListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onWifiNetworkStateChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IWifiNetworkStateChangedListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.onWifiNetworkStateChanged(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IWifiNetworkStateChangedListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IWifiNetworkStateChangedListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onWifiNetworkStateChanged(int clientRole, int status) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiNetworkStateChangedListener.DESCRIPTOR);
                    _data.writeInt(clientRole);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWifiNetworkStateChangedListener {
        @Override
        public void onWifiNetworkStateChanged(int clientRole, int status) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

