/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.wifi.WifiManager;
import android.net.wifi.twt.TwtSession;
import android.os.Binder;
import android.os.Bundle;
import android.util.CloseGuard;
import android.util.Log;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class WifiTwtSession
implements TwtSession {
    private static final String TAG = "WifiTwtSession";
    public static final int MAX_TWT_SESSIONS = 8;
    private final int mWakeDurationMicros;
    private final long mWakeIntervalMicros;
    private final int mMloLinkId;
    private final int mOwner;
    private final int mSessionId;
    private final WeakReference<WifiManager> mMgr;
    private final CloseGuard mCloseGuard = new CloseGuard();

    @Override
    public int getWakeDurationMicros() {
        return this.mWakeDurationMicros;
    }

    @Override
    public long getWakeIntervalMicros() {
        return this.mWakeIntervalMicros;
    }

    @Override
    public int getMloLinkId() {
        return this.mMloLinkId;
    }

    public int getOwner() {
        return this.mOwner;
    }

    public int getSessionId() {
        return this.mSessionId;
    }

    @Override
    public void getStats(Executor executor, Consumer<Bundle> resultCallback) {
        WifiManager mgr = (WifiManager)this.mMgr.get();
        if (mgr == null) {
            Log.e(TAG, "getStats: called post garbage collection");
            return;
        }
        if (Binder.getCallingUid() != this.mOwner) {
            throw new SecurityException("TWT session is not owned by the caller");
        }
        mgr.getStatsTwtSession(this.mSessionId, executor, resultCallback);
    }

    public WifiTwtSession(WifiManager wifiManager, int wakeDurationMicros, long wakeIntervalMicros, int mloLinkId, int owner, int sessionId) {
        this.mMgr = new WeakReference<WifiManager>(wifiManager);
        this.mWakeDurationMicros = wakeDurationMicros;
        this.mWakeIntervalMicros = wakeIntervalMicros;
        this.mMloLinkId = mloLinkId;
        this.mOwner = owner;
        this.mSessionId = sessionId;
        this.mCloseGuard.open("teardown");
    }

    @Override
    public void teardown() {
        try {
            WifiManager mgr = (WifiManager)this.mMgr.get();
            if (mgr == null) {
                Log.w(TAG, "close: called post garbage collection");
                return;
            }
            mgr.teardownTwtSession(this.mSessionId);
            this.mMgr.clear();
            this.mCloseGuard.close();
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }
}

