/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class Characteristics
implements Parcelable {
    public static final String KEY_MAX_SERVICE_NAME_LENGTH = "key_max_service_name_length";
    public static final String KEY_MAX_SERVICE_SPECIFIC_INFO_LENGTH = "key_max_service_specific_info_length";
    public static final String KEY_MAX_MATCH_FILTER_LENGTH = "key_max_match_filter_length";
    public static final String KEY_SUPPORTED_DATA_PATH_CIPHER_SUITES = "key_supported_data_path_cipher_suites";
    public static final String KEY_SUPPORTED_PAIRING_CIPHER_SUITES = "key_supported_pairing_cipher_suites";
    public static final String KEY_IS_INSTANT_COMMUNICATION_MODE_SUPPORTED = "key_is_instant_communication_mode_supported";
    public static final String KEY_MAX_NDP_NUMBER = "key_max_ndp_number";
    public static final String KEY_MAX_PUBLISH_NUMBER = "key_max_publish_number";
    public static final String KEY_MAX_SUBSCRIBE_NUMBER = "key_max_subscribe_number";
    public static final String KEY_MAX_NDI_NUMBER = "key_max_ndi_number";
    public static final String KEY_SUPPORT_NAN_PAIRING = "key_support_nan_pairing";
    public static final String KEY_SUPPORT_SUSPENSION = "key_support_suspension";
    @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
    public static final String KEY_SUPPORT_PERIODIC_RANGING = "key_support_periodic_ranging";
    @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
    public static final String KEY_MAX_SUPPORTED_RANGING_PKT_BANDWIDTH = "key_max_supported_ranging_pkt_bandwidth";
    @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
    public static final String KEY_MAX_SUPPORTED_RX_CHAINS = "key_max_supported_rx_chains";
    private final Bundle mCharacteristics;
    @SystemApi
    @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
    public static final int SUPPORTED_RX_CHAINS_1 = 1;
    @SystemApi
    @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
    public static final int SUPPORTED_RX_CHAINS_2 = 2;
    @SystemApi
    @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
    public static final int SUPPORTED_RX_CHAINS_3 = 3;
    @SystemApi
    @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
    public static final int SUPPORTED_RX_CHAINS_4 = 4;
    @SystemApi
    @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
    public static final int SUPPORTED_RX_CHAINS_UNSPECIFIED = 0;
    public static final int WIFI_AWARE_CIPHER_SUITE_NONE = 0;
    public static final int WIFI_AWARE_CIPHER_SUITE_NCS_SK_128 = 1;
    public static final int WIFI_AWARE_CIPHER_SUITE_NCS_SK_256 = 2;
    public static final int WIFI_AWARE_CIPHER_SUITE_NCS_PK_128 = 4;
    public static final int WIFI_AWARE_CIPHER_SUITE_NCS_PK_256 = 8;
    public static final int WIFI_AWARE_CIPHER_SUITE_NCS_PK_PASN_128 = 16;
    public static final int WIFI_AWARE_CIPHER_SUITE_NCS_PK_PASN_256 = 32;
    @NonNull
    public static final Parcelable.Creator<Characteristics> CREATOR = new Parcelable.Creator<Characteristics>(){

        @Override
        public Characteristics createFromParcel(Parcel in) {
            Characteristics c = new Characteristics(in.readBundle());
            return c;
        }

        public Characteristics[] newArray(int size) {
            return new Characteristics[size];
        }
    };

    public Characteristics(Bundle characteristics) {
        this.mCharacteristics = characteristics;
    }

    public int getMaxServiceNameLength() {
        return this.mCharacteristics.getInt(KEY_MAX_SERVICE_NAME_LENGTH);
    }

    public int getMaxServiceSpecificInfoLength() {
        return this.mCharacteristics.getInt(KEY_MAX_SERVICE_SPECIFIC_INFO_LENGTH);
    }

    public int getMaxMatchFilterLength() {
        return this.mCharacteristics.getInt(KEY_MAX_MATCH_FILTER_LENGTH);
    }

    public int getNumberOfSupportedDataInterfaces() {
        return this.mCharacteristics.getInt(KEY_MAX_NDI_NUMBER);
    }

    public int getNumberOfSupportedPublishSessions() {
        return this.mCharacteristics.getInt(KEY_MAX_PUBLISH_NUMBER);
    }

    public int getNumberOfSupportedSubscribeSessions() {
        return this.mCharacteristics.getInt(KEY_MAX_SUBSCRIBE_NUMBER);
    }

    public int getNumberOfSupportedDataPaths() {
        return this.mCharacteristics.getInt(KEY_MAX_NDP_NUMBER);
    }

    @RequiresApi(value=31)
    public boolean isInstantCommunicationModeSupported() {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        return this.mCharacteristics.getBoolean(KEY_IS_INSTANT_COMMUNICATION_MODE_SUPPORTED);
    }

    public boolean isAwarePairingSupported() {
        return this.mCharacteristics.getBoolean(KEY_SUPPORT_NAN_PAIRING);
    }

    public boolean isSuspensionSupported() {
        return this.mCharacteristics.getBoolean(KEY_SUPPORT_SUSPENSION);
    }

    @SystemApi
    @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
    public boolean isPeriodicRangingSupported() {
        return this.mCharacteristics.getBoolean(KEY_SUPPORT_PERIODIC_RANGING);
    }

    @SystemApi
    @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
    public int getMaxSupportedRxChains() {
        return this.mCharacteristics.getInt(KEY_MAX_SUPPORTED_RX_CHAINS);
    }

    @SystemApi
    @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
    public int getMaxSupportedRangingPacketBandwidth() {
        return this.mCharacteristics.getInt(KEY_MAX_SUPPORTED_RANGING_PKT_BANDWIDTH);
    }

    public int getSupportedCipherSuites() {
        return this.mCharacteristics.getInt(KEY_SUPPORTED_DATA_PATH_CIPHER_SUITES);
    }

    public int getSupportedPairingCipherSuites() {
        return this.mCharacteristics.getInt(KEY_SUPPORTED_PAIRING_CIPHER_SUITES);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeBundle(this.mCharacteristics);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiAwarePairingCipherSuites {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiAwareDataPathCipherSuites {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SupportedRxChains {
    }
}

