/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.nl80211;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.MacAddress;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class NativeWifiClient
implements Parcelable {
    private final MacAddress mMacAddress;
    @NonNull
    public static final Parcelable.Creator<NativeWifiClient> CREATOR = new Parcelable.Creator<NativeWifiClient>(){

        @Override
        public NativeWifiClient createFromParcel(Parcel in) {
            MacAddress macAddress;
            try {
                macAddress = MacAddress.fromBytes(in.createByteArray());
            }
            catch (IllegalArgumentException e) {
                macAddress = null;
            }
            return new NativeWifiClient(macAddress);
        }

        public NativeWifiClient[] newArray(int size) {
            return new NativeWifiClient[size];
        }
    };

    @Nullable
    public MacAddress getMacAddress() {
        return this.mMacAddress;
    }

    public NativeWifiClient(@Nullable MacAddress macAddress) {
        this.mMacAddress = macAddress;
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (!(rhs instanceof NativeWifiClient)) {
            return false;
        }
        NativeWifiClient other = (NativeWifiClient)rhs;
        return Objects.equals(this.mMacAddress, other.mMacAddress);
    }

    public int hashCode() {
        return ((Object)this.mMacAddress).hashCode();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeByteArray(this.mMacAddress.toByteArray());
    }
}

