/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.MacAddress;
import android.net.wifi.OuiKeyedData;
import android.net.wifi.ParcelUtil;
import android.net.wifi.ScanResult;
import android.net.wifi.p2p.WifiP2pDirInfo;
import android.net.wifi.p2p.WifiP2pWfdInfo;
import android.net.wifi.util.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WifiP2pDevice
implements Parcelable {
    private static final String TAG = "WifiP2pDevice";
    public String deviceName = "";
    public String deviceAddress = "";
    @Nullable
    private MacAddress mInterfaceMacAddress;
    @Nullable
    private InetAddress mIpAddress;
    public String primaryDeviceType;
    public String secondaryDeviceType;
    private static final int WPS_CONFIG_DISPLAY = 8;
    private static final int WPS_CONFIG_PUSHBUTTON = 128;
    private static final int WPS_CONFIG_KEYPAD = 256;
    private static final int DEVICE_CAPAB_SERVICE_DISCOVERY = 1;
    private static final int DEVICE_CAPAB_CLIENT_DISCOVERABILITY = 2;
    private static final int DEVICE_CAPAB_CONCURRENT_OPER = 4;
    private static final int DEVICE_CAPAB_INFRA_MANAGED = 8;
    private static final int DEVICE_CAPAB_DEVICE_LIMIT = 16;
    private static final int DEVICE_CAPAB_INVITATION_PROCEDURE = 32;
    private static final int GROUP_CAPAB_GROUP_OWNER = 1;
    private static final int GROUP_CAPAB_PERSISTENT_GROUP = 2;
    private static final int GROUP_CAPAB_GROUP_LIMIT = 4;
    private static final int GROUP_CAPAB_INTRA_BSS_DIST = 8;
    private static final int GROUP_CAPAB_CROSS_CONN = 16;
    private static final int GROUP_CAPAB_PERSISTENT_RECONN = 32;
    private static final int GROUP_CAPAB_GROUP_FORMATION = 64;
    @UnsupportedAppUsage
    public int wpsConfigMethodsSupported;
    @UnsupportedAppUsage
    public int deviceCapability;
    @UnsupportedAppUsage
    public int groupCapability;
    public static final int CONNECTED = 0;
    public static final int INVITED = 1;
    public static final int FAILED = 2;
    public static final int AVAILABLE = 3;
    public static final int UNAVAILABLE = 4;
    public int status = 4;
    @UnsupportedAppUsage
    public WifiP2pWfdInfo wfdInfo;
    private List<ScanResult.InformationElement> mVendorElements;
    private static final Pattern detailedDevicePattern = Pattern.compile("((?:[0-9a-f]{2}:){5}[0-9a-f]{2}) (\\d+ )?p2p_dev_addr=((?:[0-9a-f]{2}:){5}[0-9a-f]{2}) pri_dev_type=(\\d+-[0-9a-fA-F]+-\\d+) name='(.*)' config_methods=(0x[0-9a-fA-F]+) dev_capab=(0x[0-9a-fA-F]+) group_capab=(0x[0-9a-fA-F]+)( wfd_dev_info=0x([0-9a-fA-F]{12}))?( wfd_r2_dev_info=0x([0-9a-fA-F]{4}))?");
    private static final Pattern twoTokenPattern = Pattern.compile("(p2p_dev_addr=)?((?:[0-9a-f]{2}:){5}[0-9a-f]{2})");
    private static final Pattern threeTokenPattern = Pattern.compile("(?:[0-9a-f]{2}:){5}[0-9a-f]{2} p2p_dev_addr=((?:[0-9a-f]{2}:){5}[0-9a-f]{2})");
    @NonNull
    private List<OuiKeyedData> mVendorData = Collections.emptyList();
    private int mPairingBootstrappingMethods;
    @Nullable
    public WifiP2pDirInfo dirInfo;
    @NonNull
    public static final Parcelable.Creator<WifiP2pDevice> CREATOR = new Parcelable.Creator<WifiP2pDevice>(){

        @Override
        public WifiP2pDevice createFromParcel(Parcel in) {
            WifiP2pDevice device = new WifiP2pDevice();
            device.deviceName = in.readString();
            device.deviceAddress = in.readString();
            device.mInterfaceMacAddress = (MacAddress)in.readParcelable(MacAddress.class.getClassLoader());
            if (in.readByte() == 1) {
                try {
                    device.mIpAddress = InetAddress.getByAddress(in.createByteArray());
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                    return new WifiP2pDevice();
                }
            }
            device.primaryDeviceType = in.readString();
            device.secondaryDeviceType = in.readString();
            device.wpsConfigMethodsSupported = in.readInt();
            device.deviceCapability = in.readInt();
            device.groupCapability = in.readInt();
            device.status = in.readInt();
            if (in.readInt() == 1) {
                device.wfdInfo = WifiP2pWfdInfo.CREATOR.createFromParcel(in);
            }
            device.mVendorElements = in.createTypedArrayList(ScanResult.InformationElement.CREATOR);
            device.mVendorData = ParcelUtil.readOuiKeyedDataList(in);
            device.mPairingBootstrappingMethods = in.readInt();
            return device;
        }

        public WifiP2pDevice[] newArray(int size) {
            return new WifiP2pDevice[size];
        }
    };

    @SystemApi
    @RequiresApi(value=35)
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @NonNull
    public List<OuiKeyedData> getVendorData() {
        if (!SdkLevel.isAtLeastV()) {
            throw new UnsupportedOperationException();
        }
        return this.mVendorData;
    }

    public WifiP2pDevice() {
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public WifiP2pDevice(String string2) throws IllegalArgumentException {
        String str;
        String[] tokens = string2.split("[ \n]");
        if (tokens.length < 1) {
            throw new IllegalArgumentException("Malformed supplicant event");
        }
        switch (tokens.length) {
            case 1: {
                this.deviceAddress = string2;
                return;
            }
            case 2: {
                Matcher match = twoTokenPattern.matcher(string2);
                if (!match.find()) {
                    throw new IllegalArgumentException("Malformed supplicant event");
                }
                this.deviceAddress = match.group(2);
                return;
            }
            case 3: {
                Matcher match = threeTokenPattern.matcher(string2);
                if (!match.find()) {
                    throw new IllegalArgumentException("Malformed supplicant event");
                }
                this.deviceAddress = match.group(1);
                return;
            }
        }
        Matcher match = detailedDevicePattern.matcher(string2);
        if (!match.find()) {
            throw new IllegalArgumentException("Malformed supplicant event");
        }
        this.deviceAddress = match.group(3);
        this.primaryDeviceType = match.group(4);
        this.deviceName = match.group(5);
        this.wpsConfigMethodsSupported = this.parseHex(match.group(6));
        this.deviceCapability = this.parseHex(match.group(7));
        this.groupCapability = this.parseHex(match.group(8));
        if (match.group(9) != null && null != (str = match.group(10))) {
            String r2str;
            this.wfdInfo = new WifiP2pWfdInfo(this.parseHex(str.substring(0, 4)), this.parseHex(str.substring(4, 8)), this.parseHex(str.substring(8, 12)));
            if (match.group(11) != null && SdkLevel.isAtLeastS() && null != (r2str = match.group(12))) {
                this.wfdInfo.setR2DeviceType(this.parseHex(r2str.substring(0, 4)));
            }
        }
        if (tokens[0].startsWith("P2P-DEVICE-FOUND")) {
            this.status = 3;
        }
    }

    @Nullable
    public WifiP2pWfdInfo getWfdInfo() {
        return this.wfdInfo;
    }

    public boolean wpsPbcSupported() {
        return (this.wpsConfigMethodsSupported & 0x80) != 0;
    }

    public boolean wpsKeypadSupported() {
        return (this.wpsConfigMethodsSupported & 0x100) != 0;
    }

    public boolean wpsDisplaySupported() {
        return (this.wpsConfigMethodsSupported & 8) != 0;
    }

    public boolean isServiceDiscoveryCapable() {
        return (this.deviceCapability & 1) != 0;
    }

    public boolean isInvitationCapable() {
        return (this.deviceCapability & 0x20) != 0;
    }

    public boolean isDeviceLimit() {
        return (this.deviceCapability & 0x10) != 0;
    }

    public boolean isGroupOwner() {
        return (this.groupCapability & 1) != 0;
    }

    public boolean isGroupLimit() {
        return (this.groupCapability & 4) != 0;
    }

    public void update(@NonNull WifiP2pDevice device) {
        this.updateSupplicantDetails(device);
        this.status = device.status;
    }

    public void updateSupplicantDetails(WifiP2pDevice device) {
        if (device == null) {
            throw new IllegalArgumentException("device is null");
        }
        if (device.deviceAddress == null) {
            throw new IllegalArgumentException("deviceAddress is null");
        }
        if (!this.deviceAddress.equals(device.deviceAddress)) {
            throw new IllegalArgumentException("deviceAddress does not match");
        }
        this.mInterfaceMacAddress = device.mInterfaceMacAddress;
        this.deviceName = device.deviceName;
        this.primaryDeviceType = device.primaryDeviceType;
        this.secondaryDeviceType = device.secondaryDeviceType;
        this.wpsConfigMethodsSupported = device.wpsConfigMethodsSupported;
        this.deviceCapability = device.deviceCapability;
        this.groupCapability = device.groupCapability;
        this.wfdInfo = device.wfdInfo;
    }

    public void setVendorElements(List<ScanResult.InformationElement> vendorElements) {
        if (vendorElements == null) {
            this.mVendorElements = null;
            return;
        }
        this.mVendorElements = new ArrayList<ScanResult.InformationElement>(vendorElements);
    }

    @SystemApi
    @RequiresApi(value=35)
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public void setVendorData(@NonNull List<OuiKeyedData> vendorData) {
        if (!SdkLevel.isAtLeastV()) {
            throw new UnsupportedOperationException();
        }
        if (vendorData == null) {
            throw new IllegalArgumentException("setVendorData received a null value");
        }
        this.mVendorData = vendorData;
    }

    @NonNull
    public List<ScanResult.InformationElement> getVendorElements() {
        if (this.mVendorElements == null) {
            return Collections.emptyList();
        }
        return new ArrayList<ScanResult.InformationElement>(this.mVendorElements);
    }

    @Nullable
    public MacAddress getInterfaceMacAddress() {
        return this.mInterfaceMacAddress;
    }

    public void setInterfaceMacAddress(@Nullable MacAddress interfaceAddress) {
        this.mInterfaceMacAddress = interfaceAddress;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @Nullable
    public InetAddress getIpAddress() {
        return this.mIpAddress;
    }

    public void setIpAddress(InetAddress ipAddress) {
        this.mIpAddress = ipAddress;
    }

    @RequiresApi(value=36)
    @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
    public boolean isOpportunisticBootstrappingMethodSupported() {
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        return (this.mPairingBootstrappingMethods & 1) != 0;
    }

    @RequiresApi(value=36)
    @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
    public boolean isPinCodeDisplayBootstrappingMethodSupported() {
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        return (this.mPairingBootstrappingMethods & 2) != 0;
    }

    @RequiresApi(value=36)
    @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
    public boolean isPassphraseDisplayBootstrappingMethodSupported() {
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        return (this.mPairingBootstrappingMethods & 4) != 0;
    }

    @RequiresApi(value=36)
    @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
    public boolean isPinCodeKeypadBootstrappingMethodSupported() {
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        return (this.mPairingBootstrappingMethods & 8) != 0;
    }

    @RequiresApi(value=36)
    @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
    public boolean isPassphraseKeypadBootstrappingMethodSupported() {
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        return (this.mPairingBootstrappingMethods & 0x10) != 0;
    }

    public int getPairingBootStrappingMethods() {
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        return this.mPairingBootstrappingMethods;
    }

    public void setPairingBootStrappingMethods(int methods) {
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        this.mPairingBootstrappingMethods = methods;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WifiP2pDevice)) {
            return false;
        }
        WifiP2pDevice other = (WifiP2pDevice)obj;
        if (other == null || other.deviceAddress == null) {
            return this.deviceAddress == null;
        }
        return other.deviceAddress.equals(this.deviceAddress);
    }

    public int hashCode() {
        return Objects.hashCode(this.deviceAddress);
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("Device: ").append(this.deviceName);
        sbuf.append("\n deviceAddress: ").append(this.deviceAddress);
        sbuf.append("\n interfaceMacAddress: ").append(this.mInterfaceMacAddress == null ? "none" : ((Object)this.mInterfaceMacAddress).toString());
        sbuf.append("\n ipAddress: ").append(this.mIpAddress == null ? "none" : this.mIpAddress.getHostAddress());
        sbuf.append("\n primary type: ").append(this.primaryDeviceType);
        sbuf.append("\n secondary type: ").append(this.secondaryDeviceType);
        sbuf.append("\n wps: ").append(this.wpsConfigMethodsSupported);
        sbuf.append("\n grpcapab: ").append(this.groupCapability);
        sbuf.append("\n devcapab: ").append(this.deviceCapability);
        sbuf.append("\n status: ").append(this.status);
        sbuf.append("\n wfdInfo: ").append(this.wfdInfo);
        sbuf.append("\n vendorElements: ").append(this.mVendorElements);
        sbuf.append("\n vendorData: ").append(this.mVendorData);
        sbuf.append("\n Pairing Bootstrapping Methods: ").append(this.mPairingBootstrappingMethods);
        return sbuf.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public WifiP2pDevice(WifiP2pDevice source) {
        if (source != null) {
            this.deviceName = source.deviceName;
            this.deviceAddress = source.deviceAddress;
            this.mInterfaceMacAddress = source.mInterfaceMacAddress;
            this.mIpAddress = source.mIpAddress;
            this.primaryDeviceType = source.primaryDeviceType;
            this.secondaryDeviceType = source.secondaryDeviceType;
            this.wpsConfigMethodsSupported = source.wpsConfigMethodsSupported;
            this.deviceCapability = source.deviceCapability;
            this.groupCapability = source.groupCapability;
            this.status = source.status;
            if (source.wfdInfo != null) {
                this.wfdInfo = new WifiP2pWfdInfo(source.wfdInfo);
            }
            if (null != source.mVendorElements) {
                this.mVendorElements = new ArrayList<ScanResult.InformationElement>(source.mVendorElements);
            }
            this.mVendorData = new ArrayList<OuiKeyedData>(source.mVendorData);
            this.mPairingBootstrappingMethods = source.mPairingBootstrappingMethods;
        }
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.deviceName);
        dest.writeString(this.deviceAddress);
        dest.writeParcelable(this.mInterfaceMacAddress, flags);
        if (this.mIpAddress != null) {
            dest.writeByte((byte)1);
            dest.writeByteArray(this.mIpAddress.getAddress());
        } else {
            dest.writeByte((byte)0);
        }
        dest.writeString(this.primaryDeviceType);
        dest.writeString(this.secondaryDeviceType);
        dest.writeInt(this.wpsConfigMethodsSupported);
        dest.writeInt(this.deviceCapability);
        dest.writeInt(this.groupCapability);
        dest.writeInt(this.status);
        if (this.wfdInfo != null) {
            dest.writeInt(1);
            this.wfdInfo.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
        dest.writeTypedList(this.mVendorElements);
        dest.writeList(this.mVendorData);
        dest.writeInt(this.mPairingBootstrappingMethods);
    }

    private int parseHex(String hexString) {
        int num = 0;
        if (hexString.startsWith("0x") || hexString.startsWith("0X")) {
            hexString = hexString.substring(2);
        }
        try {
            num = Integer.parseInt(hexString, 16);
        }
        catch (NumberFormatException e) {
            Log.e(TAG, "Failed to parse hex string " + hexString);
        }
        return num;
    }
}

