/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Objects;

@RequiresApi(value=36)
@FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
public class WifiP2pUsdBasedServiceDiscoveryConfig
implements Parcelable {
    private static final int USD_DEFAULT_DISCOVERY_CHANNEL_MHZ = 2437;
    private int mBand;
    private int[] mFrequenciesMhz;
    @NonNull
    public static final Parcelable.Creator<WifiP2pUsdBasedServiceDiscoveryConfig> CREATOR = new Parcelable.Creator<WifiP2pUsdBasedServiceDiscoveryConfig>(){

        @Override
        public WifiP2pUsdBasedServiceDiscoveryConfig createFromParcel(Parcel in) {
            return new WifiP2pUsdBasedServiceDiscoveryConfig(in);
        }

        public WifiP2pUsdBasedServiceDiscoveryConfig[] newArray(int size) {
            return new WifiP2pUsdBasedServiceDiscoveryConfig[size];
        }
    };

    private WifiP2pUsdBasedServiceDiscoveryConfig(int band, @NonNull int[] frequencies) {
        this.mBand = band;
        this.mFrequenciesMhz = frequencies;
    }

    public int getBand() {
        return this.mBand;
    }

    @Nullable
    public int[] getFrequenciesMhz() {
        return this.mFrequenciesMhz;
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder("WifiP2pUsdBasedServiceDiscoveryConfig:");
        sbuf.append("\n Band: ").append(this.mBand);
        sbuf.append("\n Frequencies: ").append(this.mFrequenciesMhz == null ? "<null>" : Arrays.toString(this.mFrequenciesMhz));
        return sbuf.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mBand);
        dest.writeIntArray(this.mFrequenciesMhz);
    }

    private WifiP2pUsdBasedServiceDiscoveryConfig(@NonNull Parcel in) {
        this.mBand = in.readInt();
        this.mFrequenciesMhz = in.createIntArray();
    }

    private static boolean isBandValid(int band) {
        int bandAny = 11;
        return band != 0 && (band & ~bandAny) == 0;
    }

    public static class Builder {
        private static final int MAXIMUM_CHANNEL_FREQUENCIES = 48;
        private int mBand = -1;
        private int[] mFrequenciesMhz = new int[]{2437};

        @NonNull
        public Builder setBand(int band) {
            if (!WifiP2pUsdBasedServiceDiscoveryConfig.isBandValid(band)) {
                throw new IllegalArgumentException("Invalid band: " + band);
            }
            this.mBand = band;
            return this;
        }

        @NonNull
        public Builder setFrequenciesMhz(@NonNull int[] frequenciesMhz) {
            Objects.requireNonNull(frequenciesMhz, "Frequencies cannot be null");
            if (frequenciesMhz.length < 1 || frequenciesMhz.length > 48) {
                throw new IllegalArgumentException("Number of frequencies: " + frequenciesMhz.length + " must be between 1 and " + 48);
            }
            this.mFrequenciesMhz = frequenciesMhz;
            return this;
        }

        @NonNull
        public WifiP2pUsdBasedServiceDiscoveryConfig build() {
            if (this.mBand != -1 && this.mFrequenciesMhz != null) {
                throw new IllegalStateException("Frequencies and band are mutually exclusive.");
            }
            return new WifiP2pUsdBasedServiceDiscoveryConfig(this.mBand, this.mFrequenciesMhz);
        }
    }
}

