/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p.nsd;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.wifi.p2p.nsd.WifiP2pUsdBasedServiceConfig;
import android.net.wifi.util.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.wifi.x.com.android.wifi.flags.Flags;
import java.util.Locale;
import java.util.Objects;

public class WifiP2pServiceRequest
implements Parcelable {
    private int mProtocolType;
    private int mLength;
    private int mTransId;
    private String mQuery;
    private WifiP2pUsdBasedServiceConfig mUsdServiceConfig;
    private int mUsdSessionId = 0;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @NonNull
    public static final Parcelable.Creator<WifiP2pServiceRequest> CREATOR = new Parcelable.Creator<WifiP2pServiceRequest>(){

        @Override
        public WifiP2pServiceRequest createFromParcel(Parcel in) {
            int servType = in.readInt();
            int length = in.readInt();
            int transId = in.readInt();
            String query = in.readString();
            WifiP2pUsdBasedServiceConfig config = null;
            int usdSessionId = 0;
            if (Environment.isSdkAtLeastB() && Flags.wifiDirectR2()) {
                config = (WifiP2pUsdBasedServiceConfig)in.readParcelable(WifiP2pUsdBasedServiceConfig.class.getClassLoader());
                usdSessionId = in.readInt();
            }
            return new WifiP2pServiceRequest(servType, length, transId, query, config, usdSessionId);
        }

        public WifiP2pServiceRequest[] newArray(int size) {
            return new WifiP2pServiceRequest[size];
        }
    };

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    protected WifiP2pServiceRequest(int protocolType, String query) {
        this.validateQuery(query);
        this.mProtocolType = protocolType;
        this.mQuery = query;
        this.mLength = query != null ? query.length() / 2 + 2 : 2;
    }

    private WifiP2pServiceRequest(int serviceType, int length, int transId, String query, @NonNull WifiP2pUsdBasedServiceConfig usdConfig, int usdSessionId) {
        this.mProtocolType = serviceType;
        this.mLength = length;
        this.mTransId = transId;
        this.mQuery = query;
        this.mUsdServiceConfig = usdConfig;
        this.mUsdSessionId = usdSessionId;
    }

    public int getTransactionId() {
        return this.mTransId;
    }

    public void setTransactionId(int id2) {
        this.mTransId = id2;
    }

    public String getSupplicantQuery() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.format(Locale.US, "%02x", this.mLength & 0xFF));
        sb.append(String.format(Locale.US, "%02x", this.mLength >> 8 & 0xFF));
        sb.append(String.format(Locale.US, "%02x", this.mProtocolType));
        sb.append(String.format(Locale.US, "%02x", this.mTransId));
        if (this.mQuery != null) {
            sb.append(this.mQuery);
        }
        return sb.toString();
    }

    public int getUsdSessionId() {
        return this.mUsdSessionId;
    }

    public void setUsdSessionId(int sessionId) {
        this.mUsdSessionId = sessionId;
    }

    @RequiresApi(value=36)
    @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
    @Nullable
    public WifiP2pUsdBasedServiceConfig getWifiP2pUsdBasedServiceConfig() {
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        return this.mUsdServiceConfig;
    }

    private void validateQuery(String query) {
        char[] chars;
        if (query == null) {
            return;
        }
        int UNSIGNED_SHORT_MAX = 65535;
        if (query.length() % 2 == 1) {
            throw new IllegalArgumentException("query size is invalid. query=" + query);
        }
        if (query.length() / 2 > UNSIGNED_SHORT_MAX) {
            throw new IllegalArgumentException("query size is too large. len=" + query.length());
        }
        query = query.toLowerCase(Locale.ROOT);
        for (char c : chars = query.toCharArray()) {
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f') continue;
            throw new IllegalArgumentException("query should be hex string. query=" + query);
        }
    }

    public static WifiP2pServiceRequest newInstance(int protocolType, String queryData) {
        return new WifiP2pServiceRequest(protocolType, queryData);
    }

    public static WifiP2pServiceRequest newInstance(int protocolType) {
        return new WifiP2pServiceRequest(protocolType, null);
    }

    @RequiresApi(value=36)
    @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
    public WifiP2pServiceRequest(@NonNull WifiP2pUsdBasedServiceConfig usdConfig) {
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        Objects.requireNonNull(usdConfig, "usdConfig cannot be null");
        this.mUsdServiceConfig = usdConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WifiP2pServiceRequest)) {
            return false;
        }
        WifiP2pServiceRequest req = (WifiP2pServiceRequest)o;
        return this.mProtocolType == req.mProtocolType && this.mLength == req.mLength && Objects.equals(this.mQuery, req.mQuery) && Objects.equals(this.mUsdServiceConfig, req.mUsdServiceConfig);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.mProtocolType;
        result = 31 * result + this.mLength;
        result = 31 * result + (this.mQuery == null ? 0 : this.mQuery.hashCode());
        result = 31 * result + (this.mUsdServiceConfig == null ? 0 : this.mUsdServiceConfig.hashCode());
        return result;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mProtocolType);
        dest.writeInt(this.mLength);
        dest.writeInt(this.mTransId);
        dest.writeString(this.mQuery);
        if (Environment.isSdkAtLeastB() && Flags.wifiDirectR2()) {
            dest.writeParcelable(this.mUsdServiceConfig, flags);
            dest.writeInt(this.mUsdSessionId);
        }
    }
}

